/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.entities;

import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.compat.CuriosAPI;
import com.endertech.minecraft.forge.math.AABBHelper;
import com.endertech.minecraft.forge.math.GameMath;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.math.Rotation;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.world.GameWorld;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BrushItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.packets.SpawnEntity;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class ForgeEntity
extends Entity {
    public ForgeEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    public ForgeEntity(SpawnEntity entity, Level world) {
        super(entity.getEntity().getType(), world);
    }

    public Vect3d getBBCenter() {
        return GameMath.getBBCenter(this.getBB());
    }

    public static boolean isEating(LivingEntity living) {
        if (living.isUsingItem()) {
            ItemStack item = living.getItemInHand(living.getUsedItemHand());
            return item.has(DataComponents.FOOD);
        }
        return false;
    }

    public static boolean isHostileMob(Entity entity) {
        return entity instanceof Enemy;
    }

    public static Vect3d getCenteredPosTo(BlockPos pos) {
        return GameWorld.getBlockCenter(pos).withY(pos.getY());
    }

    public static Vect3d getCenterPosition(Entity entity) {
        return GameMath.getBBCenter(ForgeEntity.getBB(entity));
    }

    public static Vect3d getCenterPosition(Entity entity, float tickProgress) {
        return GameMath.getBBCenter(ForgeEntity.getBB(entity, ForgeEntity.getCurPosition(entity, tickProgress)));
    }

    public static InteractionHand otherHand(InteractionHand hand) {
        return hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
    }

    public static Optional<Entity> getById(Level level, int id) {
        return Optional.ofNullable(level.getEntity(id));
    }

    public static ResourceLocation getRegistryName(Entity entity) {
        return ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.getType());
    }

    public static Vect3d getMotion(Entity entity) {
        return Vect3d.from(entity.getDeltaMovement());
    }

    public static void setMotion(Entity entity, Vect3d vec) {
        entity.setDeltaMovement(vec.x, vec.y, vec.z);
    }

    public void setMotion(Vect3d vec) {
        ForgeEntity.setMotion(this, vec);
    }

    public void move() {
        this.setPrevPosition(this.getCurPosition());
        this.setCurPosition(this.getCurPosition().add(this.getCurMotion()));
    }

    public Vect3d getCurMotion() {
        return Vect3d.from(this.getDeltaMovement());
    }

    public static void addMotion(Entity entity, Vect3d vec) {
        if (entity != null && vec != null) {
            ForgeEntity.setMotion(entity, ForgeEntity.getMotion(entity).add(vec));
        }
    }

    public void addMotion(Vect3d vec) {
        ForgeEntity.addMotion(this, vec);
    }

    public void addMotion(double dx, double dy, double dz) {
        this.addMotion(Vect3d.from(dx, dy, dz));
    }

    public static void copyAllPositionsWithOffset(Entity source, Entity target, Vect3d offset) {
        if (source != null && target != null) {
            ForgeEntity.setPrevPosition(target, ForgeEntity.getPrevPosition(source).add(offset));
            ForgeEntity.setLastTickPosition(target, ForgeEntity.getLastTickPosition(source).add(offset));
            ForgeEntity.setCurPosition(target, ForgeEntity.getCurPosition(source).add(offset));
        }
    }

    public static BlockPos getPosition(Entity entity) {
        return BlockPos.containing((double)entity.getX(), (double)entity.getY(), (double)entity.getZ());
    }

    public static Vect3d getCurPosition(Entity entity) {
        return entity != null ? Vect3d.from(entity.getX(), entity.getY(), entity.getZ()) : Vect3d.ZERO;
    }

    public static Vect3d getCurPosition(Entity entity, float tickProgress) {
        return Vect3d.approx(tickProgress, ForgeEntity.getLastTickPosition(entity), ForgeEntity.getCurPosition(entity));
    }

    public Vect3d getCurPosition() {
        return ForgeEntity.getCurPosition(this);
    }

    public Vect3d getCurPosition(float tickProgress) {
        return ForgeEntity.getCurPosition(this, tickProgress);
    }

    public static BlockPos getPositionEyes(Entity entity) {
        double y = entity.getY() + (double)entity.getEyeHeight();
        return BlockPos.containing((double)entity.getX(), (double)y, (double)entity.getZ());
    }

    public static BlockPos getPositionTop(Entity entity) {
        double y = entity.getY() + (double)entity.getBbHeight();
        return BlockPos.containing((double)entity.getX(), (double)y, (double)entity.getZ());
    }

    public static Rotation getPrevRotation(Entity entity) {
        return entity != null ? new Rotation(entity.xRotO, entity.yRotO) : Rotation.ZERO;
    }

    public static Rotation getRotation(Entity entity) {
        return entity != null ? new Rotation(entity.getXRot(), entity.getYRot()) : Rotation.ZERO;
    }

    public static Rotation getRotation(Entity entity, float tickProgress) {
        return ForgeEntity.getPrevRotation(entity).approx(tickProgress, ForgeEntity.getRotation(entity));
    }

    public Rotation getRotation(float tickProgress) {
        return ForgeEntity.getRotation(this, tickProgress);
    }

    public Rotation getPrevRotation() {
        return ForgeEntity.getPrevRotation(this);
    }

    public Rotation getCurRotation() {
        return ForgeEntity.getRotation(this);
    }

    public static Vect3d getLastTickPosition(Entity entity) {
        return entity != null ? Vect3d.from(entity.xOld, entity.yOld, entity.zOld) : Vect3d.ZERO;
    }

    public Vect3d getLastTickPosition() {
        return ForgeEntity.getLastTickPosition(this);
    }

    public static Vect3d getPrevPosition(Entity entity) {
        return entity != null ? Vect3d.from(entity.xo, entity.yo, entity.zo) : Vect3d.ZERO;
    }

    public Vect3d getPrevPosition() {
        return ForgeEntity.getPrevPosition(this);
    }

    public static Vect3d getNextPosition(Entity entity) {
        return entity != null ? ForgeEntity.getCurPosition(entity).add(ForgeEntity.getMotion(entity)) : Vect3d.ZERO;
    }

    public Vect3d getNextPosition() {
        return ForgeEntity.getNextPosition(this);
    }

    public static void setCurPosition(Entity entity, Vect3d vec) {
        if (entity != null && vec != null) {
            entity.setPos(vec.x, vec.y, vec.z);
        }
    }

    public static void setPosition_NoBB(Entity entity, Vect3d vec) {
        if (entity != null && vec != null) {
            entity.setPosRaw(vec.x, vec.y, vec.z);
        }
    }

    public static void setLastTickPosition(Entity entity, Vect3d vec) {
        if (entity != null && vec != null) {
            entity.xOld = vec.x;
            entity.yOld = vec.y;
            entity.zOld = vec.z;
        }
    }

    public void setLastTickPosition(Vect3d vec) {
        ForgeEntity.setLastTickPosition(this, vec);
    }

    public static void setPrevPosition(Entity entity, Vect3d vec) {
        ForgeEntity.setLastTickPosition(entity, vec);
        if (entity != null && vec != null) {
            entity.xo = vec.x;
            entity.yo = vec.y;
            entity.zo = vec.z;
        }
    }

    public void setPrevPosition(Vect3d vec) {
        ForgeEntity.setPrevPosition(this, vec);
    }

    public void setCurPosition(Vect3d vec) {
        ForgeEntity.setCurPosition(this, vec);
    }

    public static void setPrevRotation(Entity entity, Rotation rotation) {
        if (entity != null && rotation != null) {
            entity.xRotO = rotation.pitch;
            entity.yRotO = rotation.yaw;
        }
    }

    public void setPrevRotation(Rotation rotation) {
        ForgeEntity.setPrevRotation(this, rotation);
    }

    public static void setRotation(Entity entity, Rotation rotation) {
        if (entity != null && rotation != null) {
            entity.setXRot(rotation.pitch);
            entity.setYRot(rotation.yaw);
        }
    }

    public void setCurRotation(Rotation rotation) {
        ForgeEntity.setRotation(this, rotation);
    }

    public static void setAllPositions(Entity entity, Vect3d vec) {
        if (entity != null && vec != null) {
            entity.xOld = entity.xo = vec.x;
            entity.yOld = entity.yo = vec.y;
            entity.zOld = entity.zo = vec.z;
            ForgeEntity.setCurPosition(entity, vec);
        }
    }

    public void setAllPositions(Vect3d vec) {
        ForgeEntity.setAllPositions(this, vec);
    }

    public static void setAllRotations(Entity entity, Rotation rotation) {
        if (entity != null && rotation != null) {
            entity.xRotO = rotation.pitch;
            entity.setXRot(rotation.pitch);
            entity.yRotO = rotation.yaw;
            entity.setYRot(rotation.yaw);
        }
    }

    public void setAllRotations(Rotation rotation) {
        ForgeEntity.setAllRotations(this, rotation);
    }

    public static float getSize(Entity entity) {
        if (entity != null) {
            return entity.getBbWidth() * entity.getBbHeight();
        }
        return 0.0f;
    }

    public static List<Entity> getRootVehicleWithAllPassengers(Entity entity) {
        if (entity != null) {
            ArrayList<Entity> collection = new ArrayList<Entity>();
            Entity rootVehicle = entity.getRootVehicle();
            rootVehicle.getIndirectPassengers().forEach(collection::add);
            collection.add(rootVehicle);
            return Collections.unmodifiableList(collection);
        }
        return Collections.emptyList();
    }

    public static float getWeight(Entity entity, boolean includeAllConnected) {
        float weight = 0.0f;
        if (entity != null) {
            if (includeAllConnected) {
                for (Entity connected : ForgeEntity.getRootVehicleWithAllPassengers(entity)) {
                    weight += ForgeEntity.getWeight(connected, false);
                }
            } else {
                weight += ForgeEntity.getSize(entity);
            }
        }
        return weight;
    }

    public static Direction getFacingTo(BlockPos targetPos, LivingEntity entity) {
        double dist = 2.0;
        if (Math.abs(entity.getX() - (double)targetPos.getX()) < 2.0 && Math.abs(entity.getZ() - (double)targetPos.getZ()) < 2.0) {
            double eyeY = entity.getY() + (double)entity.getEyeHeight();
            if (eyeY - (double)targetPos.getY() > 2.0) {
                return Direction.DOWN;
            }
            if ((double)targetPos.getY() - eyeY > 0.0) {
                return Direction.UP;
            }
        }
        return entity.getDirection();
    }

    public static void setFallDistance(Entity entity, float distance, boolean includeAllConnected) {
        if (entity != null) {
            if (includeAllConnected) {
                for (Entity connected : ForgeEntity.getRootVehicleWithAllPassengers(entity)) {
                    ForgeEntity.setFallDistance(connected, distance, false);
                }
            } else {
                entity.fallDistance = distance;
            }
        }
    }

    public static void updateBB(Entity entity) {
        if (entity != null) {
            entity.setBoundingBox(ForgeEntity.getBB(entity, ForgeEntity.getCurPosition(entity)));
        }
    }

    public static AABB getBB(Entity entity, Vect3d position) {
        if (entity != null && position != null) {
            double widthHalf = (double)entity.getBbWidth() / 2.0;
            return new AABB(position.x - widthHalf, position.y, position.z - widthHalf, position.x + widthHalf, position.y + (double)entity.getBbHeight(), position.z + widthHalf);
        }
        return AABBHelper.ZERO;
    }

    public static AABB getBB(Entity entity) {
        return ForgeEntity.getBB(entity, ForgeEntity.getCurPosition(entity));
    }

    public AABB getBB(Vect3d position) {
        return ForgeEntity.getBB(this, position);
    }

    public AABB getBB() {
        return ForgeEntity.getBB(this, this.getCurPosition());
    }

    public void updateBB() {
        ForgeEntity.updateBB(this);
    }

    public static void stopMoving(Entity entity) {
        if (entity != null) {
            ForgeEntity.setMotion(entity, Vect3d.ZERO);
        }
    }

    public void stopMoving() {
        ForgeEntity.stopMoving(this);
    }

    public static boolean isUnderRain(Entity entity) {
        BlockPos pos = ForgeEntity.getPositionTop(entity);
        return ForgeBlock.isUnderRain(entity.level(), pos);
    }

    public static boolean isUnderOpenSky(Entity entity) {
        BlockPos pos = ForgeEntity.getPositionTop(entity);
        return ForgeBlock.isUnderOpenSky(entity.level(), pos);
    }

    public static boolean isServerSide(Entity entity) {
        if (entity != null) {
            return GameWorld.isServerSide((LevelReader)entity.level());
        }
        return false;
    }

    public boolean isServerSide() {
        return ForgeEntity.isServerSide(this);
    }

    public static boolean isClientSide(Entity entity) {
        if (entity != null) {
            return GameWorld.isClientSide((LevelReader)entity.level());
        }
        return false;
    }

    public boolean isClientSide() {
        return ForgeEntity.isClientSide(this);
    }

    public <E extends Entity> List<E> getCollidedWithIfMove(Class<E> clazz, Vect3d motion, Predicate<? super E> filter) {
        return this.level().getEntitiesOfClass(clazz, this.getBB(this.getNextPosition()), filter.and(e -> !e.equals((Object)this)));
    }

    public static void setBB(Entity entity, Vect3d minPoint, Vect3d maxPoint) {
        if (entity != null && minPoint != null && maxPoint != null) {
            entity.setBoundingBox(new AABB(minPoint.x, minPoint.y, minPoint.z, maxPoint.x, maxPoint.y, maxPoint.z));
        }
    }

    public void setBB(Vect3d minPoint, Vect3d maxPoint) {
        ForgeEntity.setBB(this, minPoint, maxPoint);
    }

    public static boolean hasSwingingPlayerPassenger(Entity entity) {
        if (entity != null) {
            for (Entity passenger : entity.getPassengers()) {
                if (!(passenger instanceof Player) || !((Player)passenger).swinging) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasSwingingPlayerPassenger() {
        return ForgeEntity.hasSwingingPlayerPassenger(this);
    }

    public static boolean hasBrushInHand(LivingEntity entity, InteractionHand hand) {
        ItemStack stack = entity.getItemInHand(hand);
        return stack.getItem() instanceof BrushItem;
    }

    public static boolean hasStack(Entity entity, ItemStack stack) {
        if (entity instanceof ItemEntity) {
            return ((ItemEntity)entity).getItem().equals(stack);
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player.getInventory().contains(stack);
        }
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            for (ItemStack equiped : living.getAllSlots()) {
                if (!equiped.equals(stack)) continue;
                return true;
            }
        }
        return false;
    }

    public static Optional<BlockHitResult> rayTraceBlockBeingLookedAt(Entity entity, ClipContext.Block blockMode, ClipContext.Fluid fluidMode, float partialTicks, float reachDistance) {
        Vec3 startVec = entity.getEyePosition(partialTicks);
        Vec3 lookVec = entity.getViewVector(partialTicks).scale((double)reachDistance);
        Vec3 endVec = startVec.add(lookVec);
        ClipContext context = new ClipContext(startVec, endVec, blockMode, fluidMode, entity);
        BlockHitResult hit = entity.level().clip(context);
        return hit != null && hit.getType() != HitResult.Type.MISS ? Optional.of(hit) : Optional.empty();
    }

    public static Optional<EntityHitResult> rayTraceEntityBeingLookedAt(Entity entity, float partialTicks, float reachDistance) {
        Vec3 startVec = entity.getEyePosition(partialTicks);
        Vec3 lookVec = entity.getViewVector(partialTicks).scale((double)reachDistance);
        Vec3 endVec = startVec.add(lookVec);
        AABB boundingBox = entity.getBoundingBox().expandTowards(lookVec).inflate(1.0, 1.0, 1.0);
        double minDistance = Double.MAX_VALUE;
        Entity closestTarget = null;
        Vec3 closestHit = null;
        for (Entity target : entity.level().getEntitiesOfClass(Entity.class, boundingBox, EntitySelector.NO_SPECTATORS.and(ent -> ent != entity))) {
            double distance;
            AABB aabb = target.getBoundingBox().inflate(0.3);
            Vec3 hit = aabb.clip(startVec, endVec).orElse(null);
            if (hit == null || !((distance = startVec.distanceToSqr(hit)) < minDistance)) continue;
            closestTarget = target;
            closestHit = hit;
            minDistance = distance;
        }
        return closestTarget != null && closestHit != null ? Optional.of(new EntityHitResult(closestTarget, closestHit)) : Optional.empty();
    }

    public static Iterable<ItemStack> getEquipmentOn(Entity entity) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            for (ItemStack stack : living.getArmorSlots()) {
                if (stack.isEmpty()) continue;
                list.add(stack);
            }
            for (ItemStack stack : (Collection)CuriosAPI.getInstance().map(curios -> curios.getAllSlots(living)).orElse(Collections.emptyList())) {
                if (stack.isEmpty()) continue;
                list.add(stack);
            }
        }
        return list;
    }

    public static Percentage getAirShortage(Entity entity) {
        int supply = entity.getAirSupply();
        int max = entity.getMaxAirSupply();
        int shortage = max - supply;
        return Percentage.from(shortage, max);
    }
}

