/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.world;

import com.endertech.common.CommonTime;
import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.blocks.BlockStatesMap;
import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.blocks.IPole;
import com.endertech.minecraft.forge.blocks.IPollutant;
import com.endertech.minecraft.forge.blocks.ISmokeContainer;
import com.endertech.minecraft.forge.compat.Weather2;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.events.ChunkFullyLoadedEvent;
import com.endertech.minecraft.forge.math.GameMath;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.world.BiomeId;
import com.endertech.minecraft.forge.world.Biomes;
import com.endertech.minecraft.forge.world.IWind;
import com.endertech.minecraft.forge.world.Wind;
import com.endertech.minecraft.forge.world.WorldSearch;
import com.google.common.collect.Lists;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public final class GameWorld {
    public static boolean isBlockLoaded(LevelReader level, BlockPos pos) {
        return level.hasChunkAt(pos);
    }

    public static boolean isAirBlock(LevelReader level, BlockPos pos) {
        return level.getBlockState(pos).isAir();
    }

    public static boolean isGlassBlock(LevelReader level, BlockPos pos) {
        return ForgeBlock.isGlass(level.getBlockState(pos));
    }

    public static boolean isLiquidBlock(LevelReader level, BlockPos pos) {
        return ForgeBlock.isLiquid(level.getBlockState(pos));
    }

    public static boolean isWaterBlock(LevelReader level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        return ForgeBlock.isLiquid(state) && state.getFluidState().is(FluidTags.WATER);
    }

    public static boolean isWaterSource(LevelReader level, BlockPos pos) {
        FluidState state = level.getFluidState(pos);
        return state.isSource() && state.is(FluidTags.WATER);
    }

    public static boolean isLavaBlock(LevelReader level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        return ForgeBlock.isLiquid(state) && state.getFluidState().is(FluidTags.LAVA);
    }

    public static boolean isLavaSource(LevelReader level, BlockPos pos) {
        FluidState state = level.getFluidState(pos);
        return state.isSource() && state.is(FluidTags.LAVA);
    }

    public static boolean isOreBlock(LevelReader level, BlockPos pos, BlockState state) {
        return state.is(Tags.Blocks.ORES);
    }

    public static IWind getWindAt(Level level, BlockPos pos) {
        return Weather2.getInstance().flatMap(weather2 -> weather2.getWindAt(level, pos)).orElseGet(() -> GameWorld.getData((LevelAccessor)level).getWind(BiomeId.from((LevelAccessor)level, pos)));
    }

    public static void scheduleBlockExplosion(ServerLevel level, BlockPos pos, CommonTime.Interval delay, float size, boolean fire, Level.ExplosionInteraction interaction, boolean dropAsItem, @Nullable Entity exploder) {
        WorldData data = GameWorld.getData((LevelAccessor)level);
        ScheduledExplosion explosion = new ScheduledExplosion(level, pos, delay, size, fire, interaction, exploder);
        data.scheduledExplosions.put(pos, explosion);
    }

    public static boolean isServerSide(LevelReader level) {
        return !level.isClientSide();
    }

    public static boolean isClientSide(LevelReader level) {
        return level.isClientSide();
    }

    public static Optional<Entity> getEntity(Level level, int id) {
        return level != null ? Optional.ofNullable(level.getEntity(id)) : Optional.empty();
    }

    public static Vect3d getBlockCenter(BlockPos pos) {
        return Vect3d.from(pos).add(GameMath.getBBCenter(ForgeBlock.FULL_BLOCK_AABB));
    }

    public static void spawnParticle(Level level, Vect3d pos, Vect3d motion, ParticleOptions particleData) {
        level.addParticle(particleData, pos.x, pos.y, pos.z, motion.x, motion.y, motion.z);
    }

    public static Optional<BlockHitResult> rayTraceBlocks(Level level, Vect3d start, Vect3d end, ClipContext.Block blockMode, ClipContext.Fluid fluidMode, Entity entity) {
        ClipContext context = new ClipContext(start.toVector3d(), end.toVector3d(), blockMode, fluidMode, entity);
        BlockHitResult hit = level.clip(context);
        return hit != null && hit.getType() != HitResult.Type.MISS ? Optional.of(hit) : Optional.empty();
    }

    @Nonnull
    public static WorldData getData(LevelAccessor level) {
        WorldData data = WorldData.DATA_MAP.get(level);
        if (data == null) {
            data = new WorldData(level);
            WorldData.DATA_MAP.put(level, data);
        }
        return data;
    }

    @Mod.EventBusSubscriber
    public static class WorldData {
        static final Map<LevelAccessor, WorldData> DATA_MAP = new ConcurrentHashMap<LevelAccessor, WorldData>();
        public int smokeParticlesCount = 0;
        protected final Map<BiomeId, Wind> biomeWindMap = new ConcurrentHashMap<BiomeId, Wind>();
        protected final Map<BlockPos, ScheduledExplosion> scheduledExplosions = new ConcurrentHashMap<BlockPos, ScheduledExplosion>();
        protected final Deque<LevelChunk> freshlyLoadedChunks = new ConcurrentLinkedDeque<LevelChunk>();
        private final LevelAccessor level;

        public WorldData(LevelAccessor level) {
            this.level = level;
        }

        public LevelAccessor getLevel() {
            return this.level;
        }

        @SubscribeEvent
        public static void onLevelLoad(LevelEvent.Load event) {
            LevelAccessor level = event.getLevel();
            if (GameWorld.isServerSide((LevelReader)level)) {
                WorldData data = GameWorld.getData(level);
                data.initBiomesWinds();
            }
        }

        @SubscribeEvent
        public static void onLevelUnload(LevelEvent.Unload event) {
            LevelAccessor level = event.getLevel();
            DATA_MAP.remove(level);
        }

        @SubscribeEvent
        public static void onLevelTick(TickEvent.LevelTickEvent event) {
            if (event.phase != TickEvent.Phase.START) {
                return;
            }
            Level level = event.level;
            WorldData data = GameWorld.getData((LevelAccessor)level);
            Wind.defaultWind.update(level);
            for (Wind wind : data.biomeWindMap.values()) {
                wind.update(level);
            }
            if (level instanceof ServerLevel) {
                Iterator<Object> iterator = data.freshlyLoadedChunks.iterator();
                while (iterator.hasNext()) {
                    LevelChunk chunk = iterator.next();
                    ChunkPos chunkPos = chunk.getPos();
                    if (!level.getChunkSource().hasChunk(chunkPos.x, chunkPos.z)) continue;
                    ChunkFullyLoadedEvent.onChunkFullyLoaded((ServerLevel)level, chunk);
                    iterator.remove();
                }
                iterator = data.scheduledExplosions.values().iterator();
                while (iterator.hasNext()) {
                    ScheduledExplosion explosion = (ScheduledExplosion)iterator.next();
                    if (!explosion.timePast()) continue;
                    level.explode(explosion.exploder, (double)explosion.pos.getX(), (double)explosion.pos.getY(), (double)explosion.pos.getZ(), explosion.size, explosion.fire, explosion.interaction);
                    iterator.remove();
                    break;
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            Level level = player.level();
            if (GameWorld.isServerSide((LevelReader)level) && player instanceof ServerPlayer) {
                WorldData data = GameWorld.getData((LevelAccessor)level);
                for (Wind wind : data.biomeWindMap.values()) {
                    Wind.WindMsg message = new Wind.WindMsg(wind);
                    ForgeEndertech.getInstance().getConnection().sendToPlayer(message, (ServerPlayer)player);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
            Level level = event.player.level();
            if (GameWorld.isClientSide((LevelReader)level)) {
                Wind.defaultWind.update(level);
                WorldData data = GameWorld.getData((LevelAccessor)level);
                for (Wind wind : data.biomeWindMap.values()) {
                    wind.update(level);
                }
            }
        }

        @SubscribeEvent
        public static void onChunkLoad(ChunkEvent.Load event) {
            LevelChunk chunk;
            Level level;
            ChunkAccess chunkAccess = event.getChunk();
            if (chunkAccess instanceof LevelChunk && (level = (chunk = (LevelChunk)chunkAccess).getLevel()) instanceof ServerLevel) {
                GameWorld.getData((LevelAccessor)level).freshlyLoadedChunks.addLast(chunk);
            }
        }

        @SubscribeEvent
        public static void onChunkUnload(ChunkEvent.Unload event) {
            LevelChunk chunk;
            Level level;
            ChunkAccess chunkAccess = event.getChunk();
            if (chunkAccess instanceof LevelChunk && (level = (chunk = (LevelChunk)chunkAccess).getLevel()) instanceof ServerLevel) {
                GameWorld.getData((LevelAccessor)level).freshlyLoadedChunks.removeAll(Collections.singleton(chunk));
            }
        }

        protected void initBiomesWinds() {
            Biomes.registries().findFirst().map(Registry::registryKeySet).map(Collection::stream).flatMap(Stream::findFirst).map(BiomeId::from).ifPresent(biome -> Wind.from(Biomes.createConfigFor(ForgeEndertech.getInstance(), biome, false), biome));
            this.biomeWindMap.clear();
            for (Path path : UnitConfig.listCustomConfigs(Biomes.getConfigsBaseDir(ForgeEndertech.getInstance()), null)) {
                UnitConfig config = new UnitConfig(path.toFile());
                BiomeId biome2 = Biomes.readBiomeId(config);
                boolean enabled = Biomes.isConfigEnabled(config);
                Wind wind = Wind.from(config, biome2);
                if (!enabled || biome2.isEmpty() || wind.equalsDefault()) continue;
                this.biomeWindMap.put(biome2, wind);
            }
        }

        @Nonnull
        public Wind getWind(BiomeId biome) {
            return this.biomeWindMap.getOrDefault(biome, Wind.defaultWind);
        }
    }

    public static class ScheduledExplosion {
        public final ServerLevel level;
        public final BlockPos pos;
        public final CommonTime.Interval delay;
        public final float size;
        public final boolean fire;
        public final Level.ExplosionInteraction interaction;
        @Nullable
        public final Entity exploder;
        protected final CommonTime.Stamp stamp = CommonTime.Stamp.now();

        public ScheduledExplosion(ServerLevel level, BlockPos pos, CommonTime.Interval delay, float size, boolean fire, Level.ExplosionInteraction interaction, @Nullable Entity exploder) {
            this.level = level;
            this.pos = pos;
            this.delay = delay;
            this.size = size;
            this.fire = fire;
            this.exploder = exploder;
            this.interaction = interaction;
        }

        public boolean timePast() {
            return CommonTime.Interval.passedFrom(this.stamp).moreThan(this.delay);
        }
    }

    public static class SmokeContainers<C extends ISmokeContainer> {
        public static final TagKey<Block> CHIMNEYS = BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"forge", (String)"chimneys"));
        public static ForgeConfigSpec.ConfigValue<Integer> maxVentPipeLength;
        public static ForgeConfigSpec.ConfigValue<Integer> ventReachDistance;
        public static ForgeConfigSpec.ConfigValue<Integer> maxBlocksInMultiblock;
        public static ForgeConfigSpec.ConfigValue<Integer> pumpedChimneyAirflow;
        public static ForgeConfigSpec.ConfigValue<List<? extends String>> suctionHoppersList;
        public static BlockStatesMap<Integer> suctionHoppers;

        public static boolean isChimney(LevelReader level, BlockPos pos) {
            ISmokeContainer container;
            BlockState state = level.getBlockState(pos);
            Block block = state.getBlock();
            if (block instanceof ISmokeContainer && (container = (ISmokeContainer)block).is(ISmokeContainer.Type.CHIMNEY)) {
                return true;
            }
            return state.is(CHIMNEYS);
        }

        public static boolean isOpaqueChimney(LevelReader level, BlockPos pos) {
            return SmokeContainers.isChimney(level, pos) && !GameWorld.isGlassBlock(level, pos);
        }

        public static boolean isFullHeightNarrowChimney(LevelReader level, BlockPos pos) {
            if (SmokeContainers.isChimney(level, pos)) {
                BlockState state = level.getBlockState(pos);
                return state.isFaceSturdy((BlockGetter)level, pos, Direction.DOWN, SupportType.CENTER) && state.isFaceSturdy((BlockGetter)level, pos, Direction.UP, SupportType.CENTER);
            }
            return false;
        }

        public static boolean isPassableChimney(LevelReader level, BlockPos pos) {
            return SmokeContainers.isChimney(level, pos) && SmokeContainers.hasWayOut(level, pos);
        }

        public static boolean isVent(LevelReader level, BlockPos pos) {
            Block block = level.getBlockState(pos).getBlock();
            return block instanceof ISmokeContainer && ((ISmokeContainer)block).is(ISmokeContainer.Type.VENT);
        }

        public static boolean isPump(LevelReader level, BlockPos pos) {
            Block block = level.getBlockState(pos).getBlock();
            return block instanceof ISmokeContainer && ((ISmokeContainer)block).is(ISmokeContainer.Type.PUMP);
        }

        public static boolean isPipe(LevelReader level, BlockPos pos) {
            Block block = level.getBlockState(pos).getBlock();
            return block instanceof ISmokeContainer && ((ISmokeContainer)block).is(ISmokeContainer.Type.PIPE) || block instanceof IPole;
        }

        public static boolean isVentOrPump(LevelReader level, BlockPos pos) {
            return SmokeContainers.isVent(level, pos) || SmokeContainers.isPump(level, pos);
        }

        @Deprecated
        public static boolean isVentOrChimney(LevelReader level, BlockPos pos) {
            return SmokeContainers.isVent(level, pos) || SmokeContainers.isChimney(level, pos);
        }

        public static boolean isVentOrPumpOrChimney(LevelReader level, BlockPos pos) {
            return SmokeContainers.isVent(level, pos) || SmokeContainers.isPump(level, pos) || SmokeContainers.isChimney(level, pos);
        }

        public static boolean isActive(LevelReader level, BlockPos pos) {
            BlockState state = level.getBlockState(pos);
            Block block = state.getBlock();
            return block instanceof ISmokeContainer && ((ISmokeContainer)block).isActive((BlockGetter)level, pos);
        }

        public static boolean isActivePump(LevelReader level, BlockPos pos) {
            return SmokeContainers.isPump(level, pos) && SmokeContainers.isActive(level, pos);
        }

        public static boolean isActiveExhaustPump(LevelReader level, BlockPos pos) {
            return SmokeContainers.isExhaustPump(level, pos) && SmokeContainers.isActive(level, pos);
        }

        public static boolean isActiveReversedPump(LevelReader level, BlockPos pos) {
            return SmokeContainers.isReversedPump(level, pos) && SmokeContainers.isActive(level, pos);
        }

        public static boolean isExhaustPump(LevelReader level, BlockPos pos) {
            return SmokeContainers.isPump(level, pos) && SmokeContainers.getConnectedHopper(level, pos).isEmpty() && SmokeContainers.canPassThrough((BlockGetter)level, pos.above(), Direction.DOWN);
        }

        public static boolean isReversedPump(LevelReader level, BlockPos pos) {
            return SmokeContainers.isPump(level, pos) && (!SmokeContainers.canPassThrough((BlockGetter)level, pos.above(), Direction.DOWN) || SmokeContainers.getConnectedHopper(level, pos).isPresent());
        }

        public static boolean isHopper(LevelReader level, BlockPos pos) {
            return suctionHoppers.containsKey(level.getBlockState(pos));
        }

        public static int getHopperSuctionRange(LevelReader level, BlockPos pos) {
            return Optional.ofNullable(suctionHoppers.get(level.getBlockState(pos))).orElse(0);
        }

        public static Optional<BlockPos> getConnectedHopper(LevelReader level, BlockPos pos) {
            if (SmokeContainers.isVent(level, pos)) {
                pos = pos.below();
            }
            if (SmokeContainers.isChimney(level, pos)) {
                pos = SmokeContainers.getBottommostChimney(level, pos).below();
            }
            if (SmokeContainers.isPump(level, pos)) {
                pos = pos.above();
            }
            if (SmokeContainers.isPipe(level, pos)) {
                pos = SmokeContainers.getTopmostPipe(level, pos).above();
            }
            return SmokeContainers.isHopper(level, pos) ? Optional.of(pos) : Optional.empty();
        }

        public static Optional<BlockPos> getConnectedReversedPump(LevelReader level, BlockPos pos) {
            if (SmokeContainers.isHopper(level, pos = SmokeContainers.getConnectedHopper(level, pos).orElse(pos))) {
                pos = pos.below();
            }
            if (SmokeContainers.isPipe(level, pos)) {
                pos = SmokeContainers.getBottommostPipe(level, pos).below();
            }
            return SmokeContainers.isReversedPump(level, pos) ? Optional.of(pos) : Optional.empty();
        }

        public static Optional<BlockPos> getConnectedActiveReversedPump(LevelReader level, BlockPos pos) {
            return SmokeContainers.getConnectedReversedPump(level, pos).filter(p -> SmokeContainers.isActive(level, p));
        }

        public static boolean canPassThrough(BlockGetter level, BlockPos pos, Direction from, Direction to) {
            return SmokeContainers.canPassThrough(level, pos, from) && SmokeContainers.canPassThrough(level, pos, to);
        }

        public static boolean canPassThrough(BlockGetter level, BlockPos pos, Direction face) {
            return !level.getBlockState(pos).isFaceSturdy(level, pos, face);
        }

        public static boolean hasWayOut(LevelReader level, BlockPos startPos) {
            BlockPos pos = startPos;
            if (SmokeContainers.isChimney(level, pos)) {
                if (SmokeContainers.getTopmostVentOrPump(level, pos).isPresent()) {
                    return false;
                }
                pos = SmokeContainers.getTopmostChimney(level, pos);
            } else if (SmokeContainers.isPump(level, pos)) {
                return false;
            }
            if (!SmokeContainers.canPassThrough((BlockGetter)level, pos, Direction.UP) && !SmokeContainers.isChimney(level, pos)) {
                return false;
            }
            if (!SmokeContainers.canPassThrough((BlockGetter)level, pos = pos.above(), Direction.DOWN)) {
                return false;
            }
            if (SmokeContainers.canPassThrough((BlockGetter)level, pos, Direction.UP)) {
                return true;
            }
            for (Direction dir : Directions.of().up().horizontals().toList()) {
                if (!SmokeContainers.canPassThrough((BlockGetter)level, pos, dir) || !SmokeContainers.canPassThrough((BlockGetter)level, pos.relative(dir), dir.getOpposite(), Direction.UP)) continue;
                return true;
            }
            return false;
        }

        static List<BlockPos> getClosestActiveExhaustPumps(LevelAccessor level, List<BlockPos> startPositions) {
            ArrayList<BlockPos> pumps = new ArrayList<BlockPos>();
            if (startPositions.isEmpty()) {
                return pumps;
            }
            ArrayList<BlockPos> vents = new ArrayList<BlockPos>();
            for (BlockPos pos : startPositions) {
                if (SmokeContainers.isChimney((LevelReader)level, pos)) {
                    pos = SmokeContainers.getTopmostChimney((LevelReader)level, pos).above();
                }
                if (SmokeContainers.isActiveExhaustPump((LevelReader)level, pos)) {
                    pumps.add(pos);
                    continue;
                }
                if (SmokeContainers.isVent((LevelReader)level, pos)) {
                    vents.add(pos);
                    continue;
                }
                if (!SmokeContainers.isHopper((LevelReader)level, pos)) continue;
                SmokeContainers.getConnectedActiveReversedPump((LevelReader)level, pos).ifPresent(pumps::add);
            }
            final HashMap found = new HashMap();
            ArrayList<1> ventPipes = new ArrayList<1>();
            block1: for (BlockPos pos : vents) {
                for (WorldSearch.VentPipe ventPipe : ventPipes) {
                    if (!ventPipe.getChain().contains(pos)) continue;
                    continue block1;
                }
                WorldSearch.VentPipe pipe = new WorldSearch.VentPipe(level, pos){

                    @Override
                    protected boolean isValidBlock(BlockPos pos) {
                        return SmokeContainers.isActiveExhaustPump((LevelReader)this.level, pos) || SmokeContainers.isVent((LevelReader)this.level, pos) && SmokeContainers.getConnectedActiveReversedPump((LevelReader)this.level, pos).isPresent();
                    }

                    @Override
                    protected boolean onValidFound(BlockPos pos) {
                        if (SmokeContainers.isVent((LevelReader)this.level, pos)) {
                            pos = SmokeContainers.getConnectedActiveReversedPump((LevelReader)this.level, pos).orElse(pos);
                        }
                        found.put(pos, this.getStartPos().distManhattan((Vec3i)pos));
                        return true;
                    }
                };
                pipe.build();
                ventPipes.add(pipe);
            }
            ArrayList entries = new ArrayList(found.entrySet());
            Collections.shuffle(entries);
            entries.stream().sorted(Comparator.comparingInt(Map.Entry::getValue)).map(Map.Entry::getKey).filter(p -> !pumps.contains(p)).forEach(pumps::add);
            return pumps;
        }

        public static List<BlockPos> getClosestActiveExhaustPumps(LevelAccessor level, BlockPos pos) {
            List<Object> startPositions = List.of(pos);
            if (SmokeContainers.isPump((LevelReader)level, pos)) {
                if (SmokeContainers.isExhaustPump((LevelReader)level, pos)) {
                    BlockPos above = pos.above();
                    startPositions = SmokeContainers.isVentOrPumpOrChimney((LevelReader)level, above) ? List.of(above) : Collections.emptyList();
                } else if (SmokeContainers.isReversedPump((LevelReader)level, pos)) {
                    startPositions = SmokeContainers.getVentsAndPumpsAround((LevelReader)level, pos);
                    BlockPos below = pos.below();
                    if (SmokeContainers.isHopper((LevelReader)level, below)) {
                        startPositions.add(below);
                    }
                    Collections.shuffle(startPositions);
                }
            }
            return SmokeContainers.getClosestActiveExhaustPumps(level, startPositions);
        }

        public static int pumpPollutionThrough(List<BlockPos> startingPumps, LevelAccessor level, IPollutant pollutant, int maxAmount) {
            return SmokeContainers.pumpThrough(startingPumps, level, maxAmount, (lev, pos) -> SmokeContainers.isVent((LevelReader)level, pos.above()) || SmokeContainers.isReversedPump((LevelReader)level, pos), (lev, pos, max) -> SmokeContainers.pumpPollutionThroughActivePump(lev, pos, pollutant, max));
        }

        public static int pumpSmokeThrough(List<BlockPos> startingPumps, LevelAccessor level, int maxAmount, WorldSearch.VentPipe.PumpFunc onPump) {
            return SmokeContainers.pumpThrough(startingPumps, level, maxAmount, (lev, pos) -> true, (lev, pos, max) -> SmokeContainers.pumpSmokeThroughActivePump(lev, pos, max, SmokeContainers::hasWayOut, onPump));
        }

        static int pumpThrough(List<BlockPos> startingPumps, LevelAccessor level, int maxAmount, WorldSearch.BlockChain.BlockFunc shouldSearchForClosestPumps, WorldSearch.VentPipe.PumpFunc pumpFunc) {
            BlockPos pos2;
            if (maxAmount <= 0) {
                return 0;
            }
            int count = 0;
            HashSet<BlockPos> used = new HashSet<BlockPos>();
            ArrayDeque<BlockPos> transit = new ArrayDeque<BlockPos>();
            ArrayDeque pumps = new ArrayDeque();
            Lists.reverse(startingPumps).stream().filter(pos -> SmokeContainers.isActivePump((LevelReader)level, pos)).forEach(pumps::push);
            while (!pumps.isEmpty()) {
                List closest;
                Block block;
                pos2 = (BlockPos)pumps.pop();
                if (used.contains(pos2) || !((block = level.getBlockState(pos2).getBlock()) instanceof ISmokeContainer)) continue;
                ISmokeContainer container = (ISmokeContainer)block;
                List<Object> list = closest = shouldSearchForClosestPumps.apply(level, pos2) ? container.getClosestActiveExhaustPumps(level, pos2).stream().filter(pump -> !transit.contains(pump)).toList() : Collections.emptyList();
                if (closest.isEmpty()) {
                    used.add(pos2);
                    if ((count += pumpFunc.apply(level, pos2, maxAmount)) < maxAmount) continue;
                    return count;
                }
                transit.push(pos2);
                Lists.reverse(closest).forEach(pumps::push);
            }
            while (!transit.isEmpty()) {
                pos2 = (BlockPos)transit.pop();
                if ((count += pumpFunc.apply(level, pos2, maxAmount)) < maxAmount) continue;
                return count;
            }
            return count;
        }

        static int pumpSmokeThroughActivePump(LevelAccessor level, BlockPos pump, int maxAmount, WorldSearch.BlockChain.BlockFunc validOutlet, WorldSearch.VentPipe.PumpFunc onPump) {
            if (maxAmount <= 0) {
                return 0;
            }
            int count = 0;
            if (SmokeContainers.isActiveExhaustPump((LevelReader)level, pump)) {
                BlockPos pos = pump.above();
                if (SmokeContainers.isChimney((LevelReader)level, pos)) {
                    pos = SmokeContainers.getTopmostOpaqueChimney((LevelReader)level, pos);
                    pos = SmokeContainers.getTopmostVentOrPump((LevelReader)level, pos).orElse(pos);
                }
                if (SmokeContainers.isVent((LevelReader)level, pos)) {
                    return WorldSearch.VentPipe.pump(level, List.of(pos), maxAmount, validOutlet, onPump);
                }
                if (validOutlet.apply(level, pos)) {
                    return onPump.apply(level, pos, maxAmount);
                }
            } else {
                count += SmokeContainers.pumpThroughReversedPump(level, pump, maxAmount - count, validOutlet, onPump);
            }
            return count;
        }

        static int pumpPollutionThroughActivePump(LevelAccessor level, BlockPos pump, IPollutant pollutant, int maxAmount) {
            if (maxAmount <= 0) {
                return 0;
            }
            if (SmokeContainers.isActiveExhaustPump((LevelReader)level, pump)) {
                BlockPos pos = pump.above();
                if (SmokeContainers.isVent((LevelReader)level, pos)) {
                    return WorldSearch.VentPipe.pump(level, List.of(pos), maxAmount, (l, p) -> true, pollutant::pump);
                }
                if (pollutant.canPassThrough((LevelReader)level, pos, Direction.DOWN, Direction.UP)) {
                    return pollutant.pumpEntitiesAt(level, pos, maxAmount);
                }
                return 0;
            }
            return SmokeContainers.pumpThroughReversedPump(level, pump, maxAmount, (l, p) -> true, pollutant::pump);
        }

        static int pumpThroughReversedPump(LevelAccessor level, BlockPos pump, int maxAmount, WorldSearch.BlockChain.BlockFunc validOutlet, WorldSearch.VentPipe.PumpFunc onPump) {
            if (maxAmount <= 0) {
                return 0;
            }
            int count = 0;
            if (SmokeContainers.isActiveReversedPump((LevelReader)level, pump)) {
                for (Direction dir : Directions.of().horizontals().shuffle().toList()) {
                    BlockPos pos = pump.relative(dir);
                    if (level.getBlockState(pos).isFaceSturdy((BlockGetter)level, pos, dir.getOpposite()) || !validOutlet.apply(level, pos) || (count += onPump.apply(level, pos, maxAmount - count)) < maxAmount) continue;
                    return count;
                }
                List<BlockPos> vents = SmokeContainers.getVentsAround((LevelReader)level, pump);
                Collections.shuffle(vents);
                count += WorldSearch.VentPipe.pump(level, vents, maxAmount - count, validOutlet, onPump);
            }
            return count;
        }

        public static Optional<Float> getPumpedChimneyAirflow(LevelReader level, BlockPos pos) {
            BlockPos above;
            if (SmokeContainers.isChimney(level, pos) && SmokeContainers.canPassThrough((BlockGetter)level, above = SmokeContainers.getTopmostChimney(level, pos).above(), Direction.DOWN)) {
                pos = SmokeContainers.getBottommostChimney(level, pos).below();
            }
            if (SmokeContainers.isActiveExhaustPump(level, pos)) {
                return Optional.ofNullable(pumpedChimneyAirflow).map(value -> Float.valueOf((float)((Integer)value.get()).intValue() * 0.1f));
            }
            return Optional.empty();
        }

        public static Optional<BlockPos> getTopmostVentOrPump(LevelReader level, BlockPos pos) {
            if (SmokeContainers.isChimney(level, pos)) {
                pos = SmokeContainers.getTopmostChimney(level, pos).above();
            }
            if (SmokeContainers.isVentOrPump(level, pos)) {
                return Optional.of(pos);
            }
            return Optional.empty();
        }

        public static BlockPos getTopmostChimney(LevelReader level, BlockPos startPos) {
            return Positions.getLastInLine(level, startPos, SmokeContainers::isChimney, Direction.UP);
        }

        public static BlockPos getTopmostOpaqueChimney(LevelReader level, BlockPos startPos) {
            return Positions.getLastInLine(level, startPos, SmokeContainers::isOpaqueChimney, Direction.UP);
        }

        public static BlockPos getBottommostChimney(LevelReader level, BlockPos startPos) {
            return Positions.getLastInLine(level, startPos, SmokeContainers::isChimney, Direction.DOWN);
        }

        public static BlockPos getTopmostPipe(LevelReader level, BlockPos startPos) {
            return Positions.getLastInLine(level, startPos, SmokeContainers::isPipe, Direction.UP);
        }

        public static BlockPos getBottommostPipe(LevelReader level, BlockPos startPos) {
            return Positions.getLastInLine(level, startPos, SmokeContainers::isPipe, Direction.DOWN);
        }

        public static List<BlockPos> getVentsAround(LevelReader level, BlockPos centerPos) {
            return SmokeContainers.getAround(level, centerPos, SmokeContainers::isVent);
        }

        public static List<BlockPos> getVentsAndPumpsAround(LevelReader level, BlockPos centerPos) {
            return SmokeContainers.getAround(level, centerPos, SmokeContainers::isVentOrPump);
        }

        public static Optional<ISmokeContainer> getSmokeContainerAt(LevelReader level, BlockPos pos) {
            Optional<ISmokeContainer> optional;
            Block block = level.getBlockState(pos).getBlock();
            if (block instanceof ISmokeContainer) {
                ISmokeContainer container = (ISmokeContainer)block;
                optional = Optional.of(container);
            } else {
                optional = Optional.empty();
            }
            return optional;
        }

        public static List<BlockPos> getAround(LevelReader level, BlockPos centerPos, BiPredicate<LevelReader, BlockPos> filter) {
            return SmokeContainers.getOnly(level, Positions.getAroundHoriz(centerPos, false, new BlockPos[0]), filter);
        }

        public static List<BlockPos> getOnly(LevelReader level, List<BlockPos> positions, BiPredicate<LevelReader, BlockPos> filter) {
            ArrayList<BlockPos> accepted = new ArrayList<BlockPos>();
            for (BlockPos pos : positions) {
                if (!filter.test(level, pos)) continue;
                accepted.add(pos);
            }
            return accepted;
        }
    }

    public static class Positions {
        public static List<BlockPos> getAroundHoriz(BlockPos centerPos, boolean includeCorners, BlockPos ... positions) {
            ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
            blocks.add(centerPos.west());
            blocks.add(centerPos.east());
            blocks.add(centerPos.north());
            blocks.add(centerPos.south());
            if (includeCorners) {
                blocks.add(centerPos.west().north());
                blocks.add(centerPos.west().south());
                blocks.add(centerPos.east().north());
                blocks.add(centerPos.east().south());
            }
            blocks.addAll(Arrays.asList(positions));
            return blocks;
        }

        public static List<ChunkPos> getAroundHoriz(ChunkPos centerPos, boolean includeCorners, ChunkPos ... positions) {
            List<BlockPos> blocks = Positions.getAroundHoriz(new BlockPos(centerPos.x, 0, centerPos.z), includeCorners, new BlockPos[0]);
            ArrayList<ChunkPos> chunks = new ArrayList<ChunkPos>();
            for (BlockPos pos : blocks) {
                chunks.add(new ChunkPos(pos.getX(), pos.getZ()));
            }
            chunks.addAll(Arrays.asList(positions));
            return chunks;
        }

        public static List<BlockPos> getAroundHoriz(BlockPos centerPos, int radius, boolean includeCorners) {
            ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
            if (radius > 0) {
                int diameter = radius * 2 + (!includeCorners ? 1 : 0);
                blocks.addAll(Positions.getLine(centerPos.west(radius).north(radius), Direction.EAST, diameter, !includeCorners));
                blocks.addAll(Positions.getLine(centerPos.north(radius).east(radius), Direction.SOUTH, diameter, !includeCorners));
                blocks.addAll(Positions.getLine(centerPos.east(radius).south(radius), Direction.WEST, diameter, !includeCorners));
                blocks.addAll(Positions.getLine(centerPos.south(radius).west(radius), Direction.NORTH, diameter, !includeCorners));
            } else {
                blocks.add(centerPos);
            }
            return blocks;
        }

        public static List<ChunkPos> getAroundHoriz(ChunkPos centerPos, int radius, boolean includeCorners) {
            ArrayList<ChunkPos> chunks = new ArrayList<ChunkPos>();
            List<BlockPos> blocks = Positions.getAroundHoriz(new BlockPos(centerPos.x, 0, centerPos.z), radius, includeCorners);
            for (BlockPos pos : blocks) {
                chunks.add(new ChunkPos(pos.getX(), pos.getZ()));
            }
            return chunks;
        }

        public static List<BlockPos> getLine(BlockPos startPos, Direction direction, int length, boolean excludeEnds) {
            ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
            for (int i = 0; i < length; ++i) {
                if (excludeEnds && (i == 0 || i == length - 1)) continue;
                BlockPos pos = startPos.relative(direction, i);
                blocks.add(pos);
            }
            return blocks;
        }

        public static List<BlockPos> getHorizPlane(BlockPos centerPos, int radius, boolean includeCorners) {
            ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
            for (int r = radius; r >= 1; --r) {
                blocks.addAll(Positions.getAroundHoriz(centerPos, r, includeCorners));
            }
            blocks.add(centerPos);
            return blocks;
        }

        public static List<BlockPos> getAroundCube(BlockPos startPos) {
            return Positions.getAroundHoriz(startPos, false, startPos.above(), startPos.below());
        }

        public static List<BlockPos> getAroundCube(Level level, BlockPos centerPos, BiPredicate<Level, BlockPos> validPos) {
            ArrayList<BlockPos> validPositions = new ArrayList<BlockPos>();
            for (BlockPos pos : Positions.getAroundCube(centerPos)) {
                if (!validPos.test(level, pos)) continue;
                validPositions.add(pos);
            }
            return validPositions;
        }

        public static List<BlockPos> getAroundCube(BlockPos centerPos, int radius, boolean includeEdges) {
            ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
            for (int offset = -radius; offset <= radius; ++offset) {
                BlockPos pos = centerPos.relative(Direction.UP, offset);
                if (Math.abs(offset) == Math.abs(radius)) {
                    blocks.addAll(Positions.getHorizPlane(pos, radius, includeEdges));
                    continue;
                }
                blocks.addAll(Positions.getAroundHoriz(pos, radius, includeEdges));
            }
            return blocks;
        }

        public static double getDistance(BlockPos posA, BlockPos posB) {
            return Vect3d.distance(Vect3d.from(posA), Vect3d.from(posB));
        }

        public static BlockPos getLastInLine(LevelReader level, BlockPos startPos, BiPredicate<LevelReader, BlockPos> validation, Direction direction) {
            int offset = 0;
            while (validation.test(level, startPos.relative(direction, offset))) {
                ++offset;
            }
            return offset > 0 ? startPos.relative(direction, offset - 1) : startPos;
        }

        public static BlockPos withY(BlockPos pos, int y) {
            return new BlockPos(pos.getX(), y, pos.getZ());
        }

        public static BlockPos withY(BlockPos pos, double y) {
            return BlockPos.containing((double)pos.getX(), (double)y, (double)pos.getZ());
        }
    }

    public static class Directions {
        public static final Direction[] CLOCKWISE_HORIZONTALS = new Direction[]{Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.NORTH};
        protected final List<Direction> directions = new ArrayList<Direction>();

        public static Directions of() {
            return new Directions();
        }

        public Directions add(Direction direction) {
            this.directions.add(direction);
            return this;
        }

        public Directions add(Direction ... directions) {
            this.directions.addAll(Arrays.asList(directions));
            return this;
        }

        public Directions remove(Direction ... directions) {
            for (Direction dir : directions) {
                this.directions.remove(dir);
            }
            return this;
        }

        public Directions all() {
            return this.add(Direction.values());
        }

        public Directions up() {
            return this.add(Direction.UP);
        }

        public Directions down() {
            return this.add(Direction.DOWN);
        }

        public Directions east() {
            return this.add(Direction.EAST);
        }

        public Directions west() {
            return this.add(Direction.WEST);
        }

        public Directions north() {
            return this.add(Direction.NORTH);
        }

        public Directions south() {
            return this.add(Direction.SOUTH);
        }

        public Directions shuffle() {
            Collections.shuffle(this.directions);
            return this;
        }

        public Directions shuffle(Random random) {
            Collections.shuffle(this.directions, random);
            return this;
        }

        public Directions horizontals() {
            return this.add(CLOCKWISE_HORIZONTALS);
        }

        public Directions verticals() {
            return this.add(Direction.UP, Direction.DOWN);
        }

        public List<Direction> toList() {
            return new ArrayList<Direction>(this.directions);
        }

        public Stream<Direction> toStream() {
            return this.directions.stream();
        }

        public Direction[] toArray() {
            return this.directions.toArray(new Direction[0]);
        }
    }
}

