/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.deposit;

import com.endertech.minecraft.mods.adlods.ore.AbstractOre;
import com.endertech.minecraft.mods.adlods.ore.Miscellaneous;
import com.endertech.minecraft.mods.adlods.ore.OreChain;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;

public abstract class DepositOreChain
extends OreChain {
    protected final ChunkPos startChunk;
    protected int deferred = 0;

    protected DepositOreChain(LevelAccessor level, BlockPos startPos, int maxLength, Miscellaneous miscellaneous, Random random) {
        super(level, startPos, maxLength, miscellaneous, random);
        this.startChunk = new ChunkPos(startPos);
    }

    public abstract void saveDeferredEntryPoint(BlockPos var1);

    public boolean inDeferredRegion(ChunkPos chunk) {
        return Math.abs(chunk.x - this.startChunk.x) == 2 || Math.abs(chunk.z - this.startChunk.z) == 2;
    }

    public boolean inFarRegion(ChunkPos chunk) {
        return Math.abs(chunk.x - this.startChunk.x) > 2 || Math.abs(chunk.z - this.startChunk.z) > 2;
    }

    public boolean inGenRegion(ChunkPos chunk) {
        return AbstractOre.withinGenRegion(chunk, this.startChunk);
    }

    public boolean inFullWorld() {
        return this.level instanceof ServerLevel;
    }

    public Optional<BlockPos> getEntryPoint(BlockPos pos) {
        if (this.lastUsedDirection == null || this.inFullWorld()) {
            return Optional.empty();
        }
        ChunkPos chunk = new ChunkPos(pos);
        BlockPos prevPos = pos.relative(this.lastUsedDirection.getOpposite());
        ChunkPos prevChunk = new ChunkPos(prevPos);
        if (!chunk.equals((Object)prevChunk)) {
            if (this.inGenRegion(prevChunk) && this.inDeferredRegion(chunk)) {
                return Optional.of(pos);
            }
            if (this.inDeferredRegion(prevChunk) && this.inGenRegion(chunk)) {
                return Optional.of(prevPos);
            }
        }
        return Optional.empty();
    }

    @Override
    protected boolean onValidFound(BlockPos pos) {
        ChunkPos chunk = new ChunkPos(pos);
        if (this.inFullWorld() || this.inGenRegion(chunk)) {
            if (this.replaceWithOre(pos)) {
                ++this.count;
            }
        } else if (this.inDeferredRegion(chunk)) {
            ++this.deferred;
            this.getEntryPoint(pos).ifPresent(this::saveDeferredEntryPoint);
            if (this.deferred >= 8) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean isValidPath(BlockPos pos) {
        return super.isValidPath(pos) && (this.inFullWorld() || this.inGenRegion(new ChunkPos(pos)));
    }

    protected boolean isOutsideBounds(BlockPos pos) {
        return this.getLevel().isOutsideBuildHeight(pos);
    }
}

