/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.ore;

import com.endertech.common.CommonCollect;
import com.endertech.common.CommonMath;
import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.configs.Parsers;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.math.GameBounds;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.ChunkBounds;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.forge.world.WorldBounds;
import com.endertech.minecraft.mods.adlods.AdLods;
import com.endertech.minecraft.mods.adlods.deposit.DepositGenResult;
import com.endertech.minecraft.mods.adlods.ore.AbstractOre;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.ForgeConfigSpec;

public class Indicator
implements IHaveConfig {
    public static ForgeConfigSpec.ConfigValue<Boolean> enabled;
    public static ForgeConfigSpec.ConfigValue<Boolean> alwaysOnCeiling;
    protected final UnitConfig config;
    protected final UnitId id;
    protected final List<Circle> circles;
    public final Percentage threshold;
    public final Percentage continuity;
    public final int distortion;

    public Indicator(UnitConfig config, String headCategory, String[] circles) {
        this.config = config;
        String category = this.expandClassCategory(headCategory);
        if (config != null) {
            config.setCategoryComment(category, "Above-ground indicator for this deposit (e.g., a rare flower or a combination of circles of different flowers)");
        }
        this.id = UnitConfig.getUnitId((UnitConfig)config, (String)category, (String)"id", (UnitId)UnitId.EMPTY, (String)"ID of a block for a single-block indicator or ID of a structure to bind this deposit to.");
        circles = UnitConfig.getStrArray((UnitConfig)config, (String)category, (String)"circles", (String[])circles, (String)"Circles of indicators and their radiuses.\nSyntax: indicatorId [, circleRadius]\nThe order of the circles is always shuffled.\nThe circles with the same radius will be randomly selected.\nIf the radius is not defined, it will be selected from the minimum available, starting from 1.\nExamples:\n  minecraft:cornflower, 2\n  minecraft:orange_tulip, 4\n");
        this.circles = Indicator.parseCirclesFrom(circles);
        this.threshold = UnitConfig.getPercentage((UnitConfig)config, (String)category, (String)"threshold", (Percentage)Percentage.value((float)30.0f), (FloatBounds)GameBounds.PERCENTAGE.getFloatBounds(), (String)"Percentage of the deposit full size required to create an above-ground indicator.\nIf the indicator is a structure - the chance of generating a deposit under it.\n");
        this.continuity = UnitConfig.getPercentage((UnitConfig)config, (String)category, (String)"continuity", (Percentage)Percentage.value((float)60.0f), (FloatBounds)GameBounds.PERCENTAGE.getFloatBounds(), (String)"Percentage of the indicator shape that will be visible.");
        this.distortion = UnitConfig.getInt((UnitConfig)config, (String)category, (String)"distortion", (int)1, (IntBounds)IntBounds.between((Integer)0, (Integer)16), (String)"Maximum displacement of the indicator shape elements.");
    }

    public static List<Circle> parseCirclesFrom(String[] array) {
        ArrayList<Circle> circles = new ArrayList<Circle>();
        Parsers.UnitId_OptInteger parser = new Parsers.UnitId_OptInteger(IntBounds.between((Integer)0, (Integer)256), ",");
        for (String str : array) {
            if ((str = str.trim()).isEmpty()) continue;
            try {
                UnitId id = parser.getId((CharSequence)str);
                Optional radius = parser.getInteger((CharSequence)str);
                if (id.getFirstMatchedState() == null) continue;
                circles.add(new Circle(id, radius));
            }
            catch (Exception e) {
                parser.logError((AbstractForgeMod)AdLods.getInstance(), "ore indicator", (CharSequence)str, e);
            }
        }
        return circles;
    }

    public UnitId getCenterId() {
        return this.id;
    }

    public List<Circle> getCircles() {
        return this.circles;
    }

    public List<Circle> getShuffledCircles() {
        ArrayList<Circle> circles = new ArrayList<Circle>(this.getCircles());
        Collections.shuffle(circles);
        return circles;
    }

    public int placeFor(WorldGenLevel level, DepositGenResult result) {
        if (result.size < 1) {
            return 0;
        }
        if (enabled != null && !((Boolean)enabled.get()).booleanValue()) {
            return 0;
        }
        if (this.getCenterId().isEmpty() && this.getCircles().isEmpty()) {
            return 0;
        }
        int count = 0;
        Optional<BlockPos> centerPos = Optional.empty();
        BlockState indicator = this.getCenterId().getFirstMatchedState();
        int searchRadius = 4;
        if (indicator != null && (centerPos = this.findPositionFor(indicator, level, new ChunkPos(result.pos), result.pos, searchRadius)).isPresent() && this.place(level, centerPos.get(), indicator)) {
            ++count;
        }
        centerPos = centerPos.map(blockPos -> Optional.of(new BlockPos(blockPos.getX(), result.pos.getY(), blockPos.getZ()))).orElseGet(() -> Optional.of(result.pos));
        int defaultRadius = 1;
        HashSet<Integer> placedRadiuses = new HashSet<Integer>();
        List directions = GameWorld.Directions.of().horizontals().shuffle().toList();
        for (Circle circle : this.getShuffledCircles()) {
            BlockState indicator2 = circle.indicator.getFirstMatchedState();
            if (indicator2 == null) continue;
            int radius = circle.radius.orElse(defaultRadius);
            if (circle.radius.isPresent()) {
                if (placedRadiuses.contains(radius)) {
                    continue;
                }
            } else {
                while (placedRadiuses.contains(defaultRadius)) {
                    ++defaultRadius;
                }
                radius = defaultRadius;
            }
            ChunkPos centerChunk = new ChunkPos(centerPos.get());
            for (BlockPos pos : this.getHorizCirclePoints(centerPos.get(), radius)) {
                if (!this.continuity.takeChance()) continue;
                Direction facing = CommonCollect.getRandomElementFrom((Collection)directions).orElse(null);
                if (facing != null) {
                    pos = pos.relative(facing, CommonMath.Random.between((int)0, (int)this.distortion));
                }
                if ((pos = (BlockPos)this.findPositionFor(indicator2, level, centerChunk, pos, 0).orElse(null)) == null || !this.place(level, pos, indicator2)) continue;
                ++count;
            }
            placedRadiuses.add(radius);
        }
        return count;
    }

    protected boolean place(WorldGenLevel level, BlockPos pos, BlockState indicator) {
        int flags = 2;
        Block block = indicator.getBlock();
        if (block instanceof DoublePlantBlock && level.isEmptyBlock(pos.above())) {
            DoublePlantBlock.placeAt((LevelAccessor)level, (BlockState)block.defaultBlockState(), (BlockPos)pos, (int)2);
            return true;
        }
        return level.setBlock(pos, indicator, 2);
    }

    @Deprecated
    protected boolean place(WorldGenLevel level, Structure structure, DepositGenResult result) {
        ServerLevel serverLevel = level.getLevel();
        ServerChunkCache chunkSource = serverLevel.getChunkSource();
        ChunkGenerator chunkGenerator = chunkSource.getGenerator();
        ChunkPos centerPos = new ChunkPos(result.pos);
        StructureStart structureStart = structure.generate(serverLevel.registryAccess(), chunkGenerator, chunkGenerator.getBiomeSource(), chunkSource.randomState(), serverLevel.getStructureManager(), serverLevel.getSeed(), centerPos, 0, (LevelHeightAccessor)level, validBiome -> true);
        if (structureStart.isValid()) {
            SectionPos sectionPos = SectionPos.of((ChunkPos)centerPos, (int)level.getMinBuildHeight());
            ChunkAccess structureAccess = level.getChunk(sectionPos.x(), sectionPos.z(), ChunkStatus.STRUCTURE_STARTS);
            serverLevel.structureManager().setStartForStructure(sectionPos, structure, structureStart, (StructureAccess)structureAccess);
            BoundingBox structureBB = structureStart.getBoundingBox();
            WorldBounds genBounds = ChunkBounds.chunksAround((LevelHeightAccessor)level, (ChunkPos)centerPos).reduce(1);
            BoundingBox genBoundingBox = BoundingBox.fromCorners((Vec3i)genBounds.min(), (Vec3i)genBounds.max());
            structureStart.placeInChunk(level, serverLevel.structureManager(), chunkGenerator, level.getRandom(), genBoundingBox, centerPos);
        }
        return false;
    }

    protected Optional<BlockPos> findPositionFor(BlockState indicator, WorldGenLevel level, ChunkPos genCenterChunk, BlockPos centerPos, int radius) {
        boolean hasCeiling = level.dimensionType().hasCeiling();
        IntBounds boundsY = IntBounds.between((Integer)centerPos.getY(), (Integer)WorldBounds.getHeightBounds((LevelHeightAccessor)level).getMax());
        for (int r = 0; r <= radius; ++r) {
            block1: for (BlockPos startPos : GameWorld.Positions.getAroundHoriz((BlockPos)centerPos, (int)r, (boolean)true)) {
                if (level instanceof WorldGenRegion && !AbstractOre.withinGenRegion(new ChunkPos(startPos), genCenterChunk)) continue;
                int startY = startPos.getY();
                if (hasCeiling) {
                    if (alwaysOnCeiling != null && ((Boolean)alwaysOnCeiling.get()).booleanValue()) {
                        startY = level.getHeight(Heightmap.Types.WORLD_SURFACE, startPos.getX(), startPos.getZ());
                    }
                } else {
                    int oceanFloorY = level.getHeight(Heightmap.Types.OCEAN_FLOOR, startPos.getX(), startPos.getZ());
                    int worldSurfaceY = level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, startPos.getX(), startPos.getZ());
                    startY = Math.min(oceanFloorY, worldSurfaceY);
                }
                BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(startPos.getX(), startY, startPos.getZ());
                while (boundsY.encloses(Integer.valueOf(pos.getY()))) {
                    BlockState state = level.getBlockState((BlockPos)pos);
                    if (state.blocksMotion()) {
                        pos.move(Direction.UP);
                        continue;
                    }
                    if (!indicator.canSurvive((LevelReader)level, (BlockPos)pos)) continue block1;
                    Optional<BlockPos> placePos = Optional.of(pos.immutable());
                    FluidState fluidState = state.getFluidState();
                    if (!(indicator.getBlock() instanceof LiquidBlockContainer ? fluidState.is(FluidTags.WATER) || indicator.getBlock() instanceof SimpleWaterloggedBlock && fluidState.isEmpty() : fluidState.isEmpty())) continue block1;
                    return placePos;
                }
            }
        }
        return Optional.empty();
    }

    protected Set<BlockPos> getHorizCirclePoints(BlockPos centerPos, int radius) {
        HashSet<BlockPos> points = new HashSet<BlockPos>();
        Function<Integer, Integer> getOtherCoord = coord -> Mth.floor((float)Mth.sqrt((float)(radius * radius - coord * coord)));
        for (int dx = -radius; dx <= radius; ++dx) {
            int dz = getOtherCoord.apply(dx);
            points.add(centerPos.offset(dx, 0, dz));
            points.add(centerPos.offset(dx, 0, -dz));
        }
        for (int dz = -radius; dz <= radius; ++dz) {
            int dx = getOtherCoord.apply(dz);
            points.add(centerPos.offset(dx, 0, dz));
            points.add(centerPos.offset(-dx, 0, dz));
        }
        return points;
    }

    public UnitConfig getConfig() {
        return this.config;
    }

    protected static class Circle {
        public final UnitId indicator;
        public final Optional<Integer> radius;

        public Circle(UnitId indicator) {
            this(indicator, Optional.empty());
        }

        public Circle(UnitId indicator, int radius) {
            this(indicator, Optional.of(radius));
        }

        public Circle(UnitId indicator, Optional<Integer> radius) {
            this.indicator = indicator;
            this.radius = radius;
        }
    }
}

