/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.advancementstracker.client.advancements;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import de.markusbordihn.advancementstracker.client.advancements.TrackedAdvancementsManager;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class AdvancementEntry
implements Comparator<AdvancementEntry> {
    Advancement advancement;
    Advancement rootAdvancement;
    AdvancementProgress advancementProgress;
    DisplayInfo displayInfo;
    Float progress;
    ResourceLocation rootId;
    String progressText;
    String[][] requirements;
    int rootLevel = 0;
    Map<String, CriterionProgress> criteriaMap = new HashMap<String, CriterionProgress>();
    public AdvancementRewards rewards;
    public Date firstProgressDate;
    public Date lastProgressDate;
    public FrameType frameType;
    public ItemStack icon;
    public Iterable<String> completedCriteria;
    public Iterable<String> remainingCriteria;
    public ResourceLocation background;
    public ResourceLocation id;
    public ResourceLocation[] rewardsLoot;
    public ResourceLocation[] rewardsRecipes;
    public String description;
    public String idString;
    public String title;
    public boolean isDone;
    public int completedCriteriaNumber;
    public int criteriaNumber;
    public int descriptionColor = -3355444;
    public int maxCriteraRequired;
    public int remainingCriteriaNumber;
    public int requirementsNumber;
    public int rewardsExperience;

    AdvancementEntry(Advancement advancement, AdvancementProgress advancementProgress) {
        this.advancement = advancement;
        this.displayInfo = advancement.func_192068_c();
        this.id = advancement.func_192067_g();
        this.idString = advancement.func_192067_g().toString();
        this.rootAdvancement = advancement.func_192070_b();
        this.requirements = advancement.func_192074_h();
        this.maxCriteraRequired = advancement.func_193124_g();
        this.rewards = advancement.func_192072_d();
        if (this.rootAdvancement != null) {
            while (this.rootAdvancement.func_192070_b() != null) {
                this.rootAdvancement = this.rootAdvancement.func_192070_b();
                ++this.rootLevel;
            }
            this.rootId = this.rootAdvancement.func_192067_g();
        }
        if (this.rewards != null) {
            JsonElement rewardsJson = null;
            try {
                JsonObject rewardsObject;
                rewardsJson = this.rewards.func_200286_b();
                if (rewardsJson != null && (rewardsObject = rewardsJson.getAsJsonObject()) != null) {
                    this.rewardsExperience = JSONUtils.func_151208_a((JsonObject)rewardsObject, (String)"experience", (int)0);
                    JsonArray lootArray = JSONUtils.func_151213_a((JsonObject)rewardsObject, (String)"loot", (JsonArray)new JsonArray());
                    this.rewardsLoot = new ResourceLocation[lootArray.size()];
                    for (int j = 0; j < this.rewardsLoot.length; ++j) {
                        this.rewardsLoot[j] = new ResourceLocation(JSONUtils.func_151206_a((JsonElement)lootArray.get(j), (String)("loot[" + j + "]")));
                    }
                    JsonArray recipesArray = JSONUtils.func_151213_a((JsonObject)rewardsObject, (String)"recipes", (JsonArray)new JsonArray());
                    this.rewardsRecipes = new ResourceLocation[recipesArray.size()];
                    for (int k = 0; k < this.rewardsRecipes.length; ++k) {
                        this.rewardsRecipes[k] = new ResourceLocation(JSONUtils.func_151206_a((JsonElement)recipesArray.get(k), (String)("recipes[" + k + "]")));
                    }
                }
            }
            catch (JsonParseException | IllegalStateException throwable) {
                // empty catch block
            }
        }
        if (this.displayInfo != null) {
            this.background = this.displayInfo.func_192293_c();
            this.description = this.displayInfo.func_193222_b().getString();
            if (this.displayInfo.func_193222_b().func_150256_b().func_240711_a_() != null) {
                this.descriptionColor = this.displayInfo.func_193222_b().func_150256_b().func_240711_a_().func_240742_a_();
            }
            this.icon = this.displayInfo.func_192298_b();
            this.title = this.displayInfo.func_192297_a().getString();
            this.frameType = this.displayInfo.func_192291_d();
        } else {
            this.background = null;
            this.title = advancement.func_192067_g().toString();
        }
        if (advancementProgress != null) {
            this.addAdvancementProgress(advancementProgress);
        }
    }

    public boolean isTracked() {
        return TrackedAdvancementsManager.isTrackedAdvancement(this.advancement);
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public String toString() {
        if (this.rootAdvancement == null) {
            return String.format("[Root Advancement] (%s) %s: %s %s", this.frameType, this.id, this.title, this.progress);
        }
        return String.format("[Advancement %s] (%s) %s => %s: %s %s", this.rootLevel, this.frameType, this.rootId, this.id, this.title, this.progress);
    }

    public void addAdvancementProgress(AdvancementProgress advancementProgress) {
        if (advancementProgress == null) {
            return;
        }
        this.advancementProgress = advancementProgress;
        this.isDone = advancementProgress.func_192105_a();
        this.firstProgressDate = advancementProgress.func_193128_g();
        this.progress = Float.valueOf(advancementProgress.func_192103_c());
        this.progressText = advancementProgress.func_193126_d();
        this.completedCriteria = advancementProgress.func_192102_e();
        this.completedCriteriaNumber = (int)this.completedCriteria.spliterator().getExactSizeIfKnown();
        for (String criteriaId : this.completedCriteria) {
            this.criteriaMap.put(criteriaId, advancementProgress.func_192106_c(criteriaId));
        }
        this.remainingCriteria = advancementProgress.func_192107_d();
        this.remainingCriteriaNumber = (int)this.remainingCriteria.spliterator().getExactSizeIfKnown();
        for (String criteriaId : this.remainingCriteria) {
            this.criteriaMap.put(criteriaId, advancementProgress.func_192106_c(criteriaId));
        }
        this.lastProgressDate = this.getLastProgressDate();
    }

    private Date getLastProgressDate() {
        Date date = null;
        for (CriterionProgress criterionProgress : this.criteriaMap.values()) {
            if (!criterionProgress.func_192151_a() || date != null && !criterionProgress.func_193140_d().after(date)) continue;
            date = criterionProgress.func_193140_d();
        }
        return date;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdvancementEntry)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this.id == ((AdvancementEntry)obj).id;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public int compare(AdvancementEntry firstAdvancementEntry, AdvancementEntry secondAdvancementEntry) {
        return firstAdvancementEntry.id.compareTo(secondAdvancementEntry.id);
    }

    public static Comparator<AdvancementEntry> sortByTitle() {
        return (firstAdvancementEntry, secondAdvancementEntry) -> firstAdvancementEntry.title.compareTo(secondAdvancementEntry.title);
    }

    public static Comparator<AdvancementEntry> sortByStatus() {
        return (firstAdvancementEntry, secondAdvancementEntry) -> {
            int result = Boolean.compare(firstAdvancementEntry.isDone, secondAdvancementEntry.isDone);
            if (result == 0) {
                result = firstAdvancementEntry.title.compareTo(secondAdvancementEntry.title);
            }
            return result;
        };
    }
}

