/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.advancementstracker.client.advancements;

import de.markusbordihn.advancementstracker.client.advancements.AdvancementsManager;
import de.markusbordihn.advancementstracker.client.advancements.ClientAdvancementManager;
import net.minecraft.advancements.Advancement;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class AdvancementsEventManager {
    private static final Logger log = LogManager.getLogger((String)"AdvancementsTracker");
    private static int numberOfAdvancements = 0;

    protected AdvancementsEventManager() {
    }

    @SubscribeEvent
    public static void handleWorldEventLoad(WorldEvent.Load event) {
        if (!event.getWorld().func_201670_d()) {
            return;
        }
        AdvancementsEventManager.reset();
    }

    @SubscribeEvent
    public static void handleAdvancementEvent(AdvancementEvent advancementEvent) {
        Advancement advancement = advancementEvent.getAdvancement();
        if (ClientAdvancementManager.isValidAdvancement(advancement)) {
            int possibleNumberOfAdvancements;
            log.debug("[Advancement Event] {}", (Object)advancement);
            String advancementId = advancement.func_192067_g().toString();
            Advancement rootAdvancement = advancement.func_192070_b();
            if (rootAdvancement == null) {
                if (advancementId.contains("/root") || advancementId.contains(":root")) {
                    ClientAdvancementManager.reset();
                }
                AdvancementsManager.addAdvancementRoot(advancement);
            } else {
                while (rootAdvancement.func_192070_b() != null) {
                    rootAdvancement = rootAdvancement.func_192070_b();
                }
                AdvancementsManager.addAdvancementRoot(rootAdvancement);
                AdvancementsManager.addAdvancementTask(advancement);
            }
            Minecraft minecraft = Minecraft.func_71410_x();
            if (minecraft != null && minecraft.field_71439_g != null && minecraft.field_71439_g.field_71174_a != null && minecraft.field_71439_g.field_71174_a.func_191982_f() != null && !minecraft.field_71439_g.field_71174_a.func_191982_f().func_194229_a().func_195651_c().isEmpty() && (possibleNumberOfAdvancements = minecraft.field_71439_g.field_71174_a.func_191982_f().func_194229_a().func_195651_c().size()) > numberOfAdvancements) {
                log.debug("Force sync of advancements because it seems we are missing some {} vs. {}", (Object)possibleNumberOfAdvancements, (Object)numberOfAdvancements);
                ClientAdvancementManager.reset();
                numberOfAdvancements = possibleNumberOfAdvancements;
            }
        }
    }

    public static void reset() {
        numberOfAdvancements = 0;
    }
}

