/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.advancementstracker.client.advancements;

import de.markusbordihn.advancementstracker.client.advancements.AdvancementEntry;
import de.markusbordihn.advancementstracker.client.advancements.TrackedAdvancementsManager;
import de.markusbordihn.advancementstracker.client.screen.ScreenManager;
import de.markusbordihn.advancementstracker.config.ClientConfig;
import java.io.File;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class AdvancementsManager {
    public static final Logger log = LogManager.getLogger((String)"AdvancementsTracker");
    private static AdvancementEntry selectedAdvancement;
    private static AdvancementEntry selectedRootAdvancement;
    private static Date startDate;
    private static Map<Advancement, AdvancementProgress> advancementProgressMap;
    private static Map<ResourceLocation, Set<AdvancementEntry>> advancementsMap;
    private static Set<AdvancementEntry> rootAdvancements;
    private static Set<String> advancementsIndex;
    private static Set<String> screenshotIndex;
    private static boolean hasAdvancements;
    private static boolean screenshotEnabled;
    private static long screenshotDelay;

    protected AdvancementsManager() {
    }

    @SubscribeEvent
    public static void handleWorldEventLoad(WorldEvent.Load event) {
        if (!event.getWorld().func_201670_d()) {
            return;
        }
        AdvancementsManager.reset();
    }

    public static void reset() {
        log.info("Reset Advancements Manager ...");
        startDate = new Date();
        screenshotDelay = ((Integer)ClientConfig.CLIENT.screenshotDelay.get()).intValue();
        screenshotEnabled = (Boolean)ClientConfig.CLIENT.screenshotEnabled.get();
        if (screenshotEnabled) {
            log.info("Enable screenshot support with {} ms delay", (Object)screenshotDelay);
        } else {
            log.info("Disable screenshot support.");
        }
        advancementProgressMap = new HashMap<Advancement, AdvancementProgress>();
        advancementsIndex = new HashSet<String>();
        advancementsMap = new HashMap<ResourceLocation, Set<AdvancementEntry>>();
        hasAdvancements = false;
        rootAdvancements = new HashSet<AdvancementEntry>();
        screenshotIndex = new HashSet<String>();
        selectedAdvancement = null;
        selectedRootAdvancement = null;
    }

    public static void addAdvancementRoot(Advancement advancement) {
        String advancementId = advancement.func_192067_g().toString();
        if (AdvancementsManager.hasAdvancement(advancementId)) {
            return;
        }
        AdvancementProgress advancementProgress = AdvancementsManager.getAdvancementProgress(advancement);
        AdvancementEntry advancementEntry = new AdvancementEntry(advancement, advancementProgress);
        rootAdvancements.add(advancementEntry);
        advancementsIndex.add(advancementId);
        log.info("{}", (Object)advancementEntry);
    }

    public static void addAdvancementTask(Advancement advancement) {
        String advancementId = advancement.func_192067_g().toString();
        Advancement rootAdvancement = advancement.func_192070_b();
        if (rootAdvancement != null) {
            while (rootAdvancement.func_192070_b() != null) {
                rootAdvancement = rootAdvancement.func_192070_b();
            }
            AdvancementsManager.addAdvancementRoot(rootAdvancement);
        }
        if (AdvancementsManager.hasAdvancement(advancementId)) {
            return;
        }
        AdvancementProgress advancementProgress = AdvancementsManager.getAdvancementProgress(advancement);
        AdvancementEntry advancementEntry = new AdvancementEntry(advancement, advancementProgress);
        Set<AdvancementEntry> childAdvancements = advancementsMap.get(advancementEntry.rootId);
        if (childAdvancements == null) {
            childAdvancements = new HashSet<AdvancementEntry>();
            advancementsMap.put(advancementEntry.rootId, childAdvancements);
        }
        childAdvancements.add(advancementEntry);
        advancementsIndex.add(advancementId);
        if (!hasAdvancements) {
            hasAdvancements = true;
        }
        log.info("{}", (Object)advancementEntry);
        TrackedAdvancementsManager.checkForTrackedAdvancement(advancementEntry);
    }

    public static boolean hasAdvancement(Advancement advancement) {
        return AdvancementsManager.hasAdvancement(advancement.func_192067_g().toString());
    }

    public static boolean hasAdvancement(String advancementId) {
        return advancementsIndex.contains(advancementId);
    }

    public static boolean hasRootAdvancement(Advancement advancement) {
        for (AdvancementEntry rootAdvancement : rootAdvancements) {
            if (advancement.func_192067_g() != rootAdvancement.id) continue;
            return true;
        }
        return false;
    }

    public static AdvancementEntry getRootAdvancement(Advancement advancement) {
        for (AdvancementEntry rootAdvancement : rootAdvancements) {
            if (advancement.func_192067_g() != rootAdvancement.id) continue;
            return rootAdvancement;
        }
        return null;
    }

    public static Set<AdvancementEntry> getRootAdvancements() {
        return rootAdvancements;
    }

    public static Set<AdvancementEntry> getSortedRootAdvancements(Comparator<AdvancementEntry> comparator) {
        Set<AdvancementEntry> advancements = AdvancementsManager.getRootAdvancements();
        if (advancements == null) {
            return new HashSet<AdvancementEntry>();
        }
        return advancements.stream().sorted(comparator).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static Set<AdvancementEntry> getRootAdvancementsByTile() {
        return AdvancementsManager.getSortedRootAdvancements(AdvancementEntry.sortByTitle());
    }

    public static AdvancementEntry getAdvancement(Advancement advancement) {
        return AdvancementsManager.getAdvancement(advancement.func_192067_g().toString());
    }

    public static AdvancementEntry getAdvancement(String id) {
        for (Set<AdvancementEntry> advancementEntries : advancementsMap.values()) {
            for (AdvancementEntry advancementEntry : advancementEntries) {
                if (!id.equals(advancementEntry.id.toString())) continue;
                return advancementEntry;
            }
        }
        return null;
    }

    public static Set<AdvancementEntry> getAdvancements(AdvancementEntry rootAdvancement) {
        if (rootAdvancement == null) {
            log.error("Unable to get advancements for root advancement {}", (Object)rootAdvancement);
            return new HashSet<AdvancementEntry>();
        }
        return advancementsMap.get(rootAdvancement.id);
    }

    public static Set<AdvancementEntry> getSortedAdvancements(AdvancementEntry rootAdvancement, Comparator<AdvancementEntry> comparator) {
        Set<AdvancementEntry> advancements = AdvancementsManager.getAdvancements(rootAdvancement);
        if (advancements == null) {
            return new HashSet<AdvancementEntry>();
        }
        return advancements.stream().sorted(comparator).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static Set<AdvancementEntry> getAdvancementsByTile(AdvancementEntry rootAdvancement) {
        return AdvancementsManager.getSortedAdvancements(rootAdvancement, AdvancementEntry.sortByTitle());
    }

    public static Set<AdvancementEntry> getAdvancementsByStatus(AdvancementEntry rootAdvancement) {
        return AdvancementsManager.getSortedAdvancements(rootAdvancement, AdvancementEntry.sortByStatus());
    }

    public static void updateAdvancementProgress(Advancement advancement, AdvancementProgress advancementProgress) {
        String advancementId = advancement.func_192067_g().toString();
        advancementProgressMap.put(advancement, advancementProgress);
        AdvancementEntry advancementEntry = AdvancementsManager.getAdvancement(advancement);
        if (advancementEntry == null && (advancementEntry = AdvancementsManager.getRootAdvancement(advancement)) == null) {
            log.error("Unable to find entry for advancement {} with progress {}", (Object)advancement, (Object)advancementProgress);
            return;
        }
        advancementEntry.addAdvancementProgress(advancementProgress);
        if (advancementProgress.func_192105_a()) {
            if (screenshotEnabled) {
                if (screenshotIndex.contains(advancementId)) {
                    log.debug("Screenshot was already taken for {}, skipping ...", (Object)advancementId);
                } else {
                    Iterable completedCriteria = advancementProgress.func_192102_e();
                    Date lastProgressionDate = startDate;
                    if (completedCriteria != null) {
                        for (String criteriaId : completedCriteria) {
                            CriterionProgress criteriaProgress = advancementProgress.func_192106_c(criteriaId);
                            if (!criteriaProgress.func_193140_d().after(lastProgressionDate)) continue;
                            lastProgressionDate = criteriaProgress.func_193140_d();
                        }
                    }
                    if (lastProgressionDate.after(startDate)) {
                        log.info("Found new advancement {} which was done on {}", (Object)advancementId, (Object)lastProgressionDate);
                        String screenshotFolder = advancementId.split("/")[0].replace(":", "_");
                        String screenshotName = String.format("advancement-unknown-%s", new Random().nextInt(99));
                        if (advancementId.contains("/") && advancementId.split("/").length > 1) {
                            screenshotName = advancementId.split("/", 2)[1].replace("/", "_");
                        } else if (advancementId.contains(":") && advancementId.split(":").length > 1) {
                            screenshotFolder = advancementId.split(":")[0];
                            screenshotName = advancementId.split(":", 2)[1];
                        } else {
                            log.warn("Unable to find unique name ({}) for advancement: {}", (Object)advancementId, (Object)advancement);
                        }
                        ScreenManager.saveScreenshot(new File(String.format("screenshots/%s", screenshotFolder)), screenshotName, screenshotDelay);
                        screenshotIndex.add(advancementId);
                    }
                }
            }
            TrackedAdvancementsManager.untrackAdvancement(advancement);
        }
    }

    public static AdvancementProgress getAdvancementProgress(Advancement advancement) {
        return advancementProgressMap.get(advancement);
    }

    public static AdvancementEntry getSelectedAdvancement() {
        Set<AdvancementEntry> possibleAdvancements;
        if (selectedAdvancement == null && AdvancementsManager.getSelectedRootAdvancement() != null && (possibleAdvancements = AdvancementsManager.getAdvancements(AdvancementsManager.getSelectedRootAdvancement())) != null && possibleAdvancements.iterator().hasNext()) {
            selectedAdvancement = possibleAdvancements.iterator().next();
        }
        return selectedAdvancement;
    }

    public static void setSelectedAdvancement(AdvancementEntry selectedAdvancement) {
        AdvancementsManager.selectedAdvancement = selectedAdvancement;
    }

    public static AdvancementEntry getSelectedRootAdvancement() {
        AdvancementEntry possibleRootAdvancement;
        if (selectedRootAdvancement == null && rootAdvancements != null && rootAdvancements.iterator().hasNext() && (possibleRootAdvancement = rootAdvancements.iterator().next()) != selectedRootAdvancement) {
            log.debug("Select root advancement: {}", (Object)selectedAdvancement);
            selectedRootAdvancement = possibleRootAdvancement;
            selectedAdvancement = null;
        }
        return selectedRootAdvancement;
    }

    public static void setSelectedRootAdvancement(AdvancementEntry selectedRootAdvancement) {
        AdvancementsManager.selectedRootAdvancement = selectedRootAdvancement;
        if (selectedAdvancement != null && selectedRootAdvancement.id != AdvancementsManager.selectedAdvancement.rootId) {
            selectedAdvancement = null;
        }
    }

    public static boolean hasAdvancements() {
        return hasAdvancements;
    }

    static {
        startDate = new Date();
        advancementProgressMap = new HashMap<Advancement, AdvancementProgress>();
        advancementsMap = new HashMap<ResourceLocation, Set<AdvancementEntry>>();
        rootAdvancements = new HashSet<AdvancementEntry>();
        advancementsIndex = new HashSet<String>();
        screenshotIndex = new HashSet<String>();
        hasAdvancements = false;
        screenshotEnabled = (Boolean)ClientConfig.CLIENT.screenshotEnabled.get();
        screenshotDelay = ((Integer)ClientConfig.CLIENT.screenshotDelay.get()).intValue();
    }
}

