/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.advancementstracker.client.advancements;

import de.markusbordihn.advancementstracker.client.advancements.AdvancementsManager;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientAdvancementManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientAdvancementManager
implements ClientAdvancementManager.IListener {
    private static final Logger log = LogManager.getLogger((String)"AdvancementsTracker");
    private static short ticks = 0;
    private static final short ADD_LISTENER_TICK = 2;
    private static boolean hasListener = false;
    private static ClientAdvancementManager clientAdvancementManager;

    protected ClientAdvancementManager() {
    }

    @SubscribeEvent
    public static void handleWorldEventLoad(WorldEvent.Load event) {
        if (!event.getWorld().func_201670_d()) {
            return;
        }
        ClientAdvancementManager.reset();
    }

    @SubscribeEvent
    public static void handleClientTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ticks = (short)(ticks + 1);
            return;
        }
        if (ticks == 2 && !hasListener) {
            ClientAdvancementManager.addListener();
            ticks = 0;
        }
    }

    public static void reset() {
        log.debug("Resetting Client Advancement Manager ...");
        clientAdvancementManager = new ClientAdvancementManager();
        hasListener = false;
        ticks = 0;
    }

    public static void addListener() {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft == null || minecraft.field_71439_g == null || minecraft.field_71439_g.field_71174_a == null || minecraft.field_71439_g.field_71174_a.func_191982_f() == null || minecraft.field_71439_g.field_71174_a.func_191982_f().func_194229_a().func_195651_c().isEmpty()) {
            return;
        }
        log.debug("Adding client advancement manager listener...");
        minecraft.field_71439_g.field_71174_a.func_191982_f().func_192798_a((ClientAdvancementManager.IListener)clientAdvancementManager);
        hasListener = true;
    }

    public static boolean isValidAdvancement(Advancement advancement) {
        String advancementId = advancement.func_192067_g().toString();
        return advancement.func_192068_c() != null && !advancementId.startsWith("minecraft:recipes/") && !advancementId.startsWith("smallships:recipes");
    }

    public void func_191933_a(Advancement advancement, AdvancementProgress advancementProgress) {
        if (ClientAdvancementManager.isValidAdvancement(advancement)) {
            log.debug("[Update Advancement Progress] {} with {}", (Object)advancement, (Object)advancementProgress);
            AdvancementsManager.updateAdvancementProgress(advancement, advancementProgress);
        }
    }

    public void func_191931_a(Advancement advancement) {
        if (ClientAdvancementManager.isValidAdvancement(advancement) && advancement.func_192070_b() == null) {
            log.debug("[Add Advancement Root] {}", (Object)advancement);
            AdvancementsManager.addAdvancementRoot(advancement);
        }
    }

    public void func_191928_b(Advancement advancement) {
        log.debug("[Remove Advancement Root] {}", (Object)advancement);
    }

    public void func_191932_c(Advancement advancement) {
        if (ClientAdvancementManager.isValidAdvancement(advancement) && advancement.func_192070_b() != null) {
            log.debug("[Add Advancement Task] {}", (Object)advancement);
            AdvancementsManager.addAdvancementTask(advancement);
        }
    }

    public void func_191929_d(Advancement advancement) {
        log.debug("[Remove Advancement Task] {}", (Object)advancement);
    }

    public void func_191930_a() {
        log.debug("[Advancements Cleared] ...");
    }

    public void func_193982_e(Advancement advancement) {
        log.debug("[Selected Tab Changed] {}", (Object)advancement);
    }
}

