/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.advancementstracker.client.advancements;

import de.markusbordihn.advancementstracker.client.advancements.AdvancementEntry;
import de.markusbordihn.advancementstracker.client.gui.widgets.TrackerWidget;
import de.markusbordihn.advancementstracker.config.ClientConfig;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.advancements.Advancement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class TrackedAdvancementsManager {
    public static final Logger log = LogManager.getLogger((String)"AdvancementsTracker");
    private static Set<AdvancementEntry> trackedAdvancements = new HashSet<AdvancementEntry>();
    private static int maxNumberOfTrackedAdvancements = (Integer)ClientConfig.CLIENT.maxNumberOfTrackedAdvancements.get();
    private static List<String> trackedAdvancementsDefault = (List)ClientConfig.CLIENT.trackedAdvancements.get();
    private static List<String> trackedAdvancementsLocal = (List)ClientConfig.CLIENT.trackedAdvancementsLocal.get();
    private static List<String> trackedAdvancementsRemote = (List)ClientConfig.CLIENT.trackedAdvancementsRemote.get();
    private static String serverId;

    protected TrackedAdvancementsManager() {
    }

    @SubscribeEvent
    public static void handleWorldEventLoad(WorldEvent.Load event) {
        if (!event.getWorld().func_201670_d()) {
            return;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        ServerData serverData = minecraft != null ? minecraft.func_147104_D() : null;
        serverId = serverData != null ? String.format("%s:%s::", serverData.field_78847_a.replaceAll("[^a-zA-Z0-9_]", "_"), serverData.field_82821_f) : null;
        trackedAdvancements = new HashSet<AdvancementEntry>();
        maxNumberOfTrackedAdvancements = (Integer)ClientConfig.CLIENT.maxNumberOfTrackedAdvancements.get();
        log.info("Loading tracked advancements with max. {} ...", (Object)maxNumberOfTrackedAdvancements);
        trackedAdvancementsDefault = (List)ClientConfig.CLIENT.trackedAdvancements.get();
        if (!trackedAdvancementsDefault.isEmpty()) {
            log.info("Loading default tracked advancements {} ...", trackedAdvancementsDefault);
        }
        if (!(trackedAdvancementsLocal = (List)ClientConfig.CLIENT.trackedAdvancementsLocal.get()).isEmpty()) {
            log.info("Loading local tracked advancements {} ...", trackedAdvancementsLocal);
        }
        if (!(trackedAdvancementsRemote = (List)ClientConfig.CLIENT.trackedAdvancementsRemote.get()).isEmpty()) {
            log.info("Loading remote tracked advancements {} ...", trackedAdvancementsRemote);
        }
        TrackedAdvancementsManager.updateTrackerWidget();
    }

    public static void checkForTrackedAdvancement(AdvancementEntry advancement) {
        if (advancement.isDone || trackedAdvancements.size() >= maxNumberOfTrackedAdvancements) {
            return;
        }
        AdvancementEntry trackedAdvancement = null;
        if (!trackedAdvancementsDefault.isEmpty()) {
            for (String trackedAdvancementDefault : trackedAdvancementsDefault) {
                if (!advancement.idString.equals(trackedAdvancementDefault)) continue;
                log.debug("Adding default tracked advancement {}", (Object)advancement);
                trackedAdvancement = advancement;
                break;
            }
        }
        if (!trackedAdvancementsRemote.isEmpty() && serverId != null) {
            for (String cachedAdvancementEntry : trackedAdvancementsRemote) {
                if (cachedAdvancementEntry.isEmpty() || "".equals(cachedAdvancementEntry) || !cachedAdvancementEntry.startsWith(serverId) || !advancement.idString.equals(cachedAdvancementEntry.split("::", 2)[1])) continue;
                log.debug("Adding remote tracked advancement {}", (Object)advancement);
                trackedAdvancement = advancement;
                break;
            }
        }
        if (!trackedAdvancementsLocal.isEmpty() && serverId == null) {
            for (String cachedAdvancementEntry : trackedAdvancementsLocal) {
                if (!advancement.idString.equals(cachedAdvancementEntry)) continue;
                log.debug("Adding local tracked advancement {}", (Object)advancement);
                trackedAdvancement = advancement;
                break;
            }
        }
        if (trackedAdvancement != null) {
            TrackedAdvancementsManager.trackAdvancement(trackedAdvancement, false);
        }
    }

    public static void trackAdvancement(AdvancementEntry advancement) {
        TrackedAdvancementsManager.trackAdvancement(advancement, true);
    }

    public static void trackAdvancement(AdvancementEntry advancement, boolean autosave) {
        if (advancement.isDone) {
            log.warn("Advancement {} is already done, no need to track it.", (Object)advancement);
            return;
        }
        for (AdvancementEntry trackedAdvancementEntry : trackedAdvancements) {
            if (trackedAdvancementEntry.id != advancement.id) continue;
            log.warn("Advancement {} is already tracked.", (Object)advancement);
            return;
        }
        if (trackedAdvancements.size() >= maxNumberOfTrackedAdvancements) {
            log.error("Number of tracked advancements {} exceeds the limit of {}", (Object)trackedAdvancements.size(), (Object)advancement);
        }
        log.info("Track Advancement {}", (Object)advancement);
        trackedAdvancements.add(advancement);
        if (autosave) {
            TrackedAdvancementsManager.saveTrackedAdvancements();
        }
        TrackedAdvancementsManager.updateTrackerWidget();
    }

    private static void saveTrackedAdvancements() {
        TrackedAdvancementsManager.saveTrackedAdvancementsRemote();
        TrackedAdvancementsManager.saveTrackedAdvancementsLocal();
    }

    private static void saveTrackedAdvancementsRemote() {
        if (serverId == null) {
            return;
        }
        ArrayList<String> trackedAdvancementsToSave = new ArrayList<String>();
        for (String trackedAdvancementRemote : trackedAdvancementsRemote) {
            if (trackedAdvancementRemote.isEmpty() || "".equals(trackedAdvancementRemote) || trackedAdvancementRemote.startsWith(serverId)) continue;
            trackedAdvancementsToSave.add(trackedAdvancementRemote);
        }
        for (AdvancementEntry trackedAdvancementEntry : trackedAdvancements) {
            trackedAdvancementsToSave.add(serverId + trackedAdvancementEntry.id.toString());
        }
        ClientConfig.CLIENT.trackedAdvancementsRemote.set(trackedAdvancementsToSave.stream().distinct().collect(Collectors.toList()));
        trackedAdvancementsRemote = (List)ClientConfig.CLIENT.trackedAdvancementsRemote.get();
        ClientConfig.CLIENT.trackedAdvancements.save();
    }

    private static void saveTrackedAdvancementsLocal() {
        if (serverId != null) {
            return;
        }
        ArrayList<String> trackedAdvancementsToSave = new ArrayList<String>();
        for (AdvancementEntry trackedAdvancementEntry : trackedAdvancements) {
            trackedAdvancementsToSave.add(trackedAdvancementEntry.id.toString());
        }
        ClientConfig.CLIENT.trackedAdvancementsLocal.set(trackedAdvancementsToSave.stream().distinct().collect(Collectors.toList()));
        trackedAdvancementsLocal = (List)ClientConfig.CLIENT.trackedAdvancementsLocal.get();
        ClientConfig.CLIENT.trackedAdvancements.save();
    }

    public static void untrackAdvancement(Advancement advancement) {
        TrackedAdvancementsManager.untrackAdvancement(advancement.func_192067_g());
    }

    public static void untrackAdvancement(AdvancementEntry advancement) {
        TrackedAdvancementsManager.untrackAdvancement(advancement.getId());
    }

    public static void untrackAdvancement(ResourceLocation advancementId) {
        AdvancementEntry existingAdvancementEntry = null;
        for (AdvancementEntry trackedAdvancementEntry : trackedAdvancements) {
            if (trackedAdvancementEntry.id != advancementId) continue;
            existingAdvancementEntry = trackedAdvancementEntry;
            break;
        }
        if (existingAdvancementEntry != null) {
            trackedAdvancements.remove(existingAdvancementEntry);
            TrackedAdvancementsManager.saveTrackedAdvancements();
            TrackedAdvancementsManager.updateTrackerWidget();
        }
    }

    public static int numOfTrackedAdvancements() {
        return trackedAdvancements.size();
    }

    public static boolean hasReachedTrackedAdvancementLimit() {
        return trackedAdvancements.size() >= maxNumberOfTrackedAdvancements;
    }

    public static boolean isTrackedAdvancement(Advancement advancement) {
        for (AdvancementEntry trackedAdvancementEntry : trackedAdvancements) {
            if (trackedAdvancementEntry.id != advancement.func_192067_g()) continue;
            return true;
        }
        return false;
    }

    private static void updateTrackerWidget() {
        TrackerWidget.setTrackedAdvancements(trackedAdvancements);
    }
}

