/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.advancementstracker.client.gui.component;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.markusbordihn.advancementstracker.client.gui.component.ScrollPanelContent;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.gui.ScrollPanel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScrollPanelManager
extends ScrollPanel {
    FontRenderer fontRenderer;
    Logger log = LogManager.getLogger((String)"AdvancementsTracker");
    Map<String, ScrollPanelContent> contentMap = new HashMap<String, ScrollPanelContent>();
    private int baseContentX;
    private int baseContentY;
    protected Minecraft minecraft;
    protected ResourceLocation background;
    protected TextureManager textureManager;
    protected int backgroundAlpha = 128;
    protected int contentHeight = 0;
    protected int contentX = 0;
    protected int contentY = 0;
    static final float TEXTURE_SCALE = 32.0f;
    static final int BORDER_COLOR = -5592406;

    protected ScrollPanelManager(Minecraft minecraft, int width, int height, int top, int left) {
        super(minecraft, width, height, top, left);
        this.log.debug("[Scroll Panel Manager] width:{} height:{} at top:{} left:{}", (Object)width, (Object)height, (Object)top, (Object)left);
        this.baseContentX = this.contentX = left;
        this.baseContentY = this.contentY = top;
        this.fontRenderer = minecraft.field_71466_p;
        this.minecraft = minecraft;
        this.textureManager = minecraft.func_110434_K();
    }

    public void addContent(String contentName, ScrollPanelContent content, boolean active) {
        this.log.debug("[Scroll Content] {} to scroll panel manager with {}x{} at x:{} y:{}", (Object)contentName, (Object)content.width, (Object)content.height, (Object)this.contentX, (Object)this.contentY);
        content.setMinecraftInstance(this.minecraft);
        content.hasScrollBar(this.hasScrollBar());
        content.setPosition(this.contentX, this.contentY);
        content.isActive = active;
        this.contentMap.put(contentName, content);
        this.contentY += content.height;
        this.contentHeight += content.height;
    }

    public void clearContent() {
        if (this.contentMap.size() <= 0) {
            return;
        }
        for (ScrollPanelContent scrollPanelContent : this.contentMap.values()) {
            scrollPanelContent.isActive = false;
        }
        this.contentMap = new HashMap<String, ScrollPanelContent>();
        this.contentX = this.baseContentX;
        this.contentY = this.baseContentY;
        this.contentHeight = 0;
        this.scrollDistance = 0.0f;
    }

    public void handleClick(ScrollPanelContent scrollPanelContent, int button) {
    }

    public boolean hasScrollBar() {
        return this.getContentHeight() + 4 - this.height > 0;
    }

    public void preRender() {
        boolean hasScrollBar = this.hasScrollBar();
        for (ScrollPanelContent scrollPanelContent : this.contentMap.values()) {
            scrollPanelContent.hasScrollBar(hasScrollBar);
            scrollPanelContent.scrollDistance = this.scrollDistance;
        }
    }

    public int getContentHeight() {
        return this.contentHeight;
    }

    protected void drawBackground() {
    }

    protected int getScrollAmount() {
        Objects.requireNonNull(this.fontRenderer);
        return 9 * 3;
    }

    public boolean clickPanel(double mouseX, double mouseY, int button) {
        if (mouseY + 4.0 >= 0.0) {
            float f = (float)this.height + this.scrollDistance;
            Objects.requireNonNull(this);
            if (mouseY <= (double)(f - 4.0f)) {
                boolean foundClickTarget = false;
                int baseX = (int)mouseX + this.baseContentX;
                int n = (int)mouseY + this.baseContentY;
                Objects.requireNonNull(this);
                int baseY = n + 4;
                for (ScrollPanelContent scrollPanelContent : this.contentMap.values()) {
                    if (scrollPanelContent.isInsideEventAreaY(baseY + scrollPanelContent.relativeY)) {
                        this.log.debug("Detected click for {} at x:{} y:{}", (Object)scrollPanelContent.getContentName(), (Object)baseX, (Object)baseY);
                        this.handleClick(scrollPanelContent, button);
                        scrollPanelContent.handleClick(baseX, baseY, button);
                        foundClickTarget = true;
                        scrollPanelContent.isActive = true;
                        continue;
                    }
                    scrollPanelContent.isActive = false;
                }
                if (!foundClickTarget) {
                    this.log.warn("Detected unmatched click on ScrollPanelManager at x:{} y:{}({}) button:{}", (Object)mouseX, (Object)mouseY, (Object)baseY, (Object)button);
                }
            }
        }
        return false;
    }

    protected void drawPanel(MatrixStack matrixStack, int entryRight, int relativeY, Tessellator tessellator, int mouseX, int mouseY) {
        if (this.background != null && this.background != TextureManager.field_194008_a) {
            this.textureManager.func_110577_a(this.background);
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
            buffer.func_225582_a_((double)this.left, (double)this.bottom, 0.0).func_225586_a_(128, 128, 128, this.backgroundAlpha).func_225583_a_((float)this.left / 32.0f, (float)(this.bottom + (int)this.scrollDistance) / 32.0f).func_181675_d();
            buffer.func_225582_a_((double)this.right, (double)this.bottom, 0.0).func_225586_a_(128, 128, 128, this.backgroundAlpha).func_225583_a_((float)this.right / 32.0f, (float)(this.bottom + (int)this.scrollDistance) / 32.0f).func_181675_d();
            buffer.func_225582_a_((double)this.right, (double)this.top, 0.0).func_225586_a_(128, 128, 128, this.backgroundAlpha).func_225583_a_((float)this.right / 32.0f, (float)(this.top + (int)this.scrollDistance) / 32.0f).func_181675_d();
            buffer.func_225582_a_((double)this.left, (double)this.top, 0.0).func_225586_a_(128, 128, 128, this.backgroundAlpha).func_225583_a_((float)this.left / 32.0f, (float)(this.top + (int)this.scrollDistance) / 32.0f).func_181675_d();
            tessellator.func_78381_a();
        }
        int baseY = (int)this.scrollDistance * -1;
        for (ScrollPanelContent scrollPanelContent : this.contentMap.values()) {
            if (this.hasScrollBar()) {
                scrollPanelContent.scrollDistance = this.scrollDistance;
                scrollPanelContent.setRelativeY(baseY);
            }
            scrollPanelContent.drawBackground(matrixStack, tessellator);
            if (scrollPanelContent.isActive) {
                ScrollPanelManager.func_238467_a_((MatrixStack)matrixStack, (int)scrollPanelContent.x, (int)scrollPanelContent.y, (int)scrollPanelContent.xMax, (int)scrollPanelContent.yMax, (int)0x40000000);
                this.func_238465_a_(matrixStack, scrollPanelContent.x, scrollPanelContent.xMax, scrollPanelContent.y, -5592406);
                this.func_238465_a_(matrixStack, scrollPanelContent.x, scrollPanelContent.xMax, scrollPanelContent.yMax - 1, -5592406);
                this.func_238473_b_(matrixStack, scrollPanelContent.x, scrollPanelContent.y, scrollPanelContent.yMax - 1, -5592406);
                this.func_238473_b_(matrixStack, scrollPanelContent.xMax - 1, scrollPanelContent.y, scrollPanelContent.yMax - 1, -5592406);
            }
            scrollPanelContent.drawContent(matrixStack, entryRight, relativeY, tessellator, mouseX, mouseY);
        }
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double scroll) {
        if (!this.hasScrollBar() || scroll == 0.0) {
            return false;
        }
        return super.func_231043_a_(mouseX, mouseY, scroll);
    }
}

