/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.advancementstracker.client.gui.overview;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.markusbordihn.advancementstracker.client.advancements.AdvancementEntry;
import de.markusbordihn.advancementstracker.client.advancements.AdvancementsManager;
import de.markusbordihn.advancementstracker.client.advancements.TrackedAdvancementsManager;
import de.markusbordihn.advancementstracker.client.gui.ScreenBuilder;
import de.markusbordihn.advancementstracker.client.gui.Textures;
import de.markusbordihn.advancementstracker.client.gui.component.ScrollPanelContent;
import de.markusbordihn.advancementstracker.client.gui.component.ScrollPanelManager;
import de.markusbordihn.advancementstracker.client.gui.utils.TextUtils;
import de.markusbordihn.advancementstracker.config.ClientConfig;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class OverviewScreen
extends ScreenBuilder {
    AdvancementCategoryPanel advancementCategoryPanel;
    AdvancementContentPanel advancementContentPanel;
    AdvancementInfoPanel advancementInfoPanel;
    int panelPadding = 5;
    int panelPaddingBottom = 25;
    int panelTop = 25;
    int panelWidth = (this.field_230708_k_ - this.panelPadding * 4) / 3;
    int panelHeight = this.field_230709_l_ - this.panelTop - this.panelPaddingBottom;
    private String noAdvancementsText = new TranslationTextComponent("advancementstracker.advancementScreen.noAdvancements").getString();
    private String titleText = new TranslationTextComponent("advancementstracker.advancementScreen.title").getString();
    private static boolean enabled = (Boolean)ClientConfig.CLIENT.overviewEnabled.get();

    public OverviewScreen() {
        super("advancementScreen.title");
    }

    @SubscribeEvent
    public static void handleWorldEventLoad(WorldEvent.Load event) {
        if (!event.getWorld().func_201670_d()) {
            return;
        }
        enabled = (Boolean)ClientConfig.CLIENT.overviewEnabled.get();
        if (enabled) {
            log.info("Enable Overview Screen ...");
        } else {
            log.warn("Overview Screen is disabled!");
        }
    }

    public void func_231160_c_() {
        if (!enabled) {
            return;
        }
        this.panelWidth = (this.field_230708_k_ - this.panelPadding * 4) / 3;
        this.panelHeight = this.field_230709_l_ - this.panelTop - this.panelPaddingBottom;
        this.advancementCategoryPanel = new AdvancementCategoryPanel(this.field_230706_i_, this.panelWidth, this.panelHeight, this.panelTop, this.panelPadding);
        this.advancementContentPanel = new AdvancementContentPanel(this.field_230706_i_, this.panelWidth, this.panelHeight, this.panelTop, this.panelPadding + (this.panelPadding + this.panelWidth) * 1, AdvancementsManager.getSelectedRootAdvancement());
        this.advancementInfoPanel = new AdvancementInfoPanel(this.field_230706_i_, this.panelWidth, this.panelHeight, this.panelTop, this.panelPadding + (this.panelPadding + this.panelWidth) * 2, AdvancementsManager.getSelectedAdvancement());
        this.advancementCategoryPanel.setAdvancementContentPanel(this.advancementContentPanel);
        this.advancementContentPanel.setAdvancementInfoPanel(this.advancementInfoPanel);
        this.field_230705_e_.add(this.advancementCategoryPanel);
        this.field_230705_e_.add(this.advancementContentPanel);
        this.field_230705_e_.add(this.advancementInfoPanel);
        this.func_230480_a_((Widget)new Button((this.field_230708_k_ - 200) / 2, this.field_230709_l_ - 22, 200, 20, (ITextComponent)new TranslationTextComponent("gui.done"), button -> this.closeScreen()));
    }

    public void closeScreen() {
        this.field_230706_i_.func_147108_a((Screen)null);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (!enabled) {
            return;
        }
        this.func_230446_a_(matrixStack);
        OverviewScreen.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)this.titleText, (int)(this.field_230708_k_ / 2), (int)10, (int)0xFFFFFF);
        if (AdvancementsManager.hasAdvancements() && this.advancementCategoryPanel != null && this.advancementContentPanel != null && this.advancementInfoPanel != null) {
            this.advancementCategoryPanel.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            this.advancementContentPanel.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            this.advancementInfoPanel.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        } else {
            OverviewScreen.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)this.noAdvancementsText, (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2), (int)0xFF0000);
        }
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    class AdvancementInfoPanel
    extends ScrollPanelManager {
        AdvancementInfoPanel(Minecraft minecraft, int width, int height, int top, int left, AdvancementEntry advancement) {
            super(minecraft, width, height, top, left);
            this.updateContent(advancement);
        }

        public void updateContent(AdvancementEntry advancement) {
            if (advancement == null) {
                ScreenBuilder.log.error("Unable to get info for advancement {}", (Object)advancement);
                return;
            }
            this.clearContent();
            String contentName = advancement.id.toString();
            this.addContent(contentName, new AdvancementInfo(AdvancementsManager.getSelectedAdvancement(), this.width), true);
            this.preRender();
        }
    }

    class AdvancementContentPanel
    extends ScrollPanelManager {
        AdvancementInfoPanel advancementInfoPanel;

        AdvancementContentPanel(Minecraft minecraft, int width, int height, int top, int left, AdvancementEntry rootAdvancement) {
            super(minecraft, width, height, top, left);
            this.updateContent(rootAdvancement);
        }

        public void updateContent(AdvancementEntry rootAdvancement) {
            if (rootAdvancement == null) {
                ScreenBuilder.log.error("Unable to get content for advancement category {}", (Object)rootAdvancement);
                return;
            }
            this.background = rootAdvancement.background;
            this.clearContent();
            Set<AdvancementEntry> advancements = AdvancementsManager.getAdvancementsByStatus(rootAdvancement);
            if (advancements == null) {
                ScreenBuilder.log.error("Unable to get content for root advancement {}", (Object)rootAdvancement);
                return;
            }
            for (AdvancementEntry advancement : advancements) {
                String contentName = advancement.id.toString();
                this.addContent(contentName, new AdvancementContent(advancement, this.width), advancement == AdvancementsManager.getSelectedAdvancement());
            }
            if (this.advancementInfoPanel != null) {
                this.advancementInfoPanel.updateContent(AdvancementsManager.getSelectedAdvancement());
            }
            this.preRender();
        }

        @Override
        public void handleClick(ScrollPanelContent scrollPanelContent, int button) {
            AdvancementContent advancementContent = (AdvancementContent)scrollPanelContent;
            AdvancementEntry clickedAdvancement = advancementContent.getAdvancement();
            AdvancementsManager.setSelectedAdvancement(clickedAdvancement);
            if (this.advancementInfoPanel != null) {
                this.advancementInfoPanel.updateContent(AdvancementsManager.getSelectedAdvancement());
            }
        }

        public void setAdvancementInfoPanel(AdvancementInfoPanel advancementInfoPanel) {
            this.advancementInfoPanel = advancementInfoPanel;
        }
    }

    class AdvancementCategoryPanel
    extends ScrollPanelManager {
        AdvancementContentPanel advancementContentPanel;

        AdvancementCategoryPanel(Minecraft minecraft, int width, int height, int top, int left) {
            super(minecraft, width, height, top, left);
            Set<AdvancementEntry> rootAdvancements = AdvancementsManager.getRootAdvancementsByTile();
            if (rootAdvancements == null) {
                return;
            }
            AdvancementEntry selectedRootAdvancement = AdvancementsManager.getSelectedRootAdvancement();
            for (AdvancementEntry advancement : rootAdvancements) {
                String contentName = advancement.id.toString();
                this.addContent(contentName, new AdvancementCategoryContent(advancement, this.width), advancement == selectedRootAdvancement);
            }
            this.preRender();
        }

        @Override
        public void handleClick(ScrollPanelContent scrollPanelContent, int button) {
            AdvancementCategoryContent advancementCategoryContent = (AdvancementCategoryContent)scrollPanelContent;
            AdvancementEntry clickedRootAdvancement = advancementCategoryContent.getAdvancement();
            AdvancementsManager.setSelectedRootAdvancement(clickedRootAdvancement);
            if (this.advancementContentPanel != null) {
                this.advancementContentPanel.updateContent(AdvancementsManager.getSelectedRootAdvancement());
            }
        }

        public void setAdvancementContentPanel(AdvancementContentPanel advancementContentPanel) {
            this.advancementContentPanel = advancementContentPanel;
        }
    }

    class AdvancementInfo
    extends ScrollPanelContent {
        AdvancementEntry advancement;
        String output;

        AdvancementInfo(AdvancementEntry advancement, int width) {
            int possibleTextHeight;
            long diffInMilliseconds;
            long diff;
            super(advancement.id.toString(), width, OverviewScreen.this.panelHeight - 4);
            this.output = "";
            this.advancement = advancement;
            if (this.advancement.description != null) {
                this.output = this.output + String.format("%s\n", this.advancement.description);
            }
            if (this.advancement.isDone && this.advancement.lastProgressDate != null && this.advancement.firstProgressDate != null && (diff = TimeUnit.DAYS.convert(diffInMilliseconds = Math.abs(this.advancement.lastProgressDate.getTime() - this.advancement.firstProgressDate.getTime()), TimeUnit.MILLISECONDS)) > 0L) {
                this.output = this.output + String.format("\nIt took about %s days to complete this advancements.\n", diff);
            }
            if (this.advancement.rewards != null && (this.advancement.rewardsExperience > 0 || this.advancement.rewardsLoot != null || this.advancement.rewardsRecipes != null)) {
                this.output = this.output + String.format("\nRewards\n", new Object[0]);
                if (this.advancement.rewardsExperience > 0) {
                    this.output = this.output + String.format("* %s xp\n", this.advancement.rewardsExperience);
                }
                if (this.advancement.rewardsLoot != null && this.advancement.rewardsLoot.length > 0) {
                    for (ResourceLocation rewardLoot : this.advancement.rewardsLoot) {
                        this.output = this.output + String.format("* %s\n", rewardLoot.toString());
                    }
                }
                if (this.advancement.rewardsRecipes != null && this.advancement.rewardsRecipes.length > 0) {
                    for (ResourceLocation rewardRecipe : this.advancement.rewardsRecipes) {
                        this.output = this.output + String.format("* %s\n", rewardRecipe.toString());
                    }
                }
            }
            if (this.advancement.completedCriteria != null && this.advancement.completedCriteria.iterator().hasNext()) {
                this.output = this.output + String.format("\nCompleted Criteria\n", new Object[0]);
                for (String criteria : this.advancement.completedCriteria) {
                    this.output = this.output + String.format("* %s\n", criteria);
                }
            }
            if (this.advancement.remainingCriteria != null && this.advancement.remainingCriteria.iterator().hasNext()) {
                this.output = this.output + String.format("\nRemaining Criteria\n", new Object[0]);
                for (String criteria : this.advancement.remainingCriteria) {
                    this.output = this.output + String.format("* %s\n", criteria);
                }
            }
            if ((possibleTextHeight = TextUtils.calculateTextHeight(this.output, width)) + 15 > this.height) {
                this.height = possibleTextHeight + 15;
            }
        }

        @Override
        protected void drawContent(MatrixStack matrixStack, int entryRight, int relativeY, Tessellator tess, int mouseX, int mouseY) {
            int yNext = this.drawTextWithShadow(matrixStack, this.advancement.title, this.x + 5, this.y + 5, 0xFFFFFF);
            this.drawTextRaw(matrixStack, this.output, this.x + 5, yNext + 2, 0xEEEEEE);
        }
    }

    class AdvancementContent
    extends ScrollPanelContent {
        AdvancementEntry advancement;

        AdvancementContent(AdvancementEntry advancement, int width) {
            super(advancement.id.toString(), width, 40);
            this.advancement = advancement;
        }

        @Override
        protected void drawContent(MatrixStack matrixStack, int entryRight, int relativeY, Tessellator tess, int mouseX, int mouseY) {
            if (this.advancement.icon != null) {
                this.minecraft.func_175599_af().func_175042_a(this.advancement.icon, this.x + 2, this.y + 4);
            }
            this.textureManager.func_110577_a(Textures.ICONS);
            if (Boolean.TRUE.equals(this.advancement.isDone)) {
                this.func_238474_b_(matrixStack, this.xMax - 20, this.y + 2, 0, 0, 18, 18);
            } else if (Boolean.TRUE.equals(this.advancement.isTracked())) {
                this.func_238474_b_(matrixStack, this.xMax - 18, this.y + 2, 40, 2, 14, 14);
            } else if (TrackedAdvancementsManager.hasReachedTrackedAdvancementLimit()) {
                this.func_238474_b_(matrixStack, this.xMax - 18, this.y + 2, 60, 2, 14, 14);
            } else {
                this.func_238474_b_(matrixStack, this.xMax - 18, this.y + 2, 20, 2, 14, 14);
            }
            int yNext = this.drawTrimmedTextWithShadow(matrixStack, this.advancement.title, this.x + 20, this.y + 6, this.width - 42, 0xFFFFFF);
            this.drawTextWithShadow(matrixStack, this.advancement.description, this.x + 20, yNext + 2, this.advancement.descriptionColor);
            this.func_238465_a_(matrixStack, this.x + 40, this.xMax - 40, this.yMax, 0x20CCCCCC);
        }

        @Override
        protected void handleClick(double mouseX, double mouseY, int button) {
            if (Boolean.TRUE.equals(this.advancement.isDone)) {
                return;
            }
            if ((double)(this.xMax - 18) < mouseX && mouseX < (double)this.xMax && (double)(this.baseY + 2) < mouseY && mouseY < (double)(this.baseY + 16)) {
                if (Boolean.TRUE.equals(this.advancement.isTracked())) {
                    TrackedAdvancementsManager.untrackAdvancement(this.advancement);
                } else if (!TrackedAdvancementsManager.hasReachedTrackedAdvancementLimit()) {
                    TrackedAdvancementsManager.trackAdvancement(this.advancement);
                }
            }
        }

        public AdvancementEntry getAdvancement() {
            return this.advancement;
        }
    }

    class AdvancementCategoryContent
    extends ScrollPanelContent {
        AdvancementEntry advancement;

        AdvancementCategoryContent(AdvancementEntry advancement, int width) {
            super(advancement.id.toString(), width, 40);
            this.advancement = advancement;
            this.background = advancement.background;
        }

        @Override
        protected void drawContent(MatrixStack matrixStack, int entryRight, int relativeY, Tessellator tessellator, int mouseX, int mouseY) {
            if (this.advancement.icon != null) {
                this.minecraft.func_175599_af().func_175042_a(this.advancement.icon, this.x + 2, this.y + 10);
            }
            int yNext = this.drawTextWithShadow(matrixStack, this.advancement.title, this.x + 20, this.y + 4, 0xFFFFFF);
            this.drawTextWithShadow(matrixStack, this.advancement.description, this.x + 20, yNext + 2, this.advancement.descriptionColor);
        }

        public AdvancementEntry getAdvancement() {
            return this.advancement;
        }
    }
}

