/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.advancementstracker.client.gui.utils;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;

public class TextUtils {
    private FontRenderer fontRenderer;

    public TextUtils(Minecraft minecraft) {
        this.fontRenderer = minecraft.field_71466_p;
    }

    public int drawText(MatrixStack matrixStack, String text, int x, int y, int width, int height, int color) {
        return this.drawText(matrixStack, text, x, y, width, height, color, false, false);
    }

    public int drawText(MatrixStack matrixStack, String text, int x, int y, int width, int color) {
        return this.drawText(matrixStack, text, x, y, width, 0, color, false, true);
    }

    public int drawTextWithShadow(MatrixStack matrixStack, String text, int x, int y, int width, int height, int color) {
        return this.drawText(matrixStack, text, x, y, width, height, color, true, false);
    }

    public int drawTextWithShadow(MatrixStack matrixStack, String text, double x, double y, double width, double height, int color) {
        return this.drawText(matrixStack, text, (int)x, (int)y, (int)width, (int)height, color, true, false);
    }

    public int drawText(MatrixStack matrixStack, String text, int x, int y, int width, int height, int color, boolean shadow, boolean fullHeight) {
        block8: {
            int maxTextLength = width - 2;
            if (this.fontRenderer.func_78256_a(text) <= maxTextLength) break block8;
            ArrayList textList = new ArrayList();
            textList.addAll(LanguageMap.func_74808_a().func_244260_a(this.fontRenderer.func_238420_b_().func_238365_g_(text, maxTextLength, Style.field_240709_b_)));
            Float ySplitPosition = Float.valueOf(y);
            for (IReorderingProcessor textLine : textList) {
                block10: {
                    block9: {
                        if (fullHeight) break block9;
                        float f = ySplitPosition.floatValue();
                        Objects.requireNonNull(this.fontRenderer);
                        if (!(f + 9.0f < (float)(y + height))) break block10;
                    }
                    if (shadow) {
                        this.fontRenderer.func_238407_a_(matrixStack, textLine, (float)x, ySplitPosition.floatValue(), color);
                    } else {
                        this.fontRenderer.func_238422_b_(matrixStack, textLine, (float)x, ySplitPosition.floatValue(), color);
                    }
                    float f = ySplitPosition.floatValue();
                    Objects.requireNonNull(this.fontRenderer);
                    ySplitPosition = Float.valueOf(f + 9.0f + 2.0f);
                    continue;
                }
                float f = ySplitPosition.floatValue();
                Objects.requireNonNull(this.fontRenderer);
                this.drawTextFromRight(matrixStack, "...", x + width - 2, Math.round(f - (float)(9 + 2)), color, shadow);
                break;
            }
            return Math.round(ySplitPosition.floatValue());
        }
        if (shadow) {
            this.fontRenderer.func_238405_a_(matrixStack, text, (float)x, (float)y, color);
        } else {
            this.fontRenderer.func_238421_b_(matrixStack, text, (float)x, (float)y, color);
        }
        Objects.requireNonNull(this.fontRenderer);
        return y + 9;
    }

    public int drawTextFromRight(MatrixStack matrixStack, String text, int x, int y, int color) {
        return this.drawTextFromRight(matrixStack, text, x, y, color, false);
    }

    public int drawTextFromRightWithShadow(MatrixStack matrixStack, String text, int x, int y, int color) {
        return this.drawTextFromRight(matrixStack, text, x, y, color, true);
    }

    public int drawTextFromRight(MatrixStack matrixStack, String text, int x, int y, int color, boolean shadow) {
        int textWidth = this.fontRenderer.func_78256_a(text);
        if (shadow) {
            this.fontRenderer.func_238405_a_(matrixStack, text, (float)x - (float)textWidth, (float)y, color);
        } else {
            this.fontRenderer.func_238421_b_(matrixStack, text, (float)x - (float)textWidth, (float)y, color);
        }
        return textWidth;
    }

    public int drawTrimmedText(MatrixStack matrixStack, String text, int x, int y, int width, int color) {
        return this.drawTrimmedText(matrixStack, text, x, y, width, color, false);
    }

    public int drawTrimmedTextWithShadow(MatrixStack matrixStack, String text, int x, int y, int width, int color) {
        return this.drawTrimmedText(matrixStack, text, x, y, width, color, true);
    }

    public int drawTrimmedText(MatrixStack matrixStack, String text, int x, int y, int width, int color, boolean shadow) {
        if (this.fontRenderer.func_78256_a(text) >= width) {
            StringTextComponent textComponent = new StringTextComponent(text);
            ITextProperties trimTextComponent = this.fontRenderer.func_238417_a_((ITextProperties)textComponent, width - 3);
            if (shadow) {
                this.fontRenderer.func_238405_a_(matrixStack, trimTextComponent.getString() + "...", (float)x, (float)y, color);
            } else {
                this.fontRenderer.func_238421_b_(matrixStack, trimTextComponent.getString() + "...", (float)x, (float)y, color);
            }
        } else if (shadow) {
            this.fontRenderer.func_238405_a_(matrixStack, text, (float)x, (float)y, color);
        } else {
            this.fontRenderer.func_238421_b_(matrixStack, text, (float)x, (float)y, color);
        }
        Objects.requireNonNull(this.fontRenderer);
        return y + 9;
    }

    public static int calculateTextHeight(String text, int width) {
        int maxTextLength = width - 2;
        Minecraft minecraft = Minecraft.func_71410_x();
        FontRenderer fontRenderer = minecraft.field_71466_p;
        if (fontRenderer.func_78256_a(text) > maxTextLength) {
            ArrayList textList = new ArrayList();
            textList.addAll(LanguageMap.func_74808_a().func_244260_a(fontRenderer.func_238420_b_().func_238365_g_(text, maxTextLength, Style.field_240709_b_)));
            int n = textList.size();
            Objects.requireNonNull(fontRenderer);
            return n * (9 + 2);
        }
        Objects.requireNonNull(fontRenderer);
        return 9;
    }
}

