/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.advancementstracker.client.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.markusbordihn.advancementstracker.client.advancements.AdvancementEntry;
import de.markusbordihn.advancementstracker.client.advancements.AdvancementsManager;
import de.markusbordihn.advancementstracker.client.gui.WidgetBuilder;
import de.markusbordihn.advancementstracker.client.gui.utils.TextUtils;
import de.markusbordihn.advancementstracker.config.ClientConfig;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.lwjgl.opengl.GL11;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class TrackerWidget
extends WidgetBuilder {
    private MainWindow mainWindow;
    private TextUtils textUtils;
    private int backgroundMax;
    private int height;
    private int left;
    private int leftMax;
    private int scaledHeight;
    private int scaledWidth;
    private int top;
    private int topMax;
    private int width;
    private String noAdvancementsText = new TranslationTextComponent("advancementstracker.advancementWidget.noAdvancements").getString();
    private String noTrackedAdvancementsText = new TranslationTextComponent("advancementstracker.advancementWidget.noTrackedAdvancements").getString();
    private static Set<AdvancementEntry> trackedAdvancements = new HashSet<AdvancementEntry>();
    private static TranslationTextComponent widgetTitle;
    private static boolean active;
    private static double configHeight;
    private static double configLeft;
    private static double configTop;
    private static double configWidth;
    private static int maxLinesForDescription;
    private static boolean enabled;
    protected static TrackerWidget trackerWidget;

    TrackerWidget() {
        super(Minecraft.func_71410_x());
        this.mainWindow = Minecraft.func_71410_x().func_228018_at_();
        this.textUtils = new TextUtils(Minecraft.func_71410_x());
    }

    @SubscribeEvent
    public static void handleWorldEventLoad(WorldEvent.Load event) {
        if (!event.getWorld().func_201670_d()) {
            return;
        }
        enabled = (Boolean)ClientConfig.CLIENT.widgetEnabled.get();
        configHeight = (Double)ClientConfig.CLIENT.widgetHeight.get();
        configLeft = (Double)ClientConfig.CLIENT.widgetLeft.get();
        configTop = (Double)ClientConfig.CLIENT.widgetTop.get();
        configWidth = (Double)ClientConfig.CLIENT.widgetWidth.get();
        maxLinesForDescription = (Integer)ClientConfig.CLIENT.widgetMaxLinesForDescription.get();
        if (enabled) {
            log.info("Enable Tracker Widget with {}x{} at top:{} and left:{}", (Object)configHeight, (Object)configWidth, (Object)configTop, (Object)configLeft);
        } else {
            log.warn("Tracker Widget is disabled!");
        }
    }

    @SubscribeEvent
    public static void handleRenderGameOverlayEventPre(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL || !enabled) {
            return;
        }
        if (trackerWidget == null) {
            trackerWidget = new TrackerWidget();
            widgetTitle = new TranslationTextComponent("advancementstracker.advancementWidget.title");
        }
        MatrixStack matrixStack = event.getMatrixStack();
        trackerWidget.renderTracker(matrixStack);
    }

    public void renderTracker(MatrixStack matrixStack) {
        if (!active || !enabled) {
            return;
        }
        GL11.glPushMatrix();
        int guiScaledWidth = this.mainWindow.func_198107_o();
        int guiScaledHeight = this.mainWindow.func_198087_p();
        if (this.scaledWidth != guiScaledWidth || this.scaledHeight != guiScaledHeight) {
            this.scaledWidth = guiScaledWidth;
            this.scaledHeight = guiScaledHeight;
            this.height = (int)((double)this.scaledHeight * configHeight);
            this.width = (int)((double)this.scaledWidth * configWidth);
            this.top = (int)((double)(this.scaledHeight - this.height) * configTop);
            this.topMax = this.top + this.height;
            this.left = (int)((double)(this.scaledWidth - this.width) * configLeft);
            this.leftMax = this.left + this.width;
            this.backgroundMax = this.topMax;
        }
        int topPos = this.top;
        boolean hasTrackedAdvancements = !trackedAdvancements.isEmpty();
        TrackerWidget.func_238467_a_((MatrixStack)matrixStack, (int)this.left, (int)this.top, (int)this.leftMax, (int)this.backgroundMax, (int)0x50000000);
        Objects.requireNonNull(this.fontRenderer);
        TrackerWidget.func_238467_a_((MatrixStack)matrixStack, (int)this.left, (int)this.top, (int)this.leftMax, (int)(this.top + 9 + 2), (int)0x50000000);
        topPos += 2;
        topPos = this.textUtils.drawTrimmedTextWithShadow(matrixStack, widgetTitle.getString(), this.left + 2, topPos, this.width - 2, -16711936);
        topPos += 3;
        Objects.requireNonNull(this.fontRenderer);
        int maxDescriptionHeight = maxLinesForDescription * (9 + 2);
        if (hasTrackedAdvancements) {
            for (AdvancementEntry advancement : trackedAdvancements) {
                if (advancement.icon != null) {
                    GL11.glPushMatrix();
                    GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                    this.field_73839_d.func_175599_af().func_175042_a(advancement.icon, (this.left + 2) * 2, (int)(((double)topPos - 0.5) * 2.0));
                    GL11.glPopMatrix();
                }
                if (advancement.maxCriteraRequired > 1) {
                    int criteriaCounterLength = this.textUtils.drawTextFromRightWithShadow(matrixStack, advancement.completedCriteriaNumber + "/" + advancement.maxCriteraRequired, this.left + this.width - 2, topPos, -1118720);
                    topPos = this.textUtils.drawTrimmedTextWithShadow(matrixStack, advancement.title, this.left + 12, topPos, this.width - criteriaCounterLength - 16, -256);
                } else {
                    topPos = this.textUtils.drawTrimmedTextWithShadow(matrixStack, advancement.title, this.left + 12, topPos, this.width - 12, -256);
                }
                topPos = this.textUtils.drawTextWithShadow(matrixStack, advancement.description, this.left + 2, topPos + 1, this.width - 2, maxDescriptionHeight, -1);
                topPos += 5;
            }
        } else {
            topPos = AdvancementsManager.hasAdvancements() ? this.textUtils.drawTextWithShadow(matrixStack, this.noTrackedAdvancementsText, this.left + 2, topPos, this.width, this.height, -286331154) : this.textUtils.drawTextWithShadow(matrixStack, this.noAdvancementsText, this.left + 2, topPos, this.width, this.height, -286331154);
        }
        this.backgroundMax = topPos;
        GL11.glPopMatrix();
    }

    public static void setActive(boolean active) {
        TrackerWidget.active = active;
    }

    public static void toggleActive() {
        TrackerWidget.setActive(!active);
    }

    public static void setTrackedAdvancements(Set<AdvancementEntry> advancementEntries) {
        trackedAdvancements = advancementEntries;
    }

    static {
        active = true;
        configHeight = (Double)ClientConfig.CLIENT.widgetHeight.get();
        configLeft = (Double)ClientConfig.CLIENT.widgetLeft.get();
        configTop = (Double)ClientConfig.CLIENT.widgetTop.get();
        configWidth = (Double)ClientConfig.CLIENT.widgetWidth.get();
        maxLinesForDescription = (Integer)ClientConfig.CLIENT.widgetMaxLinesForDescription.get();
        enabled = (Boolean)ClientConfig.CLIENT.widgetEnabled.get();
    }
}

