/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.advancementstracker.client.screen;

import de.markusbordihn.advancementstracker.client.gui.config.ConfigScreen;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.util.ScreenShotHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ScreenManager {
    private static final Logger log = LogManager.getLogger((String)"AdvancementsTracker");
    private static Timer timer = new Timer("Timer");

    protected ScreenManager() {
    }

    @SubscribeEvent
    public static void handleFMLClientSetupEvent(FMLClientSetupEvent event) {
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> (mc, screen) -> new ConfigScreen((Screen)screen));
    }

    public static void saveScreenshot(final File folder, String name, Long delay) {
        Minecraft minecraft;
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if ((minecraft = Minecraft.func_71410_x()) == null || minecraft.func_147110_a() == null) {
            return;
        }
        final Framebuffer framebuffer = minecraft.func_147110_a();
        final String screenshotName = String.format("%s-%s.png", name, new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()));
        final Consumer<ITextComponent> messageConsumer = unused -> new StringTextComponent("");
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                log.info("Saving screenshot {} under {} ...", (Object)screenshotName, (Object)folder);
                try {
                    ScreenShotHelper.func_148259_a((File)folder, (String)screenshotName, (int)framebuffer.field_147622_a, (int)framebuffer.field_147620_b, (Framebuffer)framebuffer, (Consumer)messageConsumer);
                }
                catch (Exception e) {
                    log.error("Unable to save screenshot {} under {} because of: {}", (Object)screenshotName, (Object)folder, (Object)e);
                }
                this.cancel();
            }
        };
        timer.schedule(task, delay);
    }
}

