/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.advancementstracker.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientConfig {
    private static final Logger log = LogManager.getLogger((String)"AdvancementsTracker");
    static final ForgeConfigSpec clientSpec;
    public static final Config CLIENT;

    private ClientConfig() {
    }

    @SubscribeEvent
    public static void handleModConfigLoadEvent(ModConfig.Loading event) {
        log.info("Loading client config file {}", (Object)event.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void handleModConfigReloadEvent(ModConfig.Reloading event) {
        log.info("Reloading client config file {}", (Object)event.getConfig().getFileName());
    }

    static {
        com.electronwill.nightconfig.core.Config.setInsertionOrderPreserved((boolean)true);
        Pair specPair = new ForgeConfigSpec.Builder().configure(Config::new);
        clientSpec = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Config)specPair.getLeft();
        log.info("Registering client config ...");
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, clientSpec);
    }

    public static class Config {
        public final ForgeConfigSpec.IntValue maxNumberOfTrackedAdvancements;
        public final ForgeConfigSpec.BooleanValue screenshotEnabled;
        public final ForgeConfigSpec.IntValue screenshotDelay;
        public final ForgeConfigSpec.BooleanValue overviewEnabled;
        public final ForgeConfigSpec.BooleanValue widgetEnabled;
        public final ForgeConfigSpec.DoubleValue widgetHeight;
        public final ForgeConfigSpec.DoubleValue widgetWidth;
        public final ForgeConfigSpec.DoubleValue widgetTop;
        public final ForgeConfigSpec.DoubleValue widgetLeft;
        public final ForgeConfigSpec.IntValue widgetMaxLinesForDescription;
        public final ForgeConfigSpec.ConfigValue<String> logLevel;
        public final ForgeConfigSpec.ConfigValue<List<String>> trackedAdvancements;
        public final ForgeConfigSpec.ConfigValue<List<String>> trackedAdvancementsRemote;
        public final ForgeConfigSpec.ConfigValue<List<String>> trackedAdvancementsLocal;

        Config(ForgeConfigSpec.Builder builder) {
            builder.comment("Advancements Tracker (Client configuration)");
            builder.push("general");
            this.maxNumberOfTrackedAdvancements = builder.defineInRange("maxNumberOfTrackedAdvancements", 3, 1, 5);
            this.trackedAdvancements = builder.comment("List of default tracked advancements, mostly used by mod packs.").define("trackedAdvancements", new ArrayList<String>(Arrays.asList("")));
            builder.pop();
            builder.push("screenshots");
            this.screenshotEnabled = builder.define("screenshotEnabled", true);
            this.screenshotDelay = builder.defineInRange("screenshotDelay", 700, 0, 10000);
            builder.pop();
            builder.push("gui");
            builder.push("overview");
            this.overviewEnabled = builder.define("overviewEnabled", true);
            builder.pop();
            builder.push("widget");
            this.widgetEnabled = builder.define("widgetEnabled", true);
            this.widgetHeight = builder.defineInRange("widgetHeight", 0.45, 0.0, 1.0);
            this.widgetWidth = builder.defineInRange("widgetWidth", 0.3, 0.0, 1.0);
            this.widgetTop = builder.defineInRange("widgetTop", 0.5, 0.0, 1.0);
            this.widgetLeft = builder.defineInRange("widgetLeft", 1.0, 0.0, 1.0);
            this.widgetMaxLinesForDescription = builder.defineInRange("widgetMaxLinesForDescription", 4, 1, 8);
            builder.pop();
            builder.pop();
            builder.push("Debug");
            this.logLevel = builder.comment("Changed the default log level to get more output.").define("logLevel", (Object)"info");
            builder.pop();
            builder.push("cache");
            this.trackedAdvancementsRemote = builder.define("trackedAdvancementsRemote", new ArrayList<String>(Arrays.asList("")));
            this.trackedAdvancementsLocal = builder.define("trackedAdvancementsLocal", new ArrayList<String>(Arrays.asList("")));
            builder.pop();
        }
    }
}

