/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.advancementstracker.debug;

import de.markusbordihn.advancementstracker.config.ClientConfig;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DebugManager {
    private static final Logger log = LogManager.getLogger((String)"AdvancementsTracker");

    protected DebugManager() {
    }

    @SubscribeEvent
    public static void handleModConfigLoadEvent(ModConfig.Loading event) {
        DebugManager.adjustLogLevel((String)ClientConfig.CLIENT.logLevel.get());
    }

    public static void adjustLogLevel(String logLevel) {
        log.info("Try to change log level to {}", (Object)logLevel);
        switch (logLevel) {
            case "info": {
                Configurator.setAllLevels((String)LogManager.getLogger((String)"AdvancementsTracker").getName(), (Level)Level.INFO);
                break;
            }
            case "trace": {
                Configurator.setAllLevels((String)LogManager.getLogger((String)"AdvancementsTracker").getName(), (Level)Level.TRACE);
                break;
            }
            case "debug": {
                Configurator.setAllLevels((String)LogManager.getLogger((String)"AdvancementsTracker").getName(), (Level)Level.DEBUG);
                break;
            }
            case "warn": {
                Configurator.setAllLevels((String)LogManager.getLogger((String)"AdvancementsTracker").getName(), (Level)Level.WARN);
                break;
            }
            case "error": {
                Configurator.setAllLevels((String)LogManager.getLogger((String)"AdvancementsTracker").getName(), (Level)Level.ERROR);
                break;
            }
            case "fatal": {
                Configurator.setAllLevels((String)LogManager.getLogger((String)"AdvancementsTracker").getName(), (Level)Level.FATAL);
                break;
            }
            default: {
                log.error("Got invalid log level {} from config file!", (Object)logLevel);
                Configurator.setAllLevels((String)LogManager.getLogger((String)"AdvancementsTracker").getName(), (Level)Level.INFO);
            }
        }
    }
}

