/*
 * Decompiled with CFR 0.152.
 */
package com.aether.entities.block;

import com.aether.blocks.AetherBlocks;
import com.aether.blocks.FloatingBlock;
import com.aether.entities.AetherEntityTypes;
import com.aether.entities.AetherNonLivingEntity;
import com.aether.entities.util.EntityData;
import com.aether.util.NetworkingHell;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.network.PacketContext;
import net.minecraft.class_1282;
import net.minecraft.class_129;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2199;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2292;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_2968;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3494;
import net.minecraft.class_3532;
import net.minecraft.class_3612;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_638;

public class FloatingBlockEntity
extends AetherNonLivingEntity {
    protected static final class_2940<class_2338> ORIGIN = class_2945.method_12791(FloatingBlockEntity.class, (class_2941)class_2943.field_13324);
    public int floatTime;
    public boolean dropItem = true;
    public class_2487 blockEntityData;
    private class_2680 blockState = AetherBlocks.GRAVITITE_ORE.method_9564();
    private boolean destroyedOnLanding;
    private boolean hurtEntities;
    private int floatHurtMax = 40;
    private float floatHurtAmount = 2.0f;

    public FloatingBlockEntity(class_1299<? extends FloatingBlockEntity> entityTypeIn, class_1937 worldIn) {
        super(entityTypeIn, worldIn);
    }

    public FloatingBlockEntity(class_1937 world, double x, double y, double z, class_2680 floatingBlockState) {
        this((class_1299<? extends FloatingBlockEntity>)AetherEntityTypes.FLOATING_BLOCK, world);
        this.blockState = floatingBlockState;
        this.field_23807 = true;
        this.method_5814(x, y, z);
        this.method_18799(class_243.field_1353);
        this.field_6014 = x;
        this.field_6036 = y;
        this.field_5969 = z;
        this.setOrigin(new class_2338(this.method_19538()));
    }

    public void method_5814(double x, double y, double z) {
        if (this.field_6011 == null) {
            super.method_5814(x, y, z);
        } else {
            class_2338 origin = this.getOrigin();
            class_265 colShape = this.blockState.method_26220((class_1922)this.field_6002, origin);
            if (colShape.method_1110()) {
                colShape = this.blockState.method_26218((class_1922)this.field_6002, origin);
            }
            if (colShape.method_1110()) {
                super.method_5814(x, y, z);
            } else {
                this.method_23327(x, y, z);
                class_238 box = colShape.method_1107();
                this.method_5857(box.method_997(this.method_19538().method_1020(new class_243(class_3532.method_16436((double)0.5, (double)box.field_1323, (double)box.field_1320), 0.0, class_3532.method_16436((double)0.5, (double)box.field_1321, (double)box.field_1324)))));
            }
        }
    }

    public boolean method_5732() {
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public class_2338 getOrigin() {
        return (class_2338)this.field_6011.method_12789(ORIGIN);
    }

    public void setOrigin(class_2338 origin) {
        this.field_6011.method_12778(ORIGIN, (Object)origin);
        this.method_5814(this.method_23317(), this.method_23318(), this.method_23321());
    }

    public boolean method_5658() {
        return false;
    }

    protected void method_5693() {
        this.field_6011.method_12784(ORIGIN, (Object)class_2338.field_10980);
    }

    public boolean method_5863() {
        return !this.field_5988 && !this.blockState.method_26220((class_1922)this.field_6002, this.getOrigin()).method_1110();
    }

    public boolean method_30948() {
        return this.method_5863();
    }

    public boolean method_30949(class_1297 other) {
        return !(other instanceof FloatingBlockEntity) && super.method_30949(other);
    }

    public void method_5773() {
    }

    public void postTickEntities() {
        if (this.blockState.method_26215()) {
            this.method_5650();
        } else {
            boolean isFastFloater;
            class_2338 blockPos;
            class_2248 block = this.blockState.method_26204();
            if (this.floatTime++ == 0) {
                blockPos = this.method_24515();
                if (this.field_6002.method_8320(blockPos).method_27852(block)) {
                    this.field_6002.method_8650(blockPos, false);
                } else if (!this.field_6002.field_9236) {
                    this.method_5650();
                    return;
                }
            }
            boolean bl = isFastFloater = this.blockState.method_26204() == AetherBlocks.GRAVITITE_ORE || this.blockState.method_26204() == AetherBlocks.GRAVITITE_LEVITATOR || this.blockState.method_26204() == AetherBlocks.BLOCK_OF_GRAVITITE;
            if (!this.method_5740()) {
                if (isFastFloater) {
                    this.method_18799(this.method_18798().method_1031(0.0, 0.05, 0.0));
                } else {
                    this.method_18799(this.method_18798().method_1031(0.0, 0.03, 0.0));
                }
            }
            class_238 oldBox = this.method_5829();
            this.method_5784(class_1313.field_6308, this.method_18798());
            class_238 newBox = this.method_5829();
            List otherEntities = this.field_6002.method_8335((class_1297)this, oldBox.method_991(newBox));
            for (class_1297 entity : otherEntities) {
                if (entity instanceof FloatingBlockEntity || entity.field_5960 || !(entity.method_23318() < newBox.field_1325)) continue;
                entity.method_5814(entity.method_19538().field_1352, newBox.field_1325, entity.method_19538().field_1350);
            }
            if (!this.field_6002.field_9236) {
                class_3965 blockHitResult;
                blockPos = this.method_24515();
                boolean isConcrete = this.blockState.method_26204() instanceof class_2292;
                boolean shouldSolidify = isConcrete && this.field_6002.method_8316(blockPos).method_15767((class_3494)class_3486.field_15517);
                double speed = this.method_18798().method_1027();
                if (isConcrete && speed > 1.0 && (blockHitResult = this.field_6002.method_17742(new class_3959(new class_243(this.field_6014, this.field_6036, this.field_5969), new class_243(this.method_23317(), this.method_23318(), this.method_23321()), class_3959.class_3960.field_17558, class_3959.class_242.field_1345, (class_1297)this))).method_17783() != class_239.class_240.field_1333 && this.field_6002.method_8316(blockHitResult.method_17777()).method_15767((class_3494)class_3486.field_15517)) {
                    blockPos = blockHitResult.method_17777();
                    shouldSolidify = true;
                }
                if (!this.field_5992 && !shouldSolidify) {
                    if (!this.field_6002.field_9236 && this.floatTime > 100 && blockPos.method_10264() > this.field_6002.method_8322() + 64) {
                        if (this.dropItem && this.field_6002.method_8450().method_8355(class_1928.field_19393) && this.field_6002.method_18458((double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260(), 4.0)) {
                            this.method_5706((class_1935)block);
                        }
                        this.method_5650();
                    }
                } else {
                    class_2680 blockState = this.field_6002.method_8320(blockPos);
                    this.method_18799(this.method_18798().method_18805(0.7, 0.5, 0.7));
                    if (blockState.method_26204() != class_2246.field_10008) {
                        this.method_5650();
                        if (!this.destroyedOnLanding) {
                            boolean canReplace = blockState.method_26166((class_1750)new class_2968(this.field_6002, blockPos, class_2350.field_11033, class_1799.field_8037, class_2350.field_11036));
                            if (!canReplace) {
                                canReplace = blockState.method_26166((class_1750)new class_2968(this.field_6002, blockPos, class_2350.field_11036, class_1799.field_8037, class_2350.field_11033));
                            }
                            boolean canPlace = this.blockState.method_26184((class_4538)this.field_6002, blockPos);
                            if (canReplace && canPlace) {
                                if (this.blockState.method_28498((class_2769)class_2741.field_12508) && this.field_6002.method_8316(blockPos).method_15772() == class_3612.field_15910) {
                                    this.blockState = (class_2680)this.blockState.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true));
                                }
                                if (this.field_6002.method_8652(blockPos, this.blockState, 3)) {
                                    class_2586 blockEntity;
                                    if (block instanceof FloatingBlock) {
                                        ((FloatingBlock)block).onEndFloating(this.field_6002, blockPos, this.blockState, blockState);
                                    }
                                    if (this.blockEntityData != null && this.blockState.method_26204().method_26161() && (blockEntity = this.field_6002.method_8321(blockPos)) != null) {
                                        class_2487 compoundTag = blockEntity.method_11007(new class_2487());
                                        for (String keyName : this.blockEntityData.method_10541()) {
                                            class_2520 tag = this.blockEntityData.method_10580(keyName);
                                            if (tag == null || "x".equals(keyName) || "y".equals(keyName) || "z".equals(keyName)) continue;
                                            compoundTag.method_10566(keyName, tag.method_10707());
                                        }
                                        blockEntity.method_11014(this.blockState, compoundTag);
                                        blockEntity.method_5431();
                                    }
                                } else if (this.dropItem && this.field_6002.method_8450().method_8355(class_1928.field_19393)) {
                                    this.method_5706((class_1935)block);
                                }
                            } else if (this.dropItem && this.field_6002.method_8450().method_8355(class_1928.field_19393)) {
                                this.method_5706((class_1935)block);
                            }
                        } else if (block instanceof FloatingBlock) {
                            ((FloatingBlock)block).onBroken(this.field_6002, blockPos);
                        }
                    }
                }
            }
            this.method_18799(this.method_18798().method_1021(0.98));
        }
    }

    public boolean method_5747(float distance, float damageMultiplier) {
        int i;
        if (this.hurtEntities && (i = class_3532.method_15386((float)(distance - 1.0f))) > 0) {
            ArrayList list = Lists.newArrayList((Iterable)this.field_6002.method_8335((class_1297)this, this.method_5829()));
            boolean flag = this.blockState.method_26164((class_3494)class_3481.field_15486);
            class_1282 damagesource = flag ? class_1282.field_5865 : class_1282.field_5847;
            for (class_1297 entity : list) {
                entity.method_5643(damagesource, (float)Math.min(class_3532.method_15375((float)((float)i * this.floatHurtAmount)), this.floatHurtMax));
            }
            if (flag && this.field_5974.nextFloat() < 0.05f + (float)i * 0.05f) {
                class_2680 blockstate = class_2199.method_9346((class_2680)this.blockState);
                if (blockstate == null) {
                    this.destroyedOnLanding = true;
                } else {
                    this.blockState = blockstate;
                }
            }
        }
        return false;
    }

    protected void method_5652(class_2487 compound) {
        compound.method_10566("BlockState", (class_2520)class_2512.method_10686((class_2680)this.blockState));
        compound.method_10569("Time", this.floatTime);
        compound.method_10556("DropItem", this.dropItem);
        compound.method_10556("HurtEntities", this.hurtEntities);
        compound.method_10548("FallHurtAmount", this.floatHurtAmount);
        compound.method_10569("FallHurtMax", this.floatHurtMax);
        if (this.blockEntityData != null) {
            compound.method_10566("TileEntityData", (class_2520)this.blockEntityData);
        }
    }

    protected void method_5749(class_2487 compound) {
        this.blockState = class_2512.method_10681((class_2487)compound.method_10562("BlockState"));
        this.floatTime = compound.method_10550("Time");
        if (compound.method_10573("HurtEntities", 99)) {
            this.hurtEntities = compound.method_10577("HurtEntities");
            this.floatHurtAmount = compound.method_10583("FallHurtAmount");
            this.floatHurtMax = compound.method_10550("FallHurtMax");
        } else if (this.blockState.method_26164((class_3494)class_3481.field_15486)) {
            this.hurtEntities = true;
        }
        if (compound.method_10573("DropItem", 99)) {
            this.dropItem = compound.method_10577("DropItem");
        }
        if (compound.method_10573("TileEntityData", 10)) {
            this.blockEntityData = compound.method_10562("TileEntityData");
        }
        if (this.blockState.method_26215()) {
            this.blockState = AetherBlocks.GRAVITITE_ORE.method_9564();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public class_1937 getWorldObj() {
        return this.field_6002;
    }

    public boolean method_5862() {
        return false;
    }

    public void method_5819(class_129 section) {
        super.method_5819(section);
        section.method_578("Immitating BlockState", (Object)this.blockState.toString());
    }

    public class_2680 getBlockState() {
        return this.blockState;
    }

    public void setHurtEntities(boolean hurtEntitiesIn) {
        this.hurtEntities = hurtEntitiesIn;
    }

    public boolean method_5833() {
        return true;
    }

    @Override
    public class_2960 createSpawnPacket(class_2540 buf) {
        super.createSpawnPacket(buf);
        buf.method_10794(class_2512.method_10686((class_2680)this.getBlockState()));
        return NetworkingHell.SPAWN_FLOATING_BLOCK_ENTITY;
    }

    public static void spawn(PacketContext ctx, class_2540 buf) {
        EntityData data = new EntityData(buf);
        class_2680 blockState = class_2512.method_10681((class_2487)Objects.requireNonNull(buf.method_10798()));
        ctx.getTaskQueue().execute(() -> {
            FloatingBlockEntity entity = new FloatingBlockEntity(ctx.getPlayer().field_6002, data.x, data.y, data.z, blockState);
            entity.method_18003(data.x, data.y, data.z);
            entity.method_24203(data.x, data.y, data.z);
            entity.method_5838(data.id);
            entity.method_5826(data.uuid);
            ((class_638)ctx.getPlayer().field_6002).method_2942(data.id, (class_1297)entity);
        });
    }

    public static boolean gravititeToolUsedOnBlock(class_1838 context, class_1792 item) {
        class_2338 blockPos;
        class_1937 world = context.method_8045();
        class_2680 blockState = world.method_8320(blockPos = context.method_8037());
        if ((!blockState.method_29291() || item.method_7856(blockState)) && class_2346.method_10128((class_2680)world.method_8320(blockPos.method_10084()))) {
            if (!world.field_9236) {
                FloatingBlockEntity floatingblockentity = new FloatingBlockEntity(world, (double)blockPos.method_10263() + 0.5, blockPos.method_10264(), (double)blockPos.method_10260() + 0.5, world.method_8320(blockPos));
                world.method_8649((class_1297)floatingblockentity);
            }
            return true;
        }
        return false;
    }

    public static interface ICPEM {
        public void postTick();
    }
}

