/*
 * Decompiled with CFR 0.152.
 */
package com.aether.entities.passive;

import com.aether.entities.AetherEntityTypes;
import com.aether.entities.ai.EatAetherGrassGoal;
import com.aether.items.AetherItems;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1429;
import net.minecraft.class_1542;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3956;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;

public class SheepuffEntity
extends class_1429 {
    private static final class_2940<Boolean> PUFFY = class_2945.method_12791(SheepuffEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Byte> COLOR = class_2945.method_12791(SheepuffEntity.class, (class_2941)class_2943.field_13319);
    private static final Map<class_1767, float[]> COLORS = Maps.newEnumMap(Arrays.stream(class_1767.values()).collect(Collectors.toMap(dyeColor_1 -> dyeColor_1, SheepuffEntity::getDyedColor)));
    private static final Map<class_1767, class_1935> DROPS = (Map)class_156.method_654((Object)Maps.newEnumMap(class_1767.class), enumMap_1 -> {
        enumMap_1.put(class_1767.field_7952, class_2246.field_10446);
        enumMap_1.put(class_1767.field_7946, class_2246.field_10095);
        enumMap_1.put(class_1767.field_7958, class_2246.field_10215);
        enumMap_1.put(class_1767.field_7951, class_2246.field_10294);
        enumMap_1.put(class_1767.field_7947, class_2246.field_10490);
        enumMap_1.put(class_1767.field_7961, class_2246.field_10028);
        enumMap_1.put(class_1767.field_7954, class_2246.field_10459);
        enumMap_1.put(class_1767.field_7944, class_2246.field_10423);
        enumMap_1.put(class_1767.field_7967, class_2246.field_10222);
        enumMap_1.put(class_1767.field_7955, class_2246.field_10619);
        enumMap_1.put(class_1767.field_7945, class_2246.field_10259);
        enumMap_1.put(class_1767.field_7966, class_2246.field_10514);
        enumMap_1.put(class_1767.field_7957, class_2246.field_10113);
        enumMap_1.put(class_1767.field_7942, class_2246.field_10170);
        enumMap_1.put(class_1767.field_7964, class_2246.field_10314);
        enumMap_1.put(class_1767.field_7963, class_2246.field_10146);
    });
    private EatAetherGrassGoal eatGrassGoal;
    private int sheepTimer;

    public SheepuffEntity(class_1937 world) {
        super(AetherEntityTypes.SHEEPUFF, world);
    }

    private static float[] getDyedColor(class_1767 color) {
        if (color == class_1767.field_7952) {
            return new float[]{0.9019608f, 0.9019608f, 0.9019608f};
        }
        float[] floats_1 = color.method_7787();
        return new float[]{floats_1[0] * 0.75f, floats_1[1] * 0.75f, floats_1[2] * 0.75f};
    }

    @Environment(value=EnvType.CLIENT)
    public static float[] getRgbColor(class_1767 dyeColor_1) {
        return COLORS.get(dyeColor_1);
    }

    public static class_1767 generateDefaultColor(Random random) {
        int int_1 = random.nextInt(100);
        if (int_1 < 5) {
            return class_1767.field_7963;
        }
        if (int_1 < 10) {
            return class_1767.field_7944;
        }
        if (int_1 < 15) {
            return class_1767.field_7967;
        }
        if (int_1 < 18) {
            return class_1767.field_7957;
        }
        return random.nextInt(500) == 0 ? class_1767.field_7954 : class_1767.field_7952;
    }

    private static class_1715 createDyeMixingCraftingInventory(class_1767 parentColor, class_1767 mateColor) {
        class_1715 craftingInventory_1 = new class_1715(new class_1703(null, -1){

            public boolean method_7597(class_1657 playerIn) {
                return false;
            }
        }, 2, 1);
        craftingInventory_1.method_5447(0, new class_1799((class_1935)class_1769.method_7803((class_1767)parentColor)));
        craftingInventory_1.method_5447(1, new class_1799((class_1935)class_1769.method_7803((class_1767)mateColor)));
        return craftingInventory_1;
    }

    public static class_5132.class_5133 initAttributes() {
        return AetherEntityTypes.getDefaultAttributes().method_26868(class_5134.field_23716, 8.0).method_26868(class_5134.field_23719, (double)0.23f);
    }

    protected void method_5959() {
        this.eatGrassGoal = new EatAetherGrassGoal((class_1308)this);
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1374((class_1314)this, 1.25));
        this.field_6201.method_6277(2, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new class_1391((class_1314)this, 1.1, class_1856.method_8091((class_1935[])new class_1935[]{AetherItems.BLUEBERRY}), false));
        this.field_6201.method_6277(4, (class_1352)new class_1353((class_1429)this, 1.1));
        this.field_6201.method_6277(5, (class_1352)this.eatGrassGoal);
        this.field_6201.method_6277(6, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(7, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
    }

    protected void method_5958() {
        this.sheepTimer = this.eatGrassGoal.getTimer();
        super.method_5958();
    }

    public void method_6007() {
        if (this.field_6002.field_9236) {
            this.sheepTimer = Math.max(0, this.sheepTimer - 1);
        }
        super.method_6007();
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(COLOR, (Object)0);
        this.field_6011.method_12784(PUFFY, (Object)false);
    }

    public class_2960 method_5991() {
        if (this.isSheared()) {
            return this.method_5864().method_16351();
        }
        return null;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_5711(byte id) {
        if (id == 10) {
            this.sheepTimer = 40;
        } else {
            super.method_5711(id);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public float getHeadRotationPointY(float float_1) {
        if (this.sheepTimer <= 0) {
            return 0.0f;
        }
        if (this.sheepTimer >= 4 && this.sheepTimer <= 36) {
            return 1.0f;
        }
        return this.sheepTimer < 4 ? ((float)this.sheepTimer - float_1) / 4.0f : -((float)(this.sheepTimer - 40) - float_1) / 4.0f;
    }

    @Environment(value=EnvType.CLIENT)
    public float getHeadRotationAngleX(float float_1) {
        if (this.sheepTimer > 4 && this.sheepTimer <= 36) {
            float float_2 = ((float)(this.sheepTimer - 4) - float_1) / 32.0f;
            return 0.62831855f + 0.21991149f * class_3532.method_15374((float)(float_2 * 28.7f));
        }
        return this.sheepTimer > 0 ? 0.62831855f : this.field_5965 * ((float)Math.PI / 180);
    }

    public class_1269 method_5992(class_1657 playerIn, class_1268 handIn) {
        class_1799 heldItem = playerIn.method_5998(handIn);
        if (heldItem.method_7909() == class_1802.field_8868 && !this.isSheared() && !this.method_6109()) {
            this.dropItems();
            heldItem.method_7956(1, (class_1309)playerIn, null);
        }
        return super.method_5992(playerIn, handIn);
    }

    public void dropItems() {
        if (!this.field_6002.field_9236) {
            if (this.isPuffed()) {
                this.setPuffed(false);
            } else {
                this.setSheared(true);
            }
            int int_1 = 1 + this.field_5974.nextInt(3);
            for (int int_2 = 0; int_2 < int_1; ++int_2) {
                class_1542 item = this.method_5870(DROPS.get(this.getColor()), 1);
                if (item == null) continue;
                item.method_18799(this.method_18798().method_1031((double)(this.field_5974.nextFloat() - this.field_5974.nextFloat() * 0.1f), (double)(this.field_5974.nextFloat() * 0.05f), (double)(this.field_5974.nextFloat() - this.field_5974.nextFloat() * 0.1f)));
            }
        }
        this.method_5783(class_3417.field_14975, 1.0f, 1.0f);
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10556("sheared", this.isSheared());
        compound.method_10567("color", (byte)this.getColor().method_7789());
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.setSheared(compound.method_10577("sheared"));
        this.setColor(class_1767.method_7791((int)compound.method_10571("color")));
    }

    protected class_3414 method_5994() {
        return class_3417.field_14603;
    }

    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_14730;
    }

    protected class_3414 method_6002() {
        return class_3417.field_14814;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(class_3417.field_14870, 0.15f, 1.0f);
    }

    public class_1767 getColor() {
        return class_1767.method_7791((int)((Byte)this.field_6011.method_12789(COLOR) & 0xF));
    }

    public void setColor(class_1767 dye) {
        byte byte_1 = (Byte)this.field_6011.method_12789(COLOR);
        this.field_6011.method_12778(COLOR, (Object)((byte)(byte_1 & 0xF0 | dye.method_7789() & 0xF)));
    }

    public boolean isSheared() {
        return ((Byte)this.field_6011.method_12789(COLOR) & 0x10) != 0;
    }

    public void setSheared(boolean sheared) {
        byte byte_1 = (Byte)this.field_6011.method_12789(COLOR);
        if (sheared) {
            this.field_6011.method_12778(COLOR, (Object)((byte)(byte_1 | 0x10)));
        } else {
            this.field_6011.method_12778(COLOR, (Object)((byte)(byte_1 & 0xFFFFFFEF)));
        }
    }

    public boolean isPuffed() {
        return (Boolean)this.field_6011.method_12789(PUFFY);
    }

    public void setPuffed(boolean puffy) {
        this.field_6011.method_12778(PUFFY, (Object)puffy);
    }

    public SheepuffEntity createChild(class_3218 world, class_1296 entity) {
        SheepuffEntity sheepEntity_1 = (SheepuffEntity)entity;
        SheepuffEntity sheepEntity_2 = new SheepuffEntity(this.field_6002);
        sheepEntity_2.setColor(this.getChildColor(this, sheepEntity_1));
        return sheepEntity_2;
    }

    public void method_5983() {
        if (!this.isSheared()) {
            this.setPuffed(true);
        } else {
            this.setSheared(false);
        }
        if (this.method_6109()) {
            this.method_5615(60);
        }
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 SpawnReason, class_1315 entityData, class_2487 compound) {
        entityData = super.method_5943(world, difficulty, SpawnReason, entityData, compound);
        this.setColor(SheepuffEntity.generateDefaultColor(world.method_8409()));
        return entityData;
    }

    private class_1767 getChildColor(class_1429 entity, class_1429 mate) {
        class_1767 parentColor = ((SheepuffEntity)entity).getColor();
        class_1767 mateColor = ((SheepuffEntity)mate).getColor();
        class_1715 craftingInventory_1 = SheepuffEntity.createDyeMixingCraftingInventory(parentColor, mateColor);
        Optional<class_1792> optionalItem = this.field_6002.method_8433().method_17877(class_3956.field_17545, (class_1263)craftingInventory_1, this.field_6002).stream().map(typedRecipe_1 -> typedRecipe_1.method_8116((class_1263)craftingInventory_1)).map(class_1799::method_7909).findAny();
        optionalItem = optionalItem.filter(class_1769.class::isInstance);
        return optionalItem.map(class_1769.class::cast).map(class_1769::method_7802).orElseGet(() -> this.field_6002.field_9229.nextBoolean() ? parentColor : mateColor);
    }

    public float method_18394(class_4050 pos, class_4048 size) {
        return 0.95f * size.field_18068;
    }
}

