/*
 * Decompiled with CFR 0.152.
 */
package com.aether.items.tools;

import com.aether.blocks.AetherBlocks;
import com.aether.entities.block.FloatingBlockEntity;
import com.aether.items.tools.IAetherTool;
import com.aether.items.utils.AetherTiers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class AetherHoe
extends class_1794
implements IAetherTool {
    protected static final Map<class_2248, class_2680> convertibleBlocks = Maps.newHashMap((Map)ImmutableMap.of((Object)class_2246.field_10219, (Object)class_2246.field_10362.method_9564(), (Object)class_2246.field_10194, (Object)class_2246.field_10362.method_9564(), (Object)class_2246.field_10566, (Object)class_2246.field_10362.method_9564(), (Object)class_2246.field_10253, (Object)class_2246.field_10566.method_9564()));
    private final AetherTiers material;

    public AetherHoe(AetherTiers material, class_1792.class_1793 settings, float attackSpeed) {
        super((class_1832)material.getDefaultTier(), 1, attackSpeed, settings);
        this.material = material;
        this.setupConvertibleData();
    }

    private void setupConvertibleData() {
        HashMap modifiedConvertibles = Maps.newHashMap((Map)ImmutableMap.of((Object)AetherBlocks.AETHER_GRASS_BLOCK, (Object)AetherBlocks.AETHER_FARMLAND.method_9564(), (Object)AetherBlocks.AETHER_DIRT_PATH, (Object)AetherBlocks.AETHER_FARMLAND.method_9564(), (Object)AetherBlocks.AETHER_DIRT, (Object)AetherBlocks.AETHER_FARMLAND.method_9564()));
        convertibleBlocks.putAll(modifiedConvertibles);
    }

    public float method_7865(class_1799 stack, class_2680 state) {
        float original = super.method_7865(stack, state);
        if (this.getItemMaterial() == AetherTiers.Zanite) {
            return original + this.calculateIncrease(stack);
        }
        return original;
    }

    private float calculateIncrease(class_1799 tool) {
        return (float)tool.method_7936() / (float)tool.method_7919() / 50.0f;
    }

    public class_1269 method_7884(class_1838 context) {
        class_2680 blockState;
        class_1937 world = context.method_8045();
        class_2338 blockPos = context.method_8037();
        if (this.getItemMaterial() == AetherTiers.Gravitite && FloatingBlockEntity.gravititeToolUsedOnBlock(context, (class_1792)this)) {
            return class_1269.field_5812;
        }
        if (context.method_8038() != class_2350.field_11033 && world.method_22347(blockPos.method_10084()) && (blockState = convertibleBlocks.get(world.method_8320(blockPos).method_26204())) != null) {
            class_1657 entityPlayer = context.method_8036();
            world.method_8396(entityPlayer, blockPos, class_3417.field_14846, class_3419.field_15245, 1.0f, 1.0f);
            if (!world.field_9236) {
                world.method_8652(blockPos, blockState, 11);
                if (entityPlayer != null) {
                    context.method_8041().method_7956(1, (class_1309)entityPlayer, null);
                }
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    @Override
    public AetherTiers getItemMaterial() {
        return this.material;
    }
}

