/*
 * Decompiled with CFR 0.152.
 */
package com.aether.mixin.client.render;

import com.aether.world.dimension.AetherDimension;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1060;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4063;
import net.minecraft.class_4493;
import net.minecraft.class_4587;
import net.minecraft.class_5294;
import net.minecraft.class_638;
import net.minecraft.class_761;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_761.class})
public final class CloudRendererMixin {
    @Final
    @Shadow
    private static final class_2960 field_4108 = new class_2960("textures/environment/clouds.png");
    @Shadow
    @NotNull
    private final class_638 field_4085;
    @Shadow
    private final int field_4073;
    @Final
    @Shadow
    @NotNull
    private final class_310 field_4088;
    @Final
    @Shadow
    @NotNull
    private final class_1060 field_4057;
    @Shadow
    private int field_4082;
    @Shadow
    private int field_4097;
    @Shadow
    private int field_4116;
    @Shadow
    @NotNull
    private class_243 field_4072;
    @Shadow
    @NotNull
    private class_4063 field_4080;
    @Shadow
    private boolean field_4107;
    @Shadow
    @NotNull
    private class_291 field_4094;

    public CloudRendererMixin() {
        throw new NullPointerException("null cannot be cast to non-null type net.minecraft.client.world.ClientWorld");
    }

    @Inject(method={"renderClouds(Lnet/minecraft/client/util/math/MatrixStack;FDDD)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderClouds(class_4587 matrices, float tickDelta, double cameraX, double cameraY, double cameraZ, CallbackInfo ci) {
        if (this.field_4085.method_27983() == AetherDimension.AETHER_WORLD_KEY) {
            this.internalCloudRender(matrices, tickDelta, cameraX, cameraY, cameraZ, 96.0f, 1.0f, 1.0f);
            this.internalCloudRender(matrices, tickDelta, cameraX, cameraY, cameraZ, 32.0f, 1.25f, -2.0f);
            this.internalCloudRender(matrices, tickDelta, cameraX, cameraY, cameraZ, -128.0f, 2.0f, 1.5f);
            ci.cancel();
        }
    }

    private void internalCloudRender(class_4587 matrices, float tickDelta, double cameraX, double cameraY, double cameraZ, float cloudOffset, float cloudScale, float speedMod) {
        class_5294 properties = this.field_4085.method_28103();
        float cloudHeight = properties.method_28108();
        if (!Float.isNaN(cloudHeight)) {
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            RenderSystem.enableAlphaTest();
            RenderSystem.enableDepthTest();
            RenderSystem.defaultAlphaFunc();
            RenderSystem.blendFuncSeparate((class_4493.class_4535)class_4493.class_4535.field_22541, (class_4493.class_4534)class_4493.class_4534.field_22523, (class_4493.class_4535)class_4493.class_4535.field_22534, (class_4493.class_4534)class_4493.class_4534.field_22523);
            RenderSystem.enableFog();
            RenderSystem.depthMask((boolean)true);
            double e = ((float)this.field_4073 + tickDelta) * (0.03f * speedMod);
            double posX = (cameraX + e) / 12.0;
            double renderHeight = cloudHeight - (float)cameraY + cloudOffset;
            double posZ = cameraZ / 12.0 + (double)0.33f;
            posX -= (double)(class_3532.method_15357((double)(posX / 2048.0)) * 2048);
            posZ -= (double)(class_3532.method_15357((double)(posZ / 2048.0)) * 2048);
            float adjustedX = (float)(posX - (double)class_3532.method_15357((double)posX));
            float adjustedY = (float)(renderHeight / 4.0 - (double)class_3532.method_15357((double)(renderHeight / 4.0))) * 4.0f;
            float adjustedZ = (float)(posZ - (double)class_3532.method_15357((double)posZ));
            class_243 cloudColor = this.field_4085.method_23785(tickDelta);
            int floorX = (int)Math.floor(posX);
            int floorY = (int)Math.floor(renderHeight / 4.0);
            int floorZ = (int)Math.floor(posZ);
            if (floorX != this.field_4082 || floorY != this.field_4097 || floorZ != this.field_4116 || this.field_4088.field_1690.method_1632() != this.field_4080 || this.field_4072.method_1025(cloudColor) > 2.0E-4) {
                this.field_4082 = floorX;
                this.field_4097 = floorY;
                this.field_4116 = floorZ;
                this.field_4072 = cloudColor;
                this.field_4080 = this.field_4088.field_1690.method_1632();
                this.field_4107 = true;
            }
            if (this.field_4107) {
                this.field_4107 = false;
                class_289 tessellator = class_289.method_1348();
                class_287 bufferBuilder = tessellator.method_1349();
                if (this.field_4094 != null) {
                    this.field_4094.close();
                }
                this.field_4094 = new class_291(class_290.field_1577);
                this.method_3239(bufferBuilder, posX, renderHeight, posZ, cloudColor);
                bufferBuilder.method_1326();
                this.field_4094.method_1352(bufferBuilder);
            }
            this.field_4057.method_22813(field_4108);
            matrices.method_22903();
            matrices.method_22905(12.0f, 1.0f, 12.0f);
            matrices.method_22905(cloudScale, cloudScale, cloudScale);
            matrices.method_22904((double)(-adjustedX), (double)adjustedY, (double)(-adjustedZ));
            if (this.field_4094 != null) {
                this.field_4094.method_1353();
                class_290.field_1577.method_22649(0L);
                int cloudIndex = 1;
                for (int cloudMainIndex = this.field_4080 == class_4063.field_18164 ? 0 : 1; cloudMainIndex <= cloudIndex; ++cloudMainIndex) {
                    if (cloudMainIndex == 0) {
                        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                    } else {
                        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                    }
                    class_291 cloudBuffer = this.field_4094;
                    class_4587.class_4665 entry = matrices.method_23760();
                    cloudBuffer.method_1351(entry.method_23761(), 7);
                }
                class_291.method_1354();
                class_290.field_1577.method_22651();
            }
            matrices.method_22909();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableAlphaTest();
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
            RenderSystem.disableFog();
        }
    }

    @Shadow
    private void method_3239(class_287 builder, double x, double y, double z, class_243 color) {
    }
}

