/*
 * Decompiled with CFR 0.152.
 */
package com.aether.world.feature;

import com.aether.world.feature.config.AercloudConfig;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.class_1945;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_3031;
import net.minecraft.class_3233;
import net.minecraft.class_5281;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class AercloudFeature
extends class_3031<AercloudConfig> {
    private static final Codec<AercloudConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2680.field_24734.fieldOf("state").forGetter(AercloudConfig::getCloudState), (App)Codec.BOOL.fieldOf("flat").forGetter(AercloudConfig::isFlat), (App)Codec.INT.fieldOf("maxRadius").forGetter(AercloudConfig::maxSegments), (App)Codec.INT.fieldOf("y").forGetter(AercloudConfig::getY)).apply((Applicative)instance, AercloudConfig::new));

    public AercloudFeature() {
        super(CODEC);
    }

    public boolean generate(class_5281 worldIn, class_2794 generator, Random randIn, class_2338 posIn, AercloudConfig configIn) {
        class_2338.class_2339 mut = new class_2338.class_2339(posIn.method_10263() + 8, randIn.nextInt(configIn.isFlat() ? 4 : 16) + 30 + configIn.getY(), posIn.method_10260() + 8);
        class_3233 region = (class_3233)worldIn;
        int size = randIn.nextInt(60) + 20;
        double s = Math.sqrt(size);
        ArrayList positions = new ArrayList();
        MutableBoolean fail = new MutableBoolean(false);
        for (int i = 0; i < size; ++i) {
            double v = s * Math.sin(Math.PI * (double)i / (double)size);
            int base = (int)(s + v);
            int width = (int)(randIn.nextDouble() * (double)base + s);
            int height = (int)(randIn.nextDouble() * (double)base + s / 2.0);
            int depth = (int)(randIn.nextDouble() * (double)base + s);
            class_2338.method_10097((class_2338)mut.method_10069(-width / 2, -height / 2, -depth / 2), (class_2338)mut.method_10069(width / 2, height / 2, depth / 2)).forEach(pos -> {
                if (worldIn.method_8320(pos).method_26215() && region.method_8393(pos.method_10263() >> 4, pos.method_10260() >> 4)) {
                    positions.add(new int[]{pos.method_10263(), pos.method_10264(), pos.method_10260()});
                } else {
                    fail.setTrue();
                }
            });
            int distance = (int)Math.ceil(s + (s - v));
            mut.method_10100(randIn.nextInt(distance) - distance / 2, randIn.nextInt(3) - 1, randIn.nextInt(distance) - distance / 2);
        }
        if (!fail.booleanValue()) {
            for (int[] pos2 : positions) {
                mut.method_10103(pos2[0], pos2[1], pos2[2]);
                this.method_13153((class_1945)worldIn, (class_2338)mut, configIn.getCloudState());
            }
        }
        return !fail.booleanValue();
    }
}

