/*
 * Decompiled with CFR 0.152.
 */
package com.aether.world.feature.structure;

import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3773;
import net.minecraft.class_5138;
import net.minecraft.class_5281;

public abstract class AetherStructureGenerator
extends class_3443 {
    public int chance;
    public class_2680 airState = class_2246.field_10124.method_9564();
    public class_2680 blockState;
    public class_2680 extraBlockState;
    public boolean replaceAir;
    public boolean replaceSolid;
    public class_5281 world;
    public Random random;
    public class_3341 structureBoundingBox;
    public class_2794 chunkGenerator;
    public class_1923 chunkPos;
    private int startX;
    private int startY;
    private int startZ;

    public AetherStructureGenerator(class_3773 piece, class_2487 compound) {
        super(piece, compound);
    }

    public void setBlocks(class_2680 blockState) {
        this.blockState = blockState;
        this.extraBlockState = null;
        this.chance = 0;
    }

    public void setBlocks(class_2680 blockState, class_2680 extraBlockState, int chance) {
        this.blockState = blockState;
        this.extraBlockState = extraBlockState;
        this.chance = chance;
        if (this.chance < 1) {
            this.chance = 1;
        }
    }

    public void setStructureOffset(int x, int y, int z) {
        this.startX = x;
        this.startY = y;
        this.startZ = z;
    }

    public void addLineX(int x, int y, int z, int xRange) {
        for (int lineX = x; lineX < x + xRange; ++lineX) {
            class_2248 block = this.getBlockState(lineX + this.startX, y + this.startY, z + this.startZ).method_26204();
            if (!this.replaceAir && block == class_2246.field_10124 || !this.replaceSolid && block != class_2246.field_10124) continue;
            this.setBlock(lineX + this.startX, y + this.startY, z + this.startZ);
        }
    }

    public void addLineY(int x, int y, int z, int yRange) {
        for (int lineY = y; lineY < y + yRange; ++lineY) {
            class_2248 block = this.getBlockState(x + this.startX, lineY + this.startY, z + this.startZ).method_26204();
            if (!this.replaceAir && block == class_2246.field_10124 || !this.replaceSolid && block != class_2246.field_10124) continue;
            this.setBlock(x + this.startX, lineY + this.startY, z + this.startZ);
        }
    }

    public void addLineZ(int x, int y, int z, int zRange) {
        for (int lineZ = z; lineZ < z + zRange; ++lineZ) {
            class_2248 block = this.getBlockState(x + this.startX, y + this.startY, lineZ + this.startZ).method_26204();
            if (!this.replaceAir && block == class_2246.field_10124 || !this.replaceSolid && block != class_2246.field_10124) continue;
            this.setBlock(x + this.startX, y + this.startY, lineZ + this.startZ);
        }
    }

    public void addPlaneX(int x, int y, int z, int yRange, int zRange) {
        for (int lineY = y; lineY < y + yRange; ++lineY) {
            for (int lineZ = z; lineZ < z + zRange; ++lineZ) {
                class_2248 block = this.getBlockState(x + this.startX, lineY + this.startY, lineZ + this.startZ).method_26204();
                if (!this.replaceAir && block == class_2246.field_10124 || !this.replaceSolid && block != class_2246.field_10124) continue;
                this.setBlock(x + this.startX, lineY + this.startY, lineZ + this.startZ);
            }
        }
    }

    public void addPlaneY(int x, int y, int z, int xRange, int zRange) {
        for (int lineX = x; lineX < x + xRange; ++lineX) {
            for (int lineZ = z; lineZ < z + zRange; ++lineZ) {
                class_2248 block = this.getBlockState(lineX + this.startX, y + this.startY, lineZ + this.startZ).method_26204();
                if (!this.replaceAir && block == class_2246.field_10124 || !this.replaceSolid && block != class_2246.field_10124) continue;
                this.setBlock(lineX + this.startX, y + this.startY, lineZ + this.startZ);
            }
        }
    }

    public void addPlaneZ(int x, int y, int z, int xRange, int yRange) {
        for (int lineX = x; lineX < x + xRange; ++lineX) {
            for (int lineY = y; lineY < y + yRange; ++lineY) {
                class_2248 block = this.getBlockState(lineX + this.startX, lineY + this.startY, z + this.startZ).method_26204();
                if (!this.replaceAir && block == class_2246.field_10124 || !this.replaceSolid && block != class_2246.field_10124) continue;
                this.setBlock(lineX + this.startX, lineY + this.startY, z + this.startZ);
            }
        }
    }

    public void addHollowBox(int x, int y, int z, int xRange, int yRange, int zRange) {
        class_2680 temp1 = this.blockState;
        class_2680 temp2 = this.extraBlockState;
        this.setBlocks(this.airState, this.airState, this.chance);
        this.addSolidBox(x, y, z, xRange, yRange, zRange);
        this.setBlocks(temp1, temp2, this.chance);
        this.addPlaneY(x, y, z, xRange, zRange);
        this.addPlaneY(x, y + (yRange - 1), z, xRange, zRange);
        this.addPlaneX(x, y, z, yRange, zRange);
        this.addPlaneX(x + (xRange - 1), y, z, yRange, zRange);
        this.addPlaneZ(x, y, z, xRange, yRange);
        this.addPlaneZ(x, y, z + (zRange - 1), xRange, yRange);
    }

    public void addSquareTube(int x, int y, int z, int xRange, int yRange, int zRange, int angel) {
        class_2680 temp1 = this.blockState;
        class_2680 temp2 = this.extraBlockState;
        this.setBlocks(this.airState, this.airState, this.chance);
        this.addSolidBox(x, y, z, xRange, yRange, zRange);
        this.setBlocks(temp1, temp2, this.chance);
        if (angel == 0 || angel == 2) {
            this.addPlaneY(x, y, z, xRange, zRange);
            this.addPlaneY(x, y + (yRange - 1), z, xRange, zRange);
        }
        if (angel == 1 || angel == 2) {
            this.addPlaneX(x, y, z, yRange, zRange);
            this.addPlaneX(x + (xRange - 1), y, z, yRange, zRange);
        }
        if (angel == 0 || angel == 1) {
            this.addPlaneZ(x, y, z, xRange, yRange);
            this.addPlaneZ(x, y, z + (zRange - 1), xRange, yRange);
        }
    }

    public void addSolidBox(int x, int y, int z, int xRange, int yRange, int zRange) {
        for (int lineX = x; lineX < x + xRange; ++lineX) {
            for (int lineY = y; lineY < y + yRange; ++lineY) {
                for (int lineZ = z; lineZ < z + zRange; ++lineZ) {
                    class_2248 block = this.getBlockState(lineX + this.startX, lineY + this.startY, lineZ + this.startZ).method_26204();
                    if (!this.replaceAir && block == class_2246.field_10124 || !this.replaceSolid && block != class_2246.field_10124) continue;
                    this.setBlock(lineX + this.startX, lineY + this.startY, lineZ + this.startZ);
                }
            }
        }
    }

    public boolean isBoxSolid(int x, int y, int z, int xRange, int yRange, int zRange) {
        boolean flag = true;
        for (int lineX = x; lineX < x + xRange; ++lineX) {
            for (int lineY = y; lineY < y + yRange; ++lineY) {
                for (int lineZ = z; lineZ < z + zRange; ++lineZ) {
                    if (this.getBlockState(lineX + this.startX, lineY + this.startY, lineZ + this.startZ).method_26204() != class_2246.field_10124) continue;
                    flag = false;
                }
            }
        }
        return flag;
    }

    public boolean isBoxEmpty(int x, int y, int z, int xRange, int yRange, int zRange) {
        boolean flag = true;
        for (int lineX = x; lineX < x + xRange; ++lineX) {
            for (int lineY = y; lineY < y + yRange; ++lineY) {
                for (int lineZ = z; lineZ < z + zRange; ++lineZ) {
                    if (this.getBlockState(lineX + this.startX, lineY + this.startY, lineZ + this.startZ).method_26204() == class_2246.field_10124) continue;
                    flag = false;
                }
            }
        }
        return flag;
    }

    public class_2586 getTileEntityFromPosWithOffset(int x, int y, int z) {
        class_2338 blockpos = new class_2338(this.getActualX(x, z), this.getActualY(y), this.getActualZ(x, z));
        return !this.structureBoundingBox.method_14662((class_2382)blockpos) ? null : this.world.method_8321(blockpos);
    }

    public class_2680 getBlockStateWithOffset(int x, int y, int z) {
        return this.method_14929((class_1922)this.world, x + this.startX, y + this.startY, z + this.startZ, this.structureBoundingBox);
    }

    public class_2680 getBlockState(int x, int y, int z) {
        return this.method_14929((class_1922)this.world, x, y, z, this.structureBoundingBox);
    }

    public void setBlockWithOffset(int x, int y, int z, class_2680 state) {
        this.method_14917(this.world, state, x + this.startX, y + this.startY, z + this.startZ, this.structureBoundingBox);
    }

    public void setBlock(int x, int y, int z, class_2680 state) {
        this.method_14917(this.world, state, x, y, z, this.structureBoundingBox);
    }

    public void setBlockWithOffset(int x, int y, int z) {
        if (this.chance == 0) {
            this.setBlock(x + this.startX, y + this.startY, z + this.startZ, this.blockState);
            return;
        }
        if (this.random.nextInt(this.chance) == 0) {
            this.method_14917(this.world, this.extraBlockState, x + this.startX, y + this.startY, z + this.startZ, this.structureBoundingBox);
        } else {
            this.method_14917(this.world, this.blockState, x + this.startX, y + this.startY, z + this.startZ, this.structureBoundingBox);
        }
    }

    public void setBlock(int x, int y, int z) {
        if (this.chance == 0) {
            this.setBlock(x, y, z, this.blockState);
            return;
        }
        if (this.random.nextInt(this.chance) == 0) {
            this.method_14917(this.world, this.extraBlockState, x, y, z, this.structureBoundingBox);
        } else {
            this.method_14917(this.world, this.blockState, x, y, z, this.structureBoundingBox);
        }
    }

    public boolean spawnEntity(class_1297 entity, int structureX, int structureY, int structureZ) {
        int posZ;
        int posY;
        int posX = this.getActualX(structureX, structureZ);
        if (this.structureBoundingBox.method_14662((class_2382)new class_2338(posX, posY = this.getActualY(structureY), posZ = this.getActualZ(structureX, structureZ)))) {
            entity.method_5641((double)posX + 0.5, (double)posY + 0.5, (double)posZ + 0.5, 0.0f, 0.0f);
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                livingEntity.method_6025(livingEntity.method_6063());
            }
            if (!this.world.method_8608()) {
                this.world.method_8649(entity);
            }
            return true;
        }
        return false;
    }

    public int getActualX(int structureX, int structureZ) {
        return this.method_14928(structureX + this.startX, structureZ + this.startZ);
    }

    public int getActualY(int structureY) {
        return this.method_14924(structureY + this.startY);
    }

    public int getActualZ(int structureX, int structureZ) {
        return this.method_14941(structureX + this.startX, structureZ + this.startZ);
    }

    public abstract boolean generate();

    public boolean method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, Random random, class_3341 boundingBox, class_1923 chunkPos, class_2338 blockPos) {
        this.world = world;
        this.chunkGenerator = chunkGenerator;
        this.random = random;
        this.structureBoundingBox = boundingBox;
        this.chunkPos = chunkPos;
        return this.generate();
    }

    protected void method_14943(class_2487 compound) {
    }
}

