/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.rabbit_tamer.Util;

import com.cobbs.rabbit_tamer.Util.DataStorage.Pet.EPosition;
import com.cobbs.rabbit_tamer.Util.Events.ModEvents;
import com.cobbs.rabbit_tamer.Util.Goals.GoalHolder;
import com.cobbs.rabbit_tamer.Util.Goals.ModRiderGoal;
import com.cobbs.rabbit_tamer.Util.MainConfig;
import com.cobbs.rabbit_tamer.Util.ModHelper;
import com.cobbs.rabbit_tamer.Util.ObfuscationHelper;
import com.cobbs.rabbit_tamer.Util.ShiftClickHandler;
import com.cobbs.rabbit_tamer.Util.StateHandler;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.OcelotAttackGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.passive.DolphinEntity;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.passive.OcelotEntity;
import net.minecraft.entity.passive.PandaEntity;
import net.minecraft.entity.passive.ParrotEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.passive.PolarBearEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.passive.StriderEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;

public enum EPet {
    FOX(FoxEntity.class, goal -> goal instanceof NearestAttackableTargetGoal || goal instanceof PanicGoal || goal instanceof AvoidEntityGoal, (e, p) -> {
        if (p == EPosition.STOPPED) {
            ((FoxEntity)e).func_213466_r(true);
        } else {
            ((FoxEntity)e).func_213466_r(false);
        }
        return false;
    }, null, (p, e) -> ObfuscationHelper.spitOutItem((FoxEntity)e)),
    RABBIT(RabbitEntity.class, goal -> goal instanceof AvoidEntityGoal || goal instanceof PanicGoal, null, null, ModHelper::equipRabbitOnPlayer),
    POLAR_BEAR(PolarBearEntity.class, goal -> goal instanceof NearestAttackableTargetGoal || goal instanceof PanicGoal || goal instanceof MeleeAttackGoal, null, e -> ((PolarBearEntity)e).func_241356_K__(), (p, e) -> ((PolarBearEntity)e).func_189794_p(!((PolarBearEntity)e).func_189793_df()), false, false, true, false, e -> new GoalHolder(0, new ModRiderGoal((MobEntity)e))),
    PANDA(PandaEntity.class, goal -> goal instanceof NearestAttackableTargetGoal || goal instanceof PanicGoal || goal instanceof MeleeAttackGoal || goal instanceof AvoidEntityGoal, null, null, (e, p) -> ((PandaEntity)p).func_213576_v(true)),
    OCELOT(OcelotEntity.class, goal -> goal instanceof NearestAttackableTargetGoal || goal instanceof PanicGoal || goal instanceof OcelotAttackGoal || goal instanceof TemptGoal || goal instanceof AvoidEntityGoal, null, e -> ObfuscationHelper.setTrusting((OcelotEntity)e), null),
    DOLPHIN(DolphinEntity.class, goal -> true, null, MobEntity::func_110163_bv, ModHelper::getOnAnimal, false, true, true, false, new Function[0]),
    WOLF(WolfEntity.class, goal -> goal instanceof FollowOwnerGoal, ModHelper::vanillaStateChangeHook, e -> ModEvents.applyCustomFollow(e, 6, 1.0f, 10.0f, 2.0f, false), null, true),
    CAT(CatEntity.class, goal -> goal instanceof FollowOwnerGoal, ModHelper::vanillaStateChangeHook, e -> ModEvents.applyCustomFollow(e, 6, 1.0f, 10.0f, 5.0f, false), null, true),
    PARROT(ParrotEntity.class, goal -> goal instanceof FollowOwnerGoal, ModHelper::vanillaStateChangeHook, e -> ModEvents.applyCustomFollow(e, 2, 1.0f, 5.0f, 1.0f, true), null, true),
    PIG(PigEntity.class, goal -> goal instanceof PanicGoal, null, null, null, false, true, false, false, new Function[0]),
    SHEEP(SheepEntity.class, goal -> goal instanceof PanicGoal, null, null, null, false, false, false, false, new Function[0]),
    COW(CowEntity.class, goal -> goal instanceof PanicGoal, null, null, null, false, false, false, false, new Function[0]),
    CHICKEN(ChickenEntity.class, goal -> goal instanceof PanicGoal, null, null, null, false, false, false, false, new Function[0]),
    STRIDER(StriderEntity.class, goal -> goal instanceof PanicGoal, null, null, null, false, true, false, false, new Function[0]);

    public final Class<? extends LivingEntity> type;
    public Item[] blockingItems;
    public Item tameItem;
    public Predicate<Goal> goalPredicate;
    public StateHandler onChangeState;
    public Consumer<MobEntity> onTame;
    public ShiftClickHandler onShiftRightClick;
    public boolean extendedVanilla;
    public boolean invertClick;
    public Function<MobEntity, GoalHolder>[] customGoals;
    public boolean hasProtection;
    public boolean requiresMount;

    private EPet(Class<? extends LivingEntity> type, Predicate<Goal> goalPredicate, StateHandler onChangeState, Consumer<MobEntity> onTame, ShiftClickHandler onShiftRightClick, boolean extendedVanilla) {
        this(type, goalPredicate, onChangeState, onTame, onShiftRightClick, extendedVanilla, false, !extendedVanilla, false, new Function[0]);
    }

    private EPet(Class<? extends LivingEntity> type, Predicate<Goal> goalPredicate, StateHandler onChangeState, Consumer<MobEntity> onTame, ShiftClickHandler onShiftRightClick) {
        this(type, goalPredicate, onChangeState, onTame, onShiftRightClick, false, false, true, false, new Function[0]);
    }

    private EPet(Class<? extends LivingEntity> type, Predicate<Goal> goalPredicate, StateHandler onChangeState, Consumer<MobEntity> onTame, ShiftClickHandler onShiftRightClick, boolean extendedVanilla, boolean invertClick, boolean hasProtection, boolean requiresMount, Function<MobEntity, GoalHolder> ... customGoals) {
        this.type = type;
        this.goalPredicate = goalPredicate;
        this.onChangeState = onChangeState;
        this.onTame = onTame;
        this.onShiftRightClick = onShiftRightClick;
        this.extendedVanilla = extendedVanilla;
        this.invertClick = invertClick;
        this.hasProtection = hasProtection;
        this.requiresMount = requiresMount;
        this.customGoals = customGoals;
    }

    public boolean matchesAnimal(Entity e) {
        return this.type.isInstance(e);
    }

    public boolean isBlockedItem(Item i) {
        if (this.blockingItems == null) {
            return false;
        }
        for (Item item : this.blockingItems) {
            if (i != item) continue;
            return true;
        }
        return false;
    }

    public boolean isBlockedItem(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        return this.isBlockedItem(stack.func_77973_b());
    }

    public boolean isTameItem(Item i) {
        return i == this.tameItem;
    }

    public boolean isTameItem(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        return this.isTameItem(stack.func_77973_b());
    }

    public boolean changeState(MobEntity entity, EPosition state) {
        if (this.onChangeState != null) {
            return this.onChangeState.run(entity, state);
        }
        return false;
    }

    public void tame(MobEntity entity) {
        if (this.onTame != null) {
            this.onTame.accept(entity);
        }
    }

    public void shiftClick(PlayerEntity player, MobEntity entity) {
        if (this.onShiftRightClick != null) {
            this.onShiftRightClick.run(player, entity);
        }
    }

    public boolean enabled() {
        MainConfig.MainCfgFile config = MainConfig.MAIN;
        return (Boolean)config.enabled.get(this.ordinal()).get();
    }

    public static void init() {
        EPet.FOX.blockingItems = new Item[]{Items.field_151058_ca, Items.field_222112_pR};
        EPet.FOX.tameItem = Items.field_151076_bf;
        EPet.RABBIT.blockingItems = new Item[]{Items.field_151058_ca, Items.field_151172_bF, Items.field_151150_bK, Items.field_221619_aU};
        EPet.RABBIT.tameItem = Items.field_151015_O;
        EPet.POLAR_BEAR.blockingItems = new Item[]{Items.field_151058_ca};
        EPet.POLAR_BEAR.tameItem = Items.field_196086_aW;
        EPet.PANDA.blockingItems = new Item[]{Items.field_151058_ca, Items.field_222068_kQ, Items.field_222070_lD};
        EPet.PANDA.tameItem = Items.field_151015_O;
        EPet.OCELOT.blockingItems = new Item[]{Items.field_151058_ca, Items.field_196086_aW, Items.field_196087_aX};
        EPet.OCELOT.tameItem = Items.field_151076_bf;
        EPet.DOLPHIN.blockingItems = new Item[]{Items.field_151058_ca, Items.field_196086_aW, Items.field_196087_aX};
        EPet.DOLPHIN.tameItem = Items.field_196088_aY;
        EPet.PIG.blockingItems = new Item[]{Items.field_151058_ca, Items.field_151174_bG, Items.field_151172_bF, Items.field_185164_cV, Items.field_151141_av, Items.field_151146_bM, Items.field_151150_bK};
        EPet.PIG.tameItem = Items.field_151015_O;
        EPet.SHEEP.blockingItems = new Item[]{Items.field_151058_ca, Items.field_151015_O, Items.field_151097_aZ};
        EPet.SHEEP.tameItem = Items.field_221674_ay;
        EPet.COW.blockingItems = new Item[]{Items.field_151058_ca, Items.field_151015_O, Items.field_151133_ar, Items.field_151054_z, Items.field_151097_aZ};
        EPet.COW.tameItem = Items.field_221674_ay;
        EPet.CHICKEN.blockingItems = new Item[]{Items.field_151058_ca, Items.field_185163_cU, Items.field_151081_bc, Items.field_151080_bb, Items.field_151014_N};
        EPet.CHICKEN.tameItem = Items.field_151015_O;
        EPet.STRIDER.blockingItems = new Item[]{Items.field_151058_ca, Items.field_234723_bx_, Items.field_234774_pk_, Items.field_151141_av};
        EPet.STRIDER.tameItem = Items.field_234722_bw_;
    }

    public boolean vanillaBlockedItems(PlayerEntity player, ItemStack stack, EPet pet, TameableEntity entity) {
        if (entity.func_110166_bE() == player) {
            return true;
        }
        if (pet == PARROT && !entity.func_233570_aj_()) {
            return true;
        }
        Item i = stack.func_77973_b();
        if (stack.func_190926_b()) {
            return false;
        }
        if (i == Items.field_151058_ca) {
            return true;
        }
        switch (pet) {
            case CAT: 
            case WOLF: {
                return i instanceof DyeItem || entity.func_70877_b(stack);
            }
            case PARROT: {
                return i == Items.field_151106_aX;
            }
        }
        return false;
    }
}

