/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.rabbit_tamer.Util.Events;

import com.cobbs.rabbit_tamer.Util.DataStorage.Pet.EPosition;
import com.cobbs.rabbit_tamer.Util.DataStorage.Pet.IPetCapability;
import com.cobbs.rabbit_tamer.Util.DataStorage.Pet.PetCapabilityProvider;
import com.cobbs.rabbit_tamer.Util.EPet;
import com.cobbs.rabbit_tamer.Util.Goals.GoalHolder;
import com.cobbs.rabbit_tamer.Util.Goals.ModDolphinSittingGoal;
import com.cobbs.rabbit_tamer.Util.Goals.ModFollowGoal;
import com.cobbs.rabbit_tamer.Util.Goals.ModNoRunAway;
import com.cobbs.rabbit_tamer.Util.Goals.ModRiderGoal;
import com.cobbs.rabbit_tamer.Util.Goals.ModSittingGoal;
import com.cobbs.rabbit_tamer.Util.Goals.VanillaExtendedFollowGoal;
import com.cobbs.rabbit_tamer.Util.MainConfig;
import com.cobbs.rabbit_tamer.Util.ModHelper;
import com.cobbs.rabbit_tamer.Util.TextHelper;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.BreatheAirGoal;
import net.minecraft.entity.ai.goal.FindWaterGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.AnimalTameEvent;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

@Mod.EventBusSubscriber(modid="rabbit_tamer", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ModEvents {
    private static final ResourceLocation res = new ResourceLocation("rabbit_tamer", "tame_data");

    @SubscribeEvent
    public static void attachCapabilityEvent(AttachCapabilitiesEvent<Entity> event) {
        World world = ((Entity)event.getObject()).field_70170_p;
        if (ModHelper.isServer(world)) {
            for (EPet pet : EPet.values()) {
                if (!pet.matchesAnimal((Entity)event.getObject())) continue;
                event.addCapability(res, (ICapabilityProvider)new PetCapabilityProvider((MobEntity)event.getObject()));
            }
        }
    }

    @SubscribeEvent
    public static void animalAddedToWorld(EntityJoinWorldEvent event) {
        World world = event.getEntity().field_70170_p;
        if (ModHelper.isServer(world)) {
            for (EPet pet : EPet.values()) {
                if (!pet.matchesAnimal(event.getEntity())) continue;
                MobEntity animal = (MobEntity)event.getEntity();
                IPetCapability data = ModHelper.getData(animal);
                if (data.isOwner("")) break;
                ModEvents.removeWildGoals(pet, animal);
                ModEvents.applyPetGoals(pet, animal);
                break;
            }
        }
    }

    @SubscribeEvent
    public static void entityHurt(LivingHurtEvent event) {
        World world = event.getEntity().field_70170_p;
        if (ModHelper.isServer(world)) {
            for (EPet pet : EPet.values()) {
                if (!pet.hasProtection || !pet.matchesAnimal(event.getEntity())) continue;
                MobEntity animal = (MobEntity)event.getEntity();
                IPetCapability data = ModHelper.getData(animal);
                if (data.isOwner("") || event.getSource().field_76373_n.equalsIgnoreCase("outOfWorld")) break;
                Entity e = data.getOwner((ServerWorld)world);
                if (e instanceof PlayerEntity) {
                    if (event.getSource().func_76346_g() == e && !ModHelper.isRidingOrBeingRiddenBy(e, (Entity)animal)) break;
                    event.setAmount(0.0f);
                    event.setCanceled(true);
                    break;
                }
                event.setAmount(0.0f);
                event.setCanceled(true);
                break;
            }
        }
    }

    @SubscribeEvent
    public static void animalBaby(BabyEntitySpawnEvent event) {
        World world;
        PlayerEntity player = event.getCausedByPlayer();
        if (player != null && ModHelper.isServer(world = player.field_70170_p)) {
            for (EPet pet : EPet.values()) {
                IPetCapability data;
                if (!pet.matchesAnimal((Entity)event.getChild())) continue;
                AgeableEntity child = event.getChild();
                String ownerID = "";
                if (pet.matchesAnimal((Entity)event.getParentA())) {
                    data = ModHelper.getData(event.getParentA());
                    ownerID = data.getOwnerID();
                }
                if (ownerID.equals("")) {
                    data = ModHelper.getData(event.getParentB());
                    ownerID = data.getOwnerID();
                }
                if (ownerID.equals("")) break;
                data = ModHelper.getData((MobEntity)child);
                data.setOwner(player);
                ModEvents.removeWildGoals(pet, (MobEntity)child);
                ModEvents.applyPetGoals(pet, (MobEntity)child);
                pet.tame((MobEntity)child);
                pet.changeState((MobEntity)child, pet.extendedVanilla ? EPosition.FOLLOWING : EPosition.STOPPED);
                break;
            }
        }
    }

    @SubscribeEvent
    public static void tameVanillaAnimal(AnimalTameEvent event) {
        for (EPet pet : EPet.values()) {
            if (!pet.extendedVanilla || !pet.enabled() || !pet.matchesAnimal((Entity)event.getAnimal())) continue;
            PlayerEntity p = event.getTamer();
            AnimalEntity animal = event.getAnimal();
            IPetCapability data = ModHelper.getData((MobEntity)animal);
            data.setOwner(p);
            ModEvents.removeWildGoals(pet, (MobEntity)animal);
            ModEvents.applyPetGoals(pet, (MobEntity)animal);
            pet.changeState((MobEntity)animal, EPosition.STOPPED);
            break;
        }
    }

    @SubscribeEvent
    public static void interactWithAnimal(PlayerInteractEvent.EntityInteract event) {
        World world = event.getEntity().field_70170_p;
        if (event.getHand() == Hand.MAIN_HAND && ModHelper.isServer(world)) {
            for (EPet pet : EPet.values()) {
                if (!pet.enabled() || !pet.matchesAnimal(event.getTarget())) continue;
                PlayerEntity p = event.getPlayer();
                MobEntity animal = (MobEntity)event.getTarget();
                IPetCapability data = ModHelper.getData(animal);
                ItemStack stack = p.func_184586_b(Hand.MAIN_HAND);
                if (data.isOwner("")) {
                    if (pet.isTameItem(stack)) {
                        if (!((Boolean)MainConfig.MAIN.multipleItems.get()).booleanValue() || ModHelper.rand.nextInt(4) == 0) {
                            TextHelper.onTameText(p, (LivingEntity)animal);
                            if (!p.func_184812_l_()) {
                                stack.func_190918_g(1);
                            }
                            data.setOwner(p);
                            ModEvents.removeWildGoals(pet, animal);
                            ModEvents.applyPetGoals(pet, animal);
                            pet.tame(animal);
                            pet.changeState(animal, EPosition.STOPPED);
                            event.setCancellationResult(ActionResultType.SUCCESS);
                            event.setCanceled(true);
                            break;
                        }
                        TextHelper.onTameFail(p);
                        if (!p.func_184812_l_()) {
                            stack.func_190918_g(1);
                        }
                        event.setCancellationResult(ActionResultType.SUCCESS);
                        event.setCanceled(true);
                        break;
                    }
                    if (pet.extendedVanilla || pet.isBlockedItem(stack)) break;
                    TextHelper.onAttemptTame(p, pet);
                    break;
                }
                if (!data.isOwner(p) || pet.requiresMount && !p.equals((Object)ModHelper.getRider(animal))) break;
                if (pet.extendedVanilla) {
                    if (pet.vanillaBlockedItems(p, stack, pet, (TameableEntity)animal)) break;
                    EPosition state = ModEvents.nextState(data.getState(), p, animal);
                    data.setState(state);
                    if (!pet.changeState(animal, state)) break;
                    event.setCancellationResult(ActionResultType.SUCCESS);
                    event.setCanceled(true);
                    break;
                }
                if (pet.isBlockedItem(stack)) break;
                if (p.func_225608_bj_()) {
                    if (pet.invertClick) {
                        EPosition state = pet == EPet.DOLPHIN ? ModEvents.nextStateDolphin(data.getState(), p, animal) : ModEvents.nextState(data.getState(), p, animal);
                        data.setState(state);
                        if (!pet.changeState(animal, state)) break;
                        event.setCancellationResult(ActionResultType.SUCCESS);
                        event.setCanceled(true);
                        break;
                    }
                    pet.shiftClick(p, animal);
                    break;
                }
                if (pet.invertClick) {
                    pet.shiftClick(p, animal);
                    break;
                }
                EPosition state = pet == EPet.DOLPHIN ? ModEvents.nextStateDolphin(data.getState(), p, animal) : ModEvents.nextState(data.getState(), p, animal);
                data.setState(state);
                if (!pet.changeState(animal, state)) break;
                event.setCancellationResult(ActionResultType.SUCCESS);
                event.setCanceled(true);
                break;
            }
        }
    }

    public static void removeWildGoals(EPet pet, MobEntity animal) {
        try {
            Set goals = (Set)ObfuscationReflectionHelper.getPrivateValue(GoalSelector.class, (Object)animal.field_70714_bg, (String)"field_220892_d");
            goals.removeIf(g -> pet.goalPredicate.test(g.func_220772_j()));
            if (!pet.extendedVanilla) {
                Set targets = (Set)ObfuscationReflectionHelper.getPrivateValue(GoalSelector.class, (Object)animal.field_70715_bh, (String)"field_220892_d");
                targets.clear();
                animal.func_70624_b(null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void applyPetGoals(EPet pet, MobEntity animal) {
        if (!pet.extendedVanilla) {
            if (pet == EPet.DOLPHIN) {
                animal.field_70714_bg.func_75776_a(0, (Goal)new ModRiderGoal(animal));
                animal.field_70714_bg.func_75776_a(1, (Goal)new BreatheAirGoal((CreatureEntity)animal));
                animal.field_70714_bg.func_75776_a(1, (Goal)new FindWaterGoal((CreatureEntity)animal));
                animal.field_70714_bg.func_75776_a(2, (Goal)new ModDolphinSittingGoal(animal));
                animal.field_70714_bg.func_75776_a(4, (Goal)new RandomSwimmingGoal((CreatureEntity)animal, 1.0, 10));
                animal.field_70714_bg.func_75776_a(4, (Goal)new LookRandomlyGoal(animal));
                animal.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal(animal, PlayerEntity.class, 6.0f));
            } else {
                animal.field_70714_bg.func_75776_a(1, (Goal)new ModSittingGoal(animal));
                animal.field_70714_bg.func_75776_a(2, (Goal)new ModFollowGoal(animal, 2.0, 10.0f, 2.0f, false));
                animal.field_70714_bg.func_75776_a(3, (Goal)new ModNoRunAway(animal, 2.0));
            }
        } else {
            pet.onTame.accept(animal);
        }
        if (pet.customGoals != null) {
            for (Function<MobEntity, GoalHolder> g : pet.customGoals) {
                GoalHolder goal = g.apply(animal);
                animal.field_70714_bg.func_75776_a(goal.priority, goal.goal);
            }
        }
    }

    public static void applyCustomFollow(MobEntity animal, int priority, float speed, float minDist, float maxDist, boolean teleportToLeaves) {
        animal.field_70714_bg.func_75776_a(priority, (Goal)new VanillaExtendedFollowGoal((TameableEntity)animal, speed, minDist, maxDist, teleportToLeaves));
    }

    public static EPosition nextState(EPosition current, PlayerEntity p, MobEntity animal) {
        EPosition pos = EPosition.STOPPED;
        if (animal instanceof TameableEntity && ((TameableEntity)animal).func_233685_eM_()) {
            pos = EPosition.WANDERING;
        } else {
            switch (current) {
                case STOPPED: {
                    pos = EPosition.WANDERING;
                    break;
                }
                case WANDERING: {
                    pos = EPosition.FOLLOWING;
                }
            }
        }
        pos.displayText(p, animal);
        return pos;
    }

    public static EPosition nextStateDolphin(EPosition current, PlayerEntity p, MobEntity animal) {
        EPosition pos = EPosition.STOPPED;
        if (current == EPosition.STOPPED) {
            pos = EPosition.WANDERING;
        }
        pos.displayText(p, animal);
        return pos;
    }
}

