/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.rabbit_tamer.Util.Goals;

import com.cobbs.rabbit_tamer.Util.DataStorage.Pet.EPosition;
import com.cobbs.rabbit_tamer.Util.DataStorage.Pet.IPetCapability;
import com.cobbs.rabbit_tamer.Util.ModHelper;
import java.util.EnumSet;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.server.ServerWorld;

public class ModFollowGoal
extends Goal {
    private final MobEntity self;
    private Entity owner;
    private final IWorldReader world;
    private final double followSpeed;
    private final PathNavigator navigator;
    private int timeToRecalcPath;
    private final float maxDist;
    private final float minDist;
    private float oldWaterCost;
    private final boolean teleportToLeaves;

    public ModFollowGoal(MobEntity self, double speed, float minDist, float maxDist, boolean teleportToLeaves) {
        this.self = self;
        this.world = self.field_70170_p;
        this.followSpeed = speed;
        this.navigator = self.func_70661_as();
        this.minDist = minDist;
        this.maxDist = maxDist;
        this.teleportToLeaves = teleportToLeaves;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!(self.func_70661_as() instanceof GroundPathNavigator) && !(self.func_70661_as() instanceof FlyingPathNavigator)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
        }
    }

    public boolean func_75250_a() {
        IPetCapability data = ModHelper.getData(this.self);
        if (data.getState() != EPosition.FOLLOWING) {
            return false;
        }
        Entity livingentity = data.getOwner((ServerWorld)this.world);
        if (livingentity == null) {
            return false;
        }
        if (livingentity.func_175149_v()) {
            return false;
        }
        if (data.isStopped()) {
            return false;
        }
        if (this.self.func_70068_e(livingentity) < (double)(this.minDist * this.minDist)) {
            return false;
        }
        this.owner = livingentity;
        return true;
    }

    public boolean func_75253_b() {
        IPetCapability data = ModHelper.getData(this.self);
        if (this.navigator.func_75500_f()) {
            return false;
        }
        if (data.getState() != EPosition.FOLLOWING) {
            return false;
        }
        return !(this.self.func_70068_e(this.owner) <= (double)(this.maxDist * this.maxDist));
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.self.func_184643_a(PathNodeType.WATER);
        this.self.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public void func_75251_c() {
        this.owner = null;
        this.navigator.func_75499_g();
        this.self.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
    }

    public void func_75246_d() {
        this.self.func_70671_ap().func_75651_a(this.owner, 10.0f, (float)this.self.func_70646_bf());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            if (!this.self.func_110167_bD() && !this.self.func_184218_aH()) {
                if (this.self.func_70068_e(this.owner) >= 144.0) {
                    this.tryToTeleportNearEntity();
                } else {
                    this.navigator.func_75497_a(this.owner, this.followSpeed);
                }
            }
        }
    }

    private void tryToTeleportNearEntity() {
        BlockPos blockpos = this.owner.func_233580_cy_();
        for (int i = 0; i < 10; ++i) {
            int j = this.getRandomNumber(-3, 3);
            int k = this.getRandomNumber(-1, 1);
            int l = this.getRandomNumber(-3, 3);
            boolean flag = this.tryToTeleportToLocation(blockpos.func_177958_n() + j, blockpos.func_177956_o() + k, blockpos.func_177952_p() + l);
            if (!flag) continue;
            return;
        }
    }

    private boolean tryToTeleportToLocation(int x, int y, int z) {
        if (Math.abs((double)x - this.owner.func_226277_ct_()) < 2.0 && Math.abs((double)z - this.owner.func_226281_cx_()) < 2.0) {
            return false;
        }
        if (!this.isTeleportFriendlyBlock(new BlockPos(x, y, z))) {
            return false;
        }
        this.self.func_70012_b((double)x + 0.5, (double)y, (double)z + 0.5, this.self.field_70177_z, this.self.field_70125_A);
        this.navigator.func_75499_g();
        return true;
    }

    private boolean isTeleportFriendlyBlock(BlockPos pos) {
        PathNodeType pathnodetype = WalkNodeProcessor.func_237231_a_((IBlockReader)this.world, (BlockPos.Mutable)pos.func_239590_i_());
        if (pathnodetype != PathNodeType.WALKABLE) {
            return false;
        }
        BlockState blockstate = this.world.func_180495_p(pos.func_177977_b());
        if (!this.teleportToLeaves && blockstate.func_177230_c() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockpos = pos.func_177973_b((Vector3i)this.self.func_233580_cy_());
        return this.world.func_226665_a__((Entity)this.self, this.self.func_174813_aQ().func_186670_a(blockpos));
    }

    private int getRandomNumber(int min, int max) {
        return this.self.func_70681_au().nextInt(max - min + 1) + min;
    }
}

