/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.animals.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import net.mcreator.animals.AnimalsModElements;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.network.IPacket;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

@AnimalsModElements.ModElement.Tag
public class FlyEntity
extends AnimalsModElements.ModElement {
    public static EntityType entity = null;

    public FlyEntity(AnimalsModElements instance) {
        super(instance, 31);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)new ModelRegisterHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void initElements() {
        entity = (EntityType)EntityType.Builder.func_220322_a(CustomEntity::new, (EntityClassification)EntityClassification.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(CustomEntity::new).func_220321_a(0.2f, 0.2f).func_206830_a("fly").setRegistryName("fly");
        this.elements.entities.add(() -> entity);
        this.elements.items.add(() -> (Item)new SpawnEggItem(entity, -1, -1, new Item.Properties().func_200916_a(ItemGroup.field_78026_f)).setRegistryName("fly_spawn_egg"));
    }

    @SubscribeEvent
    public void addFeatureToBiomes(BiomeLoadingEvent event) {
        event.getSpawns().getSpawner(EntityClassification.AMBIENT).add(new MobSpawnInfo.Spawners(entity, 20, 8, 10));
    }

    @Override
    public void init(FMLCommonSetupEvent event) {
        DeferredWorkQueue.runLater(this::setupAttributes);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)entity, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MobEntity::func_223315_a);
    }

    private void setupAttributes() {
        AttributeModifierMap.MutableAttribute ammma = MobEntity.func_233666_p_();
        ammma = ammma.func_233815_a_(Attributes.field_233821_d_, 0.3);
        ammma = ammma.func_233815_a_(Attributes.field_233818_a_, 5.0);
        ammma = ammma.func_233815_a_(Attributes.field_233826_i_, 0.0);
        ammma = ammma.func_233815_a_(Attributes.field_233823_f_, 0.0);
        ammma = ammma.func_233815_a_(Attributes.field_233822_e_, 0.3);
        GlobalEntityTypeAttributes.put((EntityType)entity, (AttributeModifierMap)ammma.func_233813_a_());
    }

    public static class Modelfly
    extends EntityModel<Entity> {
        private final ModelRenderer bb_main;
        private final ModelRenderer wingleft_r1;
        private final ModelRenderer wingright_r1;

        public Modelfly() {
            this.field_78090_t = 16;
            this.field_78089_u = 16;
            this.bb_main = new ModelRenderer((Model)this);
            this.bb_main.func_78793_a(0.0f, 24.0f, 0.0f);
            this.bb_main.func_78784_a(0, 0).func_228303_a_(-1.0f, -1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
            this.wingleft_r1 = new ModelRenderer((Model)this);
            this.wingleft_r1.func_78793_a(0.0f, 0.0f, 0.0f);
            this.bb_main.func_78792_a(this.wingleft_r1);
            this.setRotationAngle(this.wingleft_r1, -0.1309f, -1.5708f, 0.0f);
            this.wingleft_r1.func_78784_a(0, 2).func_228303_a_(0.0f, -0.97f, -1.0f, 1.0f, 0.0f, 1.0f, 0.0f, false);
            this.wingright_r1 = new ModelRenderer((Model)this);
            this.wingright_r1.func_78793_a(0.0f, 0.0f, 0.0f);
            this.bb_main.func_78792_a(this.wingright_r1);
            this.setRotationAngle(this.wingright_r1, 0.1309f, -1.5708f, 0.0f);
            this.wingright_r1.func_78784_a(2, 0).func_228303_a_(0.0f, -0.85f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, false);
        }

        public void func_225598_a_(MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
            this.bb_main.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
        }

        public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
            modelRenderer.field_78795_f = x;
            modelRenderer.field_78796_g = y;
            modelRenderer.field_78808_h = z;
        }

        public void func_225597_a_(Entity e, float f, float f1, float f2, float f3, float f4) {
            this.wingleft_r1.field_78796_g = MathHelper.func_76134_b((float)(f * 0.6662f)) * f1;
            this.wingright_r1.field_78796_g = MathHelper.func_76134_b((float)(f * 0.6662f + (float)Math.PI)) * f1;
        }
    }

    public static class CustomEntity
    extends CreatureEntity {
        public CustomEntity(FMLPlayMessages.SpawnEntity packet, World world) {
            this((EntityType<CustomEntity>)entity, world);
        }

        public CustomEntity(EntityType<CustomEntity> type, World world) {
            super(type, world);
            this.field_70728_aV = 1;
            this.func_94061_f(false);
            this.field_70765_h = new FlyingMovementController((MobEntity)this, 10, true);
            this.field_70699_by = new FlyingPathNavigator((MobEntity)this, this.field_70170_p);
        }

        public IPacket<?> func_213297_N() {
            return NetworkHooks.getEntitySpawningPacket((Entity)this);
        }

        protected void func_184651_r() {
            super.func_184651_r();
            this.field_70714_bg.func_75776_a(1, (Goal)new RandomWalkingGoal(this, 0.8, 20){

                protected Vector3d func_190864_f() {
                    Random random = this.func_70681_au();
                    double dir_x = this.func_226277_ct_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                    double dir_y = this.func_226278_cu_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                    double dir_z = this.func_226281_cx_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                    return new Vector3d(dir_x, dir_y, dir_z);
                }
            });
            this.field_70714_bg.func_75776_a(2, (Goal)new LookRandomlyGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(3, (Goal)new SwimGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(4, (Goal)new LeapAtTargetGoal((MobEntity)this, 0.5f));
        }

        public CreatureAttribute func_70668_bt() {
            return CreatureAttribute.field_223222_a_;
        }

        public SoundEvent func_184601_bQ(DamageSource ds) {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.hurt"));
        }

        public SoundEvent func_184615_bR() {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.death"));
        }

        public boolean func_225503_b_(float l, float d) {
            return false;
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            if (source == DamageSource.field_76379_h) {
                return false;
            }
            return super.func_70097_a(source, amount);
        }

        protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        }

        public void func_189654_d(boolean ignored) {
            super.func_189654_d(true);
        }

        public void func_70636_d() {
            super.func_70636_d();
            this.func_189654_d(true);
        }
    }

    private static class ModelRegisterHandler {
        private ModelRegisterHandler() {
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public void registerModels(ModelRegistryEvent event) {
            RenderingRegistry.registerEntityRenderingHandler((EntityType)entity, renderManager -> new MobRenderer(renderManager, new Modelfly(), 0.2f){

                public ResourceLocation func_110775_a(Entity entity) {
                    return new ResourceLocation("animals:textures/fly.png");
                }
            });
        }
    }
}

