/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.rabbit_tamer.Util;

import com.cobbs.rabbit_tamer.Util.DataStorage.Pet.EPosition;
import com.cobbs.rabbit_tamer.Util.Events.ModEvents;
import com.cobbs.rabbit_tamer.Util.Goals.GoalHolder;
import com.cobbs.rabbit_tamer.Util.Goals.ModRiderGoal;
import com.cobbs.rabbit_tamer.Util.MainConfig;
import com.cobbs.rabbit_tamer.Util.ModHelper;
import com.cobbs.rabbit_tamer.Util.ObfuscationHelper;
import com.cobbs.rabbit_tamer.Util.ShiftClickHandler;
import com.cobbs.rabbit_tamer.Util.StateHandler;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.OcelotAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.animal.Panda;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.PolarBear;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.Strider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public enum EPet {
    FOX(Fox.class, goal -> goal instanceof NearestAttackableTargetGoal || goal instanceof PanicGoal || goal instanceof AvoidEntityGoal || goal instanceof MeleeAttackGoal, (e, p) -> {
        if (p == EPosition.STOPPED) {
            ((Fox)e).m_28610_(true);
        } else {
            ((Fox)e).m_28610_(false);
        }
        return false;
    }, e -> e.m_6710_(null), (p, e) -> ObfuscationHelper.spitOutItem((Fox)e)),
    RABBIT(Rabbit.class, goal -> goal instanceof AvoidEntityGoal || goal instanceof PanicGoal, null, null, ModHelper::equipRabbitOnPlayer),
    POLAR_BEAR(PolarBear.class, goal -> goal instanceof NearestAttackableTargetGoal || goal instanceof PanicGoal || goal instanceof MeleeAttackGoal, null, e -> ((PolarBear)e).m_21661_(), (p, e) -> ((PolarBear)e).m_29567_(!((PolarBear)e).m_29562_()), false, false, true, false, e -> new GoalHolder(0, new ModRiderGoal((Mob)e))),
    PANDA(Panda.class, goal -> goal instanceof NearestAttackableTargetGoal || goal instanceof PanicGoal || goal instanceof MeleeAttackGoal || goal instanceof AvoidEntityGoal, null, null, (e, p) -> ((Panda)p).m_29222_(true)),
    OCELOT(Ocelot.class, goal -> goal instanceof NearestAttackableTargetGoal || goal instanceof PanicGoal || goal instanceof OcelotAttackGoal || goal instanceof TemptGoal || goal instanceof AvoidEntityGoal, null, e -> ObfuscationHelper.setTrusting((Ocelot)e), null),
    DOLPHIN(Dolphin.class, goal -> true, null, Mob::m_21532_, ModHelper::getOnAnimal, false, true, true, false, new Function[0]),
    WOLF(Wolf.class, goal -> goal instanceof FollowOwnerGoal, ModHelper::vanillaStateChangeHook, e -> ModEvents.applyCustomFollow(e, 6, 1.0f, 10.0f, 2.0f, false), null, true),
    CAT(Cat.class, goal -> goal instanceof FollowOwnerGoal, ModHelper::vanillaStateChangeHook, e -> ModEvents.applyCustomFollow(e, 6, 1.0f, 10.0f, 5.0f, false), null, true),
    PARROT(Parrot.class, goal -> goal instanceof FollowOwnerGoal, ModHelper::vanillaStateChangeHook, e -> ModEvents.applyCustomFollow(e, 2, 1.0f, 5.0f, 1.0f, true), null, true),
    PIG(Pig.class, goal -> goal instanceof PanicGoal, null, null, null, false, true, false, false, new Function[0]),
    SHEEP(Sheep.class, goal -> goal instanceof PanicGoal, null, null, null, false, false, false, false, new Function[0]),
    COW(Cow.class, goal -> goal instanceof PanicGoal, null, null, null, false, false, false, false, new Function[0]),
    CHICKEN(Chicken.class, goal -> goal instanceof PanicGoal, null, null, null, false, false, false, false, new Function[0]),
    STRIDER(Strider.class, goal -> goal instanceof PanicGoal, null, null, null, false, true, false, false, new Function[0]);

    public final Class<? extends LivingEntity> type;
    public Item[] blockingItems;
    public Item tameItem;
    public Predicate<Goal> goalPredicate;
    public StateHandler onChangeState;
    public Consumer<Mob> onTame;
    public ShiftClickHandler onShiftRightClick;
    public boolean extendedVanilla;
    public boolean invertClick;
    public Function<Mob, GoalHolder>[] customGoals;
    public boolean hasProtection;
    public boolean requiresMount;

    private EPet(Class<? extends LivingEntity> type, Predicate<Goal> goalPredicate, StateHandler onChangeState, Consumer<Mob> onTame, ShiftClickHandler onShiftRightClick, boolean extendedVanilla) {
        this(type, goalPredicate, onChangeState, onTame, onShiftRightClick, extendedVanilla, false, !extendedVanilla, false, new Function[0]);
    }

    private EPet(Class<? extends LivingEntity> type, Predicate<Goal> goalPredicate, StateHandler onChangeState, Consumer<Mob> onTame, ShiftClickHandler onShiftRightClick) {
        this(type, goalPredicate, onChangeState, onTame, onShiftRightClick, false, false, true, false, new Function[0]);
    }

    private EPet(Class<? extends LivingEntity> type, Predicate<Goal> goalPredicate, StateHandler onChangeState, Consumer<Mob> onTame, ShiftClickHandler onShiftRightClick, boolean extendedVanilla, boolean invertClick, boolean hasProtection, boolean requiresMount, Function<Mob, GoalHolder> ... customGoals) {
        this.type = type;
        this.goalPredicate = goalPredicate;
        this.onChangeState = onChangeState;
        this.onTame = onTame;
        this.onShiftRightClick = onShiftRightClick;
        this.extendedVanilla = extendedVanilla;
        this.invertClick = invertClick;
        this.hasProtection = hasProtection;
        this.requiresMount = requiresMount;
        this.customGoals = customGoals;
    }

    public boolean matchesAnimal(Entity e) {
        return this.type.isInstance(e);
    }

    public boolean isBlockedItem(Item i) {
        if (this.blockingItems == null) {
            return false;
        }
        for (Item item : this.blockingItems) {
            if (i != item) continue;
            return true;
        }
        return false;
    }

    public boolean isBlockedItem(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        return this.isBlockedItem(stack.m_41720_());
    }

    public boolean isTameItem(Item i) {
        return i == this.tameItem;
    }

    public boolean isTameItem(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        return this.isTameItem(stack.m_41720_());
    }

    public boolean changeState(Mob entity, EPosition state) {
        if (this.onChangeState != null) {
            return this.onChangeState.run(entity, state);
        }
        return false;
    }

    public void tame(Mob entity) {
        if (this.onTame != null) {
            this.onTame.accept(entity);
        }
    }

    public void shiftClick(Player player, Mob entity) {
        if (this.onShiftRightClick != null) {
            this.onShiftRightClick.run(player, entity);
        }
    }

    public boolean enabled() {
        MainConfig.MainCfgFile config = MainConfig.MAIN;
        return (Boolean)config.enabled.get(this.ordinal()).get();
    }

    public static void init() {
        EPet.FOX.blockingItems = new Item[]{Items.f_42655_, Items.f_42780_};
        EPet.FOX.tameItem = Items.f_42581_;
        EPet.RABBIT.blockingItems = new Item[]{Items.f_42655_, Items.f_42619_, Items.f_42677_, Items.f_41939_};
        EPet.RABBIT.tameItem = Items.f_42405_;
        EPet.POLAR_BEAR.blockingItems = new Item[]{Items.f_42655_};
        EPet.POLAR_BEAR.tameItem = Items.f_42526_;
        EPet.PANDA.blockingItems = new Item[]{Items.f_42655_, Items.f_41911_, Items.f_42502_};
        EPet.PANDA.tameItem = Items.f_42405_;
        EPet.OCELOT.blockingItems = new Item[]{Items.f_42655_, Items.f_42526_, Items.f_42527_};
        EPet.OCELOT.tameItem = Items.f_42581_;
        EPet.DOLPHIN.blockingItems = new Item[]{Items.f_42655_, Items.f_42526_, Items.f_42527_};
        EPet.DOLPHIN.tameItem = Items.f_42528_;
        EPet.PIG.blockingItems = new Item[]{Items.f_42655_, Items.f_42620_, Items.f_42619_, Items.f_42732_, Items.f_42450_, Items.f_42684_, Items.f_42677_};
        EPet.PIG.tameItem = Items.f_42405_;
        EPet.SHEEP.blockingItems = new Item[]{Items.f_42655_, Items.f_42405_, Items.f_42574_};
        EPet.SHEEP.tameItem = Items.f_41864_;
        EPet.COW.blockingItems = new Item[]{Items.f_42655_, Items.f_42405_, Items.f_42446_, Items.f_42399_, Items.f_42574_};
        EPet.COW.tameItem = Items.f_41864_;
        EPet.CHICKEN.blockingItems = new Item[]{Items.f_42655_, Items.f_42733_, Items.f_42578_, Items.f_42577_, Items.f_42404_};
        EPet.CHICKEN.tameItem = Items.f_42405_;
        EPet.STRIDER.blockingItems = new Item[]{Items.f_42655_, Items.f_41955_, Items.f_42685_, Items.f_42450_};
        EPet.STRIDER.tameItem = Items.f_41954_;
    }

    public boolean vanillaBlockedItems(Player player, ItemStack stack, EPet pet, TamableAnimal entity) {
        if (entity.m_21524_() == player) {
            return true;
        }
        if (pet == PARROT && !entity.m_20096_()) {
            return true;
        }
        Item i = stack.m_41720_();
        if (stack.m_41619_()) {
            return false;
        }
        if (i == Items.f_42655_) {
            return true;
        }
        switch (pet) {
            case CAT: 
            case WOLF: {
                return i instanceof DyeItem || entity.m_6898_(stack);
            }
            case PARROT: {
                return i == Items.f_42572_;
            }
        }
        return false;
    }
}

