/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.rabbit_tamer.Util.Events;

import com.cobbs.rabbit_tamer.Util.DataStorage.Pet.EPosition;
import com.cobbs.rabbit_tamer.Util.DataStorage.Pet.IPetCapability;
import com.cobbs.rabbit_tamer.Util.DataStorage.Pet.PetCapabilityProvider;
import com.cobbs.rabbit_tamer.Util.EPet;
import com.cobbs.rabbit_tamer.Util.Goals.Aggressive.FoxBiteGoal;
import com.cobbs.rabbit_tamer.Util.Goals.Aggressive.ModOwnerHurtByTargetGoal;
import com.cobbs.rabbit_tamer.Util.Goals.Aggressive.ModOwnerHurtTargetGoal;
import com.cobbs.rabbit_tamer.Util.Goals.GoalHolder;
import com.cobbs.rabbit_tamer.Util.Goals.ModDolphinSittingGoal;
import com.cobbs.rabbit_tamer.Util.Goals.ModFollowGoal;
import com.cobbs.rabbit_tamer.Util.Goals.ModNoRunAway;
import com.cobbs.rabbit_tamer.Util.Goals.ModRiderGoal;
import com.cobbs.rabbit_tamer.Util.Goals.ModSittingGoal;
import com.cobbs.rabbit_tamer.Util.Goals.VanillaExtendedFollowGoal;
import com.cobbs.rabbit_tamer.Util.MainConfig;
import com.cobbs.rabbit_tamer.Util.ModHelper;
import com.cobbs.rabbit_tamer.Util.TextHelper;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.BreathAirGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.AnimalTameEvent;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

@Mod.EventBusSubscriber(modid="rabbit_tamer", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ModEvents {
    private static final ResourceLocation res = new ResourceLocation("rabbit_tamer", "tame_data");

    @SubscribeEvent
    public static void attachCapabilityEvent(AttachCapabilitiesEvent<Entity> event) {
        Level world = ((Entity)event.getObject()).f_19853_;
        if (ModHelper.isServer(world)) {
            for (EPet pet : EPet.values()) {
                if (!pet.matchesAnimal((Entity)event.getObject())) continue;
                event.addCapability(res, (ICapabilityProvider)new PetCapabilityProvider((Mob)event.getObject()));
            }
        }
    }

    @SubscribeEvent
    public static void animalAddedToWorld(EntityJoinWorldEvent event) {
        Level world = event.getWorld();
        if (ModHelper.isServer(world)) {
            System.out.println("Server: " + event.getEntity().getClass().getName());
            for (EPet pet : EPet.values()) {
                if (!pet.matchesAnimal(event.getEntity())) continue;
                Mob animal = (Mob)event.getEntity();
                IPetCapability data = ModHelper.getData(animal);
                if (data.isOwner("")) break;
                ModEvents.removeWildGoals(pet, animal);
                ModEvents.applyPetGoals(pet, animal);
                break;
            }
        }
    }

    @SubscribeEvent
    public static void entityHurt(LivingHurtEvent event) {
        Level world = event.getEntity().f_19853_;
        if (ModHelper.isServer(world) && ((Boolean)MainConfig.MAIN.mobProtection.get()).booleanValue()) {
            for (EPet pet : EPet.values()) {
                if (!pet.hasProtection || !pet.matchesAnimal(event.getEntity())) continue;
                Mob animal = (Mob)event.getEntity();
                IPetCapability data = ModHelper.getData(animal);
                if (data.isOwner("") || event.getSource().f_19326_.equalsIgnoreCase("outOfWorld")) break;
                Entity e = data.getOwner((ServerLevel)world);
                if (e instanceof Player) {
                    if (event.getSource().m_7639_() == e && !ModHelper.isRidingOrBeingRiddenBy(e, (Entity)animal)) break;
                    event.setAmount(0.0f);
                    event.setCanceled(true);
                    break;
                }
                event.setAmount(0.0f);
                event.setCanceled(true);
                break;
            }
        }
    }

    @SubscribeEvent
    public static void animalBaby(BabyEntitySpawnEvent event) {
        Level world;
        Player player = event.getCausedByPlayer();
        if (player != null && ModHelper.isServer(world = player.f_19853_)) {
            for (EPet pet : EPet.values()) {
                IPetCapability data;
                if (!pet.matchesAnimal((Entity)event.getChild())) continue;
                AgeableMob child = event.getChild();
                if (pet == EPet.FOX && ((Boolean)MainConfig.MAIN.vanillaFox.get()).booleanValue()) {
                    IPetCapability data2 = ModHelper.getData((Mob)child);
                    data2.setOwner(player);
                    ModEvents.removeWildGoals(pet, (Mob)child);
                    ModEvents.applyPetGoals(pet, (Mob)child);
                    pet.tame((Mob)child);
                    pet.changeState((Mob)child, EPosition.STOPPED);
                    break;
                }
                String ownerID = "";
                if (pet.matchesAnimal((Entity)event.getParentA())) {
                    data = ModHelper.getData(event.getParentA());
                    ownerID = data.getOwnerID();
                }
                if (ownerID.equals("")) {
                    data = ModHelper.getData(event.getParentB());
                    ownerID = data.getOwnerID();
                }
                if (ownerID.equals("")) break;
                data = ModHelper.getData((Mob)child);
                data.setOwner(player);
                ModEvents.removeWildGoals(pet, (Mob)child);
                ModEvents.applyPetGoals(pet, (Mob)child);
                pet.tame((Mob)child);
                pet.changeState((Mob)child, pet.extendedVanilla ? EPosition.FOLLOWING : EPosition.STOPPED);
                break;
            }
        }
    }

    @SubscribeEvent
    public static void tameVanillaAnimal(AnimalTameEvent event) {
        for (EPet pet : EPet.values()) {
            if (!pet.extendedVanilla || !pet.enabled() || !pet.matchesAnimal((Entity)event.getAnimal())) continue;
            Player p = event.getTamer();
            Animal animal = event.getAnimal();
            IPetCapability data = ModHelper.getData((Mob)animal);
            data.setOwner(p);
            ModEvents.removeWildGoals(pet, (Mob)animal);
            ModEvents.applyPetGoals(pet, (Mob)animal);
            pet.changeState((Mob)animal, EPosition.STOPPED);
            break;
        }
    }

    @SubscribeEvent
    public static void interactWithAnimal(PlayerInteractEvent.EntityInteract event) {
        Level world = event.getEntity().f_19853_;
        if (event.getHand() == InteractionHand.MAIN_HAND && ModHelper.isServer(world)) {
            for (EPet pet : EPet.values()) {
                if (!pet.enabled() || !pet.matchesAnimal(event.getTarget())) continue;
                Player p = event.getPlayer();
                Mob animal = (Mob)event.getTarget();
                IPetCapability data = ModHelper.getData(animal);
                ItemStack stack = p.m_21120_(InteractionHand.MAIN_HAND);
                if (data.isOwner("")) {
                    if (pet == EPet.FOX && ((Boolean)MainConfig.MAIN.vanillaFox.get()).booleanValue()) break;
                    if (pet.isTameItem(stack)) {
                        if (!((Boolean)MainConfig.MAIN.multipleItems.get()).booleanValue() || ModHelper.rand.nextInt(4) == 0) {
                            TextHelper.onTameText(p, (LivingEntity)animal);
                            if (!p.m_7500_()) {
                                stack.m_41774_(1);
                            }
                            data.setOwner(p);
                            ModEvents.removeWildGoals(pet, animal);
                            ModEvents.applyPetGoals(pet, animal);
                            pet.tame(animal);
                            pet.changeState(animal, EPosition.STOPPED);
                            event.setCancellationResult(InteractionResult.SUCCESS);
                            event.setCanceled(true);
                            break;
                        }
                        TextHelper.onTameFail(p);
                        if (!p.m_7500_()) {
                            stack.m_41774_(1);
                        }
                        event.setCancellationResult(InteractionResult.SUCCESS);
                        event.setCanceled(true);
                        break;
                    }
                    if (pet.extendedVanilla || pet.isBlockedItem(stack)) break;
                    TextHelper.onAttemptTame(p, pet);
                    break;
                }
                if (!data.isOwner(p) || pet.requiresMount && !p.equals((Object)ModHelper.getRider(animal))) break;
                if (pet.extendedVanilla) {
                    if (pet.vanillaBlockedItems(p, stack, pet, (TamableAnimal)animal)) break;
                    EPosition state = ModEvents.nextState(data.getState(), p, animal);
                    data.setState(state);
                    if (!pet.changeState(animal, state)) break;
                    event.setCancellationResult(InteractionResult.SUCCESS);
                    event.setCanceled(true);
                    break;
                }
                if (pet.isBlockedItem(stack)) break;
                if (p.m_6047_()) {
                    if (pet.invertClick) {
                        EPosition state = pet == EPet.DOLPHIN ? ModEvents.nextStateDolphin(data.getState(), p, animal) : ModEvents.nextState(data.getState(), p, animal);
                        data.setState(state);
                        if (!pet.changeState(animal, state)) break;
                        event.setCancellationResult(InteractionResult.SUCCESS);
                        event.setCanceled(true);
                        break;
                    }
                    pet.shiftClick(p, animal);
                    break;
                }
                if (pet.invertClick) {
                    pet.shiftClick(p, animal);
                    break;
                }
                EPosition state = pet == EPet.DOLPHIN ? ModEvents.nextStateDolphin(data.getState(), p, animal) : ModEvents.nextState(data.getState(), p, animal);
                data.setState(state);
                if (!pet.changeState(animal, state)) break;
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
                break;
            }
        }
    }

    public static void removeWildGoals(EPet pet, Mob animal) {
        try {
            Set goals = (Set)ObfuscationReflectionHelper.getPrivateValue(GoalSelector.class, (Object)animal.f_21345_, (String)"f_25345_");
            goals.removeIf(g -> pet.goalPredicate.test(g.m_26015_()));
            if (!pet.extendedVanilla) {
                Set targets = (Set)ObfuscationReflectionHelper.getPrivateValue(GoalSelector.class, (Object)animal.f_21346_, (String)"f_25345_");
                targets.clear();
                animal.m_6710_(null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void applyPetGoals(EPet pet, Mob animal) {
        if (!pet.extendedVanilla) {
            if (pet == EPet.DOLPHIN) {
                animal.f_21345_.m_25352_(0, (Goal)new ModRiderGoal(animal));
                animal.f_21345_.m_25352_(1, (Goal)new BreathAirGoal((PathfinderMob)animal));
                animal.f_21345_.m_25352_(1, (Goal)new TryFindWaterGoal((PathfinderMob)animal));
                animal.f_21345_.m_25352_(2, (Goal)new ModDolphinSittingGoal(animal));
                animal.f_21345_.m_25352_(4, (Goal)new RandomSwimmingGoal((PathfinderMob)animal, 1.0, 10));
                animal.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal(animal));
                animal.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal(animal, Player.class, 6.0f));
            } else if (pet == EPet.FOX && ((Boolean)MainConfig.MAIN.aggressiveFox.get()).booleanValue()) {
                animal.f_21345_.m_25352_(1, (Goal)new ModSittingGoal(animal));
                animal.f_21345_.m_25352_(2, (Goal)new ModFollowGoal(animal, 2.0, 10.0f, 2.0f, false));
                animal.f_21345_.m_25352_(3, (Goal)new ModNoRunAway(animal, 2.0));
                animal.f_21345_.m_25352_(1, (Goal)new ModOwnerHurtByTargetGoal(animal));
                animal.f_21345_.m_25352_(2, (Goal)new ModOwnerHurtTargetGoal(animal));
                animal.f_21345_.m_25352_(1, (Goal)new FoxBiteGoal((Fox)animal, 1.2f, true));
            } else {
                animal.f_21345_.m_25352_(1, (Goal)new ModSittingGoal(animal));
                animal.f_21345_.m_25352_(2, (Goal)new ModFollowGoal(animal, 2.0, 10.0f, 2.0f, false));
                animal.f_21345_.m_25352_(3, (Goal)new ModNoRunAway(animal, 2.0));
            }
        } else {
            pet.onTame.accept(animal);
        }
        if (pet.customGoals != null) {
            for (Function<Mob, GoalHolder> g : pet.customGoals) {
                GoalHolder goal = g.apply(animal);
                animal.f_21345_.m_25352_(goal.priority, goal.goal);
            }
        }
    }

    public static void applyCustomFollow(Mob animal, int priority, float speed, float minDist, float maxDist, boolean teleportToLeaves) {
        animal.f_21345_.m_25352_(priority, (Goal)new VanillaExtendedFollowGoal((TamableAnimal)animal, speed, minDist, maxDist, teleportToLeaves));
    }

    public static EPosition nextState(EPosition current, Player p, Mob animal) {
        EPosition pos = EPosition.STOPPED;
        if (animal instanceof TamableAnimal && ((TamableAnimal)animal).m_21825_()) {
            pos = EPosition.WANDERING;
        } else {
            switch (current) {
                case STOPPED: {
                    pos = EPosition.WANDERING;
                    break;
                }
                case WANDERING: {
                    pos = EPosition.FOLLOWING;
                }
            }
        }
        pos.displayText(p, animal);
        return pos;
    }

    public static EPosition nextStateDolphin(EPosition current, Player p, Mob animal) {
        EPosition pos = EPosition.STOPPED;
        if (current == EPosition.STOPPED) {
            pos = EPosition.WANDERING;
        }
        pos.displayText(p, animal);
        return pos;
    }
}

