/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.rabbit_tamer.Util.Goals;

import com.cobbs.rabbit_tamer.Util.DataStorage.Pet.EPosition;
import com.cobbs.rabbit_tamer.Util.DataStorage.Pet.IPetCapability;
import com.cobbs.rabbit_tamer.Util.ModHelper;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class ModFollowGoal
extends Goal {
    private final Mob self;
    private Entity owner;
    private final Level world;
    private final double followSpeed;
    private final PathNavigation navigator;
    private int timeToRecalcPath;
    private final float maxDist;
    private final float minDist;
    private float oldWaterCost;
    private final boolean teleportToLeaves;

    public ModFollowGoal(Mob self, double speed, float minDist, float maxDist, boolean teleportToLeaves) {
        this.self = self;
        this.world = self.f_19853_;
        this.followSpeed = speed;
        this.navigator = self.m_21573_();
        this.minDist = minDist;
        this.maxDist = maxDist;
        this.teleportToLeaves = teleportToLeaves;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!(self.m_21573_() instanceof GroundPathNavigation) && !(self.m_21573_() instanceof FlyingPathNavigation)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
        }
    }

    public boolean m_8036_() {
        IPetCapability data = ModHelper.getData(this.self);
        if (data.getState() != EPosition.FOLLOWING) {
            return false;
        }
        Entity livingentity = data.getOwner((ServerLevel)this.world);
        if (livingentity == null) {
            return false;
        }
        if (livingentity.m_5833_()) {
            return false;
        }
        if (data.isStopped()) {
            return false;
        }
        if (this.self.m_20280_(livingentity) < (double)(this.minDist * this.minDist)) {
            return false;
        }
        this.owner = livingentity;
        return true;
    }

    public boolean m_8045_() {
        IPetCapability data = ModHelper.getData(this.self);
        if (this.navigator.m_26577_()) {
            return false;
        }
        if (data.getState() != EPosition.FOLLOWING) {
            return false;
        }
        return !(this.self.m_20280_(this.owner) <= (double)(this.maxDist * this.maxDist));
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.self.m_21439_(BlockPathTypes.WATER);
        this.self.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.owner = null;
        this.navigator.m_26573_();
        this.self.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    public void m_8037_() {
        this.self.m_21563_().m_24960_(this.owner, 10.0f, (float)this.self.m_21529_());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            if (!this.self.m_21523_() && !this.self.m_20159_()) {
                if (this.self.m_20280_(this.owner) >= 144.0) {
                    this.tryToTeleportNearEntity();
                } else {
                    this.navigator.m_5624_(this.owner, this.followSpeed);
                }
            }
        }
    }

    private void tryToTeleportNearEntity() {
        BlockPos blockpos = this.owner.m_142538_();
        for (int i = 0; i < 10; ++i) {
            int j = this.getRandomNumber(-3, 3);
            int k = this.getRandomNumber(-1, 1);
            int l = this.getRandomNumber(-3, 3);
            boolean flag = this.tryToTeleportToLocation(blockpos.m_123341_() + j, blockpos.m_123342_() + k, blockpos.m_123343_() + l);
            if (!flag) continue;
            return;
        }
    }

    private boolean tryToTeleportToLocation(int x, int y, int z) {
        if (Math.abs((double)x - this.owner.m_20185_()) < 2.0 && Math.abs((double)z - this.owner.m_20189_()) < 2.0) {
            return false;
        }
        if (!this.isTeleportFriendlyBlock(new BlockPos(x, y, z))) {
            return false;
        }
        this.self.m_7678_((double)x + 0.5, (double)y, (double)z + 0.5, this.self.m_146908_(), this.self.m_146909_());
        this.navigator.m_26573_();
        return true;
    }

    private boolean isTeleportFriendlyBlock(BlockPos pos) {
        BlockPathTypes pathnodetype = WalkNodeEvaluator.m_77604_((BlockGetter)this.world, (BlockPos.MutableBlockPos)pos.m_122032_());
        if (pathnodetype != BlockPathTypes.WALKABLE) {
            return false;
        }
        BlockState blockstate = this.world.m_8055_(pos.m_7495_());
        if (!this.teleportToLeaves && blockstate.m_60734_() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockpos = pos.m_141950_((Vec3i)this.self.m_142538_());
        return this.world.m_45756_((Entity)this.self, this.self.m_142469_().m_82338_(blockpos));
    }

    private int getRandomNumber(int min, int max) {
        return this.self.m_21187_().nextInt(max - min + 1) + min;
    }
}

