/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.rabbit_tamer.Util;

import com.cobbs.rabbit_tamer.RabbitTamer;
import com.cobbs.rabbit_tamer.Util.DataStorage.Pet.EPosition;
import com.cobbs.rabbit_tamer.Util.DataStorage.Pet.IPetCapability;
import com.cobbs.rabbit_tamer.Util.DataStorage.Pet.PetCapability;
import java.util.List;
import java.util.Random;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ModHelper {
    public static AABB batBox = AABB.m_165882_((Vec3)new Vec3(0.0, 0.0, 0.0), (double)16.0, (double)16.0, (double)16.0);
    public static Random rand = new Random();

    public static void actionBarMessage(Player player, String text) {
        player.m_5661_((Component)new TranslatableComponent(text), true);
    }

    public static boolean isRidingOrBeingRiddenBy(Entity e, Entity entityIn) {
        for (Entity entity : e.m_20197_()) {
            if (entity.equals((Object)entityIn)) {
                return true;
            }
            if (!ModHelper.isRidingOrBeingRiddenBy(entity, entityIn)) continue;
            return true;
        }
        return false;
    }

    public static IPetCapability getData(Mob animal) {
        return (IPetCapability)animal.getCapability(RabbitTamer.PET_CAPABILITY).orElse((Object)new PetCapability());
    }

    public static boolean isServer(Level world) {
        return world != null && !world.m_5776_();
    }

    public static String concat(Object ... o) {
        StringBuilder b = new StringBuilder();
        for (Object o1 : o) {
            b.append(o1);
        }
        return b.toString();
    }

    public static void getOnAnimal(Player p, Mob animal) {
        if (ModHelper.isRidingOrBeingRiddenBy((Entity)animal, (Entity)p)) {
            p.m_8127_();
            ((ServerPlayer)p).f_8906_.m_141995_((Packet)new ClientboundSetPassengersPacket((Entity)animal));
        } else {
            p.m_8127_();
            p.m_7998_((Entity)animal, true);
            ((ServerPlayer)p).f_8906_.m_141995_((Packet)new ClientboundSetPassengersPacket((Entity)animal));
        }
    }

    public static void equipRabbitOnPlayer(Player p, Mob animal) {
        if (ModHelper.isRidingOrBeingRiddenBy((Entity)p, (Entity)animal)) {
            animal.m_8127_();
            ((ServerPlayer)p).f_8906_.m_141995_((Packet)new ClientboundSetPassengersPacket((Entity)p));
        } else {
            animal.m_8127_();
            animal.m_7998_((Entity)p, true);
            ((ServerPlayer)p).f_8906_.m_141995_((Packet)new ClientboundSetPassengersPacket((Entity)p));
        }
    }

    public static void echoLocate(Player p, Mob animal) {
        Level w = animal.f_19853_;
        if (ModHelper.isServer(w)) {
            List entities = w.m_6249_((Entity)p, batBox.m_82383_(animal.m_20182_()), e -> e instanceof LivingEntity);
            for (Entity e2 : entities) {
                ((LivingEntity)e2).m_7292_(new MobEffectInstance(MobEffects.f_19619_, 100));
            }
            animal.m_5496_(SoundEvents.f_11731_, 1.0f, 1.0f);
        }
    }

    public static Entity getRider(Mob entity) {
        List passenger = entity.m_20197_();
        if (passenger.isEmpty()) {
            return null;
        }
        return (Entity)passenger.get(0);
    }

    public static boolean vanillaStateChangeHook(Mob entity, EPosition state) {
        switch (state) {
            case STOPPED: 
            case WANDERING: {
                return false;
            }
            case FOLLOWING: {
                return true;
            }
        }
        return false;
    }
}

