/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.api.fishing;

import com.teammetallurgy.aquaculture.init.AquaItems;
import com.teammetallurgy.aquaculture.item.HookItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.RegistryObject;

public class Hook {
    public static final HashMap<String, RegistryObject<HookItem>> HOOKS = new HashMap();
    private final String name;
    private final String modID;
    @Nullable
    private final RegistryObject<HookItem> hookItem;
    private final ResourceLocation texture;
    private final ChatFormatting color;
    private final int minCatchable;
    private final int maxCatchable;
    private final Vec3 weight;
    private final double durabilityChance;
    private final int luckModifier;
    private final double doubleCatchChance;
    private final SoundEvent catchSound;
    private final List<TagKey<Fluid>> fluids;

    private Hook(String name, String modID, ChatFormatting color, int minCatchable, int maxCatchable, Vec3 weight, double durabilityChance, int luckModifier, double doubleCatchChance, SoundEvent catchSound, List<TagKey<Fluid>> fluids) {
        this.name = name;
        this.modID = modID;
        this.color = color;
        this.minCatchable = minCatchable;
        this.maxCatchable = maxCatchable;
        this.weight = weight;
        this.durabilityChance = durabilityChance;
        this.fluids = fluids;
        this.luckModifier = luckModifier;
        this.doubleCatchChance = doubleCatchChance;
        this.catchSound = catchSound;
        this.texture = new ResourceLocation(modID, "textures/entity/rod/hook/" + name + "_hook.png");
        if (name != null) {
            this.hookItem = AquaItems.ITEM_DEFERRED.register(name + "_hook", () -> new HookItem(this));
            HOOKS.put(name, this.hookItem);
        } else {
            this.hookItem = null;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getModID() {
        return this.modID;
    }

    @Nonnull
    public Item getItem() {
        RegistryObject<HookItem> hookItem = this.hookItem;
        return hookItem != null ? (Item)hookItem.get() : Items.f_41852_;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public ChatFormatting getColor() {
        return this.color;
    }

    public int getMinCatchable() {
        return this.minCatchable;
    }

    public int getMaxCatchable() {
        return this.maxCatchable;
    }

    public Vec3 getWeight() {
        return this.weight;
    }

    public double getDurabilityChance() {
        return this.durabilityChance;
    }

    public int getLuckModifier() {
        return this.luckModifier;
    }

    public double getDoubleCatchChance() {
        return this.doubleCatchChance;
    }

    public SoundEvent getCatchSound() {
        return this.catchSound;
    }

    public List<TagKey<Fluid>> getFluids() {
        return this.fluids;
    }

    public static class HookBuilder {
        private String name;
        private String modID = "aquaculture";
        private ChatFormatting color = ChatFormatting.WHITE;
        private int minCatchable;
        private int maxCatchable;
        private Vec3 weightModifier;
        private double durabilityChance;
        private int luckModifier;
        private double doubleCatchChance;
        private SoundEvent catchSound;
        private final List<TagKey<Fluid>> fluids = new ArrayList<TagKey<Fluid>>();

        HookBuilder() {
        }

        public HookBuilder(String name) {
            this.name = name;
        }

        public HookBuilder setModID(String modID) {
            this.modID = modID;
            return this;
        }

        public HookBuilder setColor(ChatFormatting color) {
            this.color = color;
            return this;
        }

        public HookBuilder setCatchableWindow(int min, int max) {
            this.minCatchable = min;
            this.maxCatchable = max;
            return this;
        }

        public HookBuilder setWeight(Vec3 weightModifier) {
            this.weightModifier = weightModifier;
            return this;
        }

        public HookBuilder setDurabilityChance(double durabilityChance) {
            this.durabilityChance = durabilityChance;
            return this;
        }

        public HookBuilder setLuckModifier(int luckModifier) {
            this.luckModifier = luckModifier;
            return this;
        }

        public HookBuilder setDoubleCatchChance(double doubleCatchChance) {
            this.doubleCatchChance = doubleCatchChance;
            return this;
        }

        public HookBuilder setCatchSound(SoundEvent catchSound) {
            this.catchSound = catchSound;
            return this;
        }

        public HookBuilder setFluid(TagKey<Fluid> fluid) {
            this.fluids.add(fluid);
            return this;
        }

        public Hook build() {
            if (this.fluids.isEmpty()) {
                this.fluids.add((TagKey<Fluid>)FluidTags.f_13131_);
            }
            return new Hook(this.name, this.modID, this.color, this.minCatchable, this.maxCatchable, this.weightModifier, this.durabilityChance, this.luckModifier, this.doubleCatchChance, this.catchSound, this.fluids);
        }
    }
}

