/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.entity;

import com.teammetallurgy.aquaculture.Aquaculture;
import com.teammetallurgy.aquaculture.api.fishing.Hook;
import com.teammetallurgy.aquaculture.api.fishing.Hooks;
import com.teammetallurgy.aquaculture.init.AquaEntities;
import com.teammetallurgy.aquaculture.init.AquaItems;
import com.teammetallurgy.aquaculture.init.AquaLootTables;
import com.teammetallurgy.aquaculture.init.AquaSounds;
import com.teammetallurgy.aquaculture.item.AquaFishingRodItem;
import com.teammetallurgy.aquaculture.item.HookItem;
import com.teammetallurgy.aquaculture.misc.AquaConfig;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class AquaFishingBobberEntity
extends FishingHook
implements IEntityAdditionalSpawnData {
    private final Random lavaTickRand = new Random();
    private final Hook hook;
    private final ItemStack fishingLine;
    private final ItemStack bobber;
    private final ItemStack fishingRod;
    private final int luck;

    public AquaFishingBobberEntity(PlayMessages.SpawnEntity spawnPacket, Level world) {
        super(world.m_46003_(spawnPacket.getAdditionalData().m_130259_()), world, 0, 0);
        FriendlyByteBuf buf = spawnPacket.getAdditionalData();
        this.luck = buf.readInt();
        String hookName = buf.m_130277_();
        if (hookName.isEmpty() || hookName == null) {
            this.hook = Hooks.EMPTY;
        } else {
            HookItem hookItem = (HookItem)((Object)Hook.HOOKS.get(hookName).get());
            this.hook = hookItem.getHookType();
        }
        this.fishingLine = buf.m_130267_();
        this.bobber = buf.m_130267_();
        this.fishingRod = buf.m_130267_();
    }

    public AquaFishingBobberEntity(Player player, Level world, int luck, int lureSpeed, @Nonnull Hook hook, @Nonnull ItemStack fishingLine, @Nonnull ItemStack bobber, @Nonnull ItemStack rod) {
        super(player, world, luck, lureSpeed);
        this.luck = luck;
        player.f_36083_ = this;
        this.hook = hook;
        this.fishingLine = fishingLine;
        this.bobber = bobber;
        this.fishingRod = rod;
        if (this.hasHook() && hook.getWeight() != null) {
            this.m_20256_(this.m_20184_().m_82559_(hook.getWeight()));
        }
    }

    @Nonnull
    public Hook getHook() {
        return this.hook;
    }

    public boolean hasHook() {
        return this.hook != Hooks.EMPTY;
    }

    @Nonnull
    public ItemStack getBobber() {
        return this.bobber;
    }

    public boolean hasBobber() {
        return !this.getBobber().m_41619_();
    }

    @Nonnull
    public ItemStack getFishingLine() {
        return this.fishingLine;
    }

    @Nonnull
    public EntityType<?> m_6095_() {
        return (EntityType)AquaEntities.BOBBER.get();
    }

    @Nonnull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public int m_37156_(@Nonnull ItemStack stack) {
        boolean isAdminRod = (Boolean)AquaConfig.BASIC_OPTIONS.debugMode.get() != false && stack.m_41720_() == AquaItems.NEPTUNIUM_FISHING_ROD.get();
        Player angler = this.m_37168_();
        if (!this.f_19853_.f_46443_ && angler != null && !this.m_37136_(angler)) {
            Level level;
            int rodDamage = 0;
            ItemFishedEvent event = null;
            if (this.f_37094_ != null && !isAdminRod) {
                this.m_150155_(this.f_37094_);
                CriteriaTriggers.f_10553_.m_40416_((ServerPlayer)angler, stack, (FishingHook)this, Collections.emptyList());
                this.f_19853_.m_7605_((Entity)this, (byte)31);
                rodDamage = this.f_37094_ instanceof ItemEntity ? 3 : 5;
            } else if ((this.f_37089_ > 0 || isAdminRod) && (level = this.f_19853_) instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)level;
                LootContext.Builder builder = new LootContext.Builder(serverWorld).m_78972_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_78972_(LootContextParams.f_81463_, (Object)stack).m_78977_(this.f_19796_).m_78963_((float)this.luck + angler.m_36336_());
                builder.m_78972_(LootContextParams.f_81458_, (Object)angler).m_78972_(LootContextParams.f_81455_, (Object)this);
                List<ItemStack> lootEntries = this.getLoot(builder, serverWorld);
                if (lootEntries.isEmpty()) {
                    ResourceLocation biomeFromRegistry;
                    if (this.f_19853_.m_46472_() == Level.f_46430_) {
                        lootEntries.add(new ItemStack((ItemLike)AquaItems.FISH_BONES.get()));
                    } else if (!this.f_19853_.m_46859_(this.m_142538_()) && this.f_19853_.m_6425_(this.m_142538_()).m_76170_() && (biomeFromRegistry = this.f_19853_.m_5962_().m_175515_(Registry.f_122885_).m_7981_((Object)((Biome)this.f_19853_.m_204166_(this.m_142538_()).m_203334_()))) != null) {
                        Aquaculture.LOG.error("Loot was empty in Biome: " + biomeFromRegistry + ". Please report on Github");
                    }
                }
                if (!lootEntries.isEmpty()) {
                    ItemStackHandler rodHandler;
                    ItemStack bait;
                    List<ItemStack> doubleLoot;
                    event = new ItemFishedEvent(lootEntries, this.f_19861_ ? 2 : 1, (FishingHook)this);
                    MinecraftForge.EVENT_BUS.post((Event)event);
                    if (event.isCanceled()) {
                        this.m_146870_();
                        return event.getRodDamage();
                    }
                    CriteriaTriggers.f_10553_.m_40416_((ServerPlayer)angler, stack, (FishingHook)this, lootEntries);
                    this.spawnLoot(angler, lootEntries);
                    if (this.hasHook() && this.hook.getDoubleCatchChance() > 0.0 && this.f_19796_.nextDouble() <= this.hook.getDoubleCatchChance() && !(doubleLoot = this.getLoot(builder, serverWorld)).isEmpty()) {
                        MinecraftForge.EVENT_BUS.post((Event)new ItemFishedEvent(doubleLoot, 0, (FishingHook)this));
                        this.spawnLoot(angler, doubleLoot);
                        this.m_5496_(SoundEvents.f_11940_, 0.25f, 1.0f + (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.4f);
                    }
                    if (!angler.m_7500_() && !(bait = (rodHandler = AquaFishingRodItem.getHandler(this.fishingRod)).getStackInSlot(1)).m_41619_()) {
                        if (bait.m_41629_(1, this.f_19853_.f_46441_, null)) {
                            bait.m_41774_(1);
                            this.m_5496_(AquaSounds.BOBBER_BAIT_BREAK, 0.7f, 0.2f);
                        }
                        rodHandler.setStackInSlot(1, bait);
                    }
                    rodDamage = 1;
                }
            }
            if (this.f_19861_) {
                rodDamage = 2;
            }
            this.m_146870_();
            return event == null ? rodDamage : event.getRodDamage();
        }
        return 0;
    }

    protected boolean m_37136_(Player player) {
        ItemStack mainHand = player.m_21205_();
        ItemStack offHand = player.m_21206_();
        boolean isMainHandRod = mainHand.m_41720_() instanceof FishingRodItem;
        boolean isOffHandRod = offHand.m_41720_() instanceof FishingRodItem;
        if (!player.m_146910_() && player.m_6084_() && (isMainHandRod || isOffHandRod) && !(this.m_20280_((Entity)player) > 1024.0)) {
            return false;
        }
        this.m_146870_();
        return true;
    }

    private List<ItemStack> getLoot(LootContext.Builder builder, ServerLevel serverWorld) {
        ResourceLocation lootTableLocation = this.isLavaHookInLava(this, this.f_19853_, this.m_142538_()) ? (serverWorld.m_6018_().m_6042_().m_63946_() ? AquaLootTables.NETHER_FISHING : AquaLootTables.LAVA_FISHING) : BuiltInLootTables.f_78720_;
        LootTable lootTable = serverWorld.m_142572_().m_129898_().m_79217_(lootTableLocation);
        return lootTable.m_79129_(builder.m_78975_(LootContextParamSets.f_81414_));
    }

    private void spawnLoot(Player angler, List<ItemStack> lootEntries) {
        for (ItemStack loot : lootEntries) {
            ItemEntity lootEntity = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), loot){

                public boolean m_6051_() {
                    return false;
                }

                public void m_20093_() {
                }

                public boolean m_6673_(@Nonnull DamageSource source) {
                    BlockPos spawnPos = new BlockPos(AquaFishingBobberEntity.this.m_20185_(), AquaFishingBobberEntity.this.m_20186_(), AquaFishingBobberEntity.this.m_20189_());
                    return AquaFishingBobberEntity.this.isLavaHookInLava(AquaFishingBobberEntity.this, this.f_19853_, spawnPos) || super.m_6673_(source);
                }
            };
            double x = angler.m_20185_() - this.m_20185_();
            double y = angler.m_20186_() - this.m_20186_();
            double z = angler.m_20189_() - this.m_20189_();
            lootEntity.m_20334_(x * 0.1, y * 0.1 + Math.sqrt(Math.sqrt(x * x + y * y + z * z)) * 0.08 + (this.hasHook() && this.isLavaHookInLava(this, this.f_19853_, new BlockPos(x, y, z)) ? 0.2 : 0.0), z * 0.1);
            this.f_19853_.m_7967_((Entity)lootEntity);
            angler.f_19853_.m_7967_((Entity)new ExperienceOrb(angler.f_19853_, angler.m_20185_(), angler.m_20186_() + 0.5, angler.m_20189_() + 0.5, this.f_19796_.nextInt(6) + 1));
            if (!loot.m_204117_(ItemTags.f_13156_)) continue;
            angler.m_36222_(Stats.f_12939_, 1);
        }
    }

    public boolean isLavaHookInLava(AquaFishingBobberEntity bobber, Level world, BlockPos pos) {
        return bobber.hasHook() && bobber.hook.getFluids().contains(FluidTags.f_13132_) && world.m_6425_(pos).m_205070_(FluidTags.f_13132_);
    }

    public void m_8119_() {
        if (this.hasHook() && this.hook.getFluids().contains(FluidTags.f_13132_)) {
            if (this.hook.getFluids().contains(FluidTags.f_13131_) && this.f_19853_.m_6425_(this.m_142538_()).m_205070_(FluidTags.f_13131_)) {
                super.m_8119_();
            } else {
                this.lavaFishingTick();
            }
        } else {
            super.m_8119_();
        }
    }

    private void lavaFishingTick() {
        super.m_6075_();
        this.lavaTickRand.setSeed(this.m_142081_().getLeastSignificantBits() ^ this.f_19853_.m_46467_());
        Player angler = this.m_37168_();
        if (angler == null) {
            this.m_146870_();
        } else if (this.f_19853_.f_46443_ || !this.m_37136_(angler)) {
            boolean isMainHandRod;
            if (this.f_19861_) {
                ++this.f_37103_;
                if (this.f_37103_ >= 1200) {
                    this.m_146870_();
                    return;
                }
            } else {
                this.f_37103_ = 0;
            }
            float f = 0.0f;
            BlockPos bobberPos = this.m_142538_();
            FluidState fluidState = this.f_19853_.m_6425_(bobberPos);
            if (fluidState.m_205070_(FluidTags.f_13132_)) {
                f = fluidState.m_76155_((BlockGetter)this.f_19853_, bobberPos);
            }
            boolean bl = isMainHandRod = f > 0.0f;
            if (this.f_37095_ == FishingHook.FishHookState.FLYING) {
                if (this.f_37094_ != null) {
                    this.m_20256_(Vec3.f_82478_);
                    this.f_37095_ = FishingHook.FishHookState.HOOKED_IN_ENTITY;
                    return;
                }
                if (isMainHandRod) {
                    this.m_20256_(this.m_20184_().m_82542_(0.3, 0.2, 0.3));
                    this.f_37095_ = FishingHook.FishHookState.BOBBING;
                    return;
                }
                this.m_37171_();
            } else {
                if (this.f_37095_ == FishingHook.FishHookState.HOOKED_IN_ENTITY) {
                    if (this.f_37094_ != null) {
                        if (!this.f_37094_.m_146910_() && this.f_37094_.f_19853_.m_46472_() == this.f_19853_.m_46472_()) {
                            this.m_6034_(this.f_37094_.m_20185_(), this.f_37094_.m_20227_(0.8), this.f_37094_.m_20189_());
                        } else {
                            this.m_150157_(null);
                            this.f_37095_ = FishingHook.FishHookState.FLYING;
                        }
                    }
                    return;
                }
                if (this.f_37095_ == FishingHook.FishHookState.BOBBING) {
                    Vec3 motion = this.m_20184_();
                    double y = this.m_20186_() + motion.f_82480_ - (double)bobberPos.m_123342_() - (double)f;
                    if (Math.abs(y) < 0.01) {
                        y += Math.signum(y) * 0.1;
                    }
                    this.m_20334_(motion.f_82479_ * 0.9, motion.f_82480_ - y * (double)this.f_19796_.nextFloat() * 0.2, motion.f_82481_ * 0.9);
                    if (this.f_37089_ <= 0 && this.f_37091_ <= 0) {
                        this.f_37093_ = true;
                    } else {
                        boolean bl2 = this.f_37093_ = this.f_37093_ && this.f_37100_ < 10 && this.m_37158_(bobberPos);
                    }
                    if (isMainHandRod) {
                        this.f_37100_ = Math.max(0, this.f_37100_ - 1);
                        if (this.f_37099_) {
                            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.1 * (double)this.lavaTickRand.nextFloat() * (double)this.lavaTickRand.nextFloat(), 0.0));
                        }
                        if (!this.f_19853_.f_46443_) {
                            this.m_37145_(bobberPos);
                        }
                    } else {
                        this.f_37100_ = Math.min(10, this.f_37100_ + 1);
                    }
                }
            }
            if (!fluidState.m_205070_(FluidTags.f_13132_)) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.03, 0.0));
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_37283_();
            if (this.f_37095_ == FishingHook.FishHookState.FLYING && (this.f_19861_ || this.f_19862_)) {
                this.m_20256_(Vec3.f_82478_);
            }
            this.m_20256_(this.m_20184_().m_82490_(0.92));
            this.m_20090_();
        }
    }

    protected void m_37145_(BlockPos pos) {
        ServerLevel serverworld = (ServerLevel)this.f_19853_;
        int delay = 1;
        BlockPos posUp = pos.m_7494_();
        if (this.f_19796_.nextFloat() < 0.25f && this.f_19853_.m_46758_(posUp)) {
            ++delay;
        }
        if (this.f_19796_.nextFloat() < 0.5f && !this.f_19853_.m_45527_(posUp)) {
            --delay;
        }
        if (this.f_37089_ > 0) {
            --this.f_37089_;
            if (this.f_37089_ <= 0) {
                this.f_37090_ = 0;
                this.f_37091_ = 0;
                this.m_20088_().m_135381_(f_37102_, (Object)false);
            }
        } else if (this.f_37091_ > 0) {
            this.f_37091_ -= delay;
            if (this.f_37091_ > 0) {
                this.f_37092_ = (float)((double)this.f_37092_ + this.f_19796_.nextGaussian() * 4.0);
                float angle = this.f_37092_ * ((float)Math.PI / 180);
                float sin = Mth.m_14031_((float)angle);
                float cos = Mth.m_14089_((float)angle);
                double x = this.m_20185_() + (double)(sin * (float)this.f_37091_ * 0.1f);
                double y = (float)Mth.m_14107_((double)this.m_142469_().f_82289_) + 1.0f;
                double z = this.m_20189_() + (double)(cos * (float)this.f_37091_ * 0.1f);
                FluidState fluidState = serverworld.m_6425_(new BlockPos(x, y - 1.0, z));
                float zOffset = sin * 0.04f;
                float xOffset = cos * 0.04f;
                if (fluidState.m_205070_(FluidTags.f_13131_)) {
                    if (this.f_19796_.nextFloat() < 0.15f) {
                        serverworld.m_8767_((ParticleOptions)ParticleTypes.f_123795_, x, y - (double)0.1f, z, 1, (double)sin, 0.1, (double)cos, 0.0);
                    }
                    serverworld.m_8767_((ParticleOptions)ParticleTypes.f_123816_, x, y, z, 0, (double)xOffset, 0.01, (double)(-zOffset), 1.0);
                    serverworld.m_8767_((ParticleOptions)ParticleTypes.f_123816_, x, y, z, 0, (double)(-xOffset), 0.01, (double)zOffset, 1.0);
                }
                if (fluidState.m_205070_(FluidTags.f_13132_)) {
                    if (this.f_19796_.nextFloat() < 0.15f) {
                        serverworld.m_8767_((ParticleOptions)ParticleTypes.f_123756_, x, y - (double)0.1f, z, 1, (double)sin, 0.1, (double)cos, 0.0);
                    }
                    serverworld.m_8767_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0, (double)xOffset, 0.01, (double)(-zOffset), 1.0);
                    serverworld.m_8767_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0, (double)(-xOffset), 0.01, (double)zOffset, 1.0);
                }
                if (this.hasHook() && this.hook.getCatchSound() != null && this.m_37168_() != null) {
                    this.f_19853_.m_5594_(null, this.m_37168_() != null ? this.m_37168_().m_142538_() : this.m_142538_(), this.hook.getCatchSound(), this.m_5720_(), 0.1f, 0.1f);
                }
            } else {
                Vec3 motion = this.m_20184_();
                this.m_20334_(motion.f_82479_, -0.4f * Mth.m_14068_((Random)this.f_19796_, (float)0.6f, (float)1.0f), motion.f_82481_);
                double boundingBox = this.m_142469_().f_82289_ + 0.5;
                if (serverworld.m_6425_(this.m_142538_()).m_205070_(FluidTags.f_13131_)) {
                    this.m_5496_(SoundEvents.f_11940_, 0.25f, 1.0f + (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.4f);
                    serverworld.m_8767_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_(), boundingBox, this.m_20189_(), (int)(1.0f + this.m_20205_() * 20.0f), (double)this.m_20205_(), 0.0, (double)this.m_20205_(), 0.2);
                    serverworld.m_8767_((ParticleOptions)ParticleTypes.f_123816_, this.m_20185_(), boundingBox, this.m_20189_(), (int)(1.0f + this.m_20205_() * 20.0f), (double)this.m_20205_(), 0.0, (double)this.m_20205_(), 0.2);
                }
                if (serverworld.m_6425_(this.m_142538_()).m_205070_(FluidTags.f_13132_)) {
                    this.m_5496_(AquaSounds.BOBBER_LAND_IN_LAVA, 1.0f, 1.0f + (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.4f);
                    serverworld.m_8767_((ParticleOptions)ParticleTypes.f_123756_, this.m_20185_(), boundingBox, this.m_20189_(), (int)(1.0f + this.m_20205_() * 20.0f), (double)this.m_20205_(), 0.0, (double)this.m_20205_(), 0.2);
                }
                this.f_37089_ = this.hasHook() && this.hook.getMaxCatchable() > 0 ? Mth.m_14072_((Random)this.f_19796_, (int)this.hook.getMinCatchable(), (int)this.hook.getMaxCatchable()) : Mth.m_14072_((Random)this.f_19796_, (int)20, (int)40);
                this.m_20088_().m_135381_(f_37102_, (Object)true);
            }
        } else if (this.f_37090_ > 0) {
            this.f_37090_ -= delay;
            float angle = 0.15f;
            if (this.f_37090_ < 20) {
                angle = (float)((double)angle + (double)(20 - this.f_37090_) * 0.05);
            } else if (this.f_37090_ < 40) {
                angle = (float)((double)angle + (double)(40 - this.f_37090_) * 0.02);
            } else if (this.f_37090_ < 60) {
                angle = (float)((double)angle + (double)(60 - this.f_37090_) * 0.01);
            }
            if (this.f_19796_.nextFloat() < angle) {
                double z;
                double y;
                float sin = Mth.m_14068_((Random)this.f_19796_, (float)0.0f, (float)360.0f) * ((float)Math.PI / 180);
                float cos = Mth.m_14068_((Random)this.f_19796_, (float)25.0f, (float)60.0f);
                double x = this.m_20185_() + (double)(Mth.m_14031_((float)sin) * cos * 0.1f);
                FluidState fluidState = serverworld.m_6425_(new BlockPos(x, (y = (double)((float)Mth.m_14107_((double)this.m_20186_()) + 1.0f)) - 1.0, z = this.m_20189_() + (double)(Mth.m_14089_((float)sin) * cos * 0.1f)));
                if (fluidState.m_205070_(FluidTags.f_13131_)) {
                    serverworld.m_8767_((ParticleOptions)ParticleTypes.f_123769_, x, y, z, 2 + this.f_19796_.nextInt(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
                }
            }
            if (this.f_37090_ <= 0) {
                this.f_37092_ = Mth.m_14068_((Random)this.f_19796_, (float)0.0f, (float)360.0f);
                this.f_37091_ = Mth.m_14072_((Random)this.f_19796_, (int)20, (int)80);
            }
        } else {
            this.f_37090_ = Mth.m_14072_((Random)this.f_19796_, (int)100, (int)600);
            this.f_37090_ -= this.f_37097_ * 20 * 5;
        }
    }

    public void m_20093_() {
        if (!this.hasHook() || this.hasHook() && !this.hook.getFluids().contains(FluidTags.f_13132_)) {
            super.m_20093_();
        }
    }

    public boolean m_6051_() {
        return this.hasHook() && !this.hook.getFluids().contains(FluidTags.f_13132_) && super.m_6051_();
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        Player player = this.m_37168_();
        if (player != null) {
            buffer.m_130077_(player.m_142081_());
        }
        buffer.writeInt(this.luck);
        buffer.m_130070_(this.hook.getName() == null ? "" : this.hook.getName());
        buffer.m_130055_(this.fishingLine);
        buffer.m_130055_(this.bobber);
        buffer.m_130055_(this.fishingRod);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
    }
}

