/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.tileentity.ShelfBlockEntity;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ShelfBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    private static final Map<Direction, VoxelShape> EMPTY_SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)2.0, (double)3.0, (double)7.0, (double)14.0, (double)5.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)2.0, (double)3.0, (double)0.0, (double)14.0, (double)5.0, (double)9.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)7.0, (double)3.0, (double)2.0, (double)16.0, (double)5.0, (double)14.0), (Object)Direction.EAST, (Object)Block.m_49796_((double)0.0, (double)3.0, (double)2.0, (double)9.0, (double)5.0, (double)14.0)));
    private static final Map<Direction, VoxelShape> SHELVED_SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)2.0, (double)3.0, (double)7.0, (double)14.0, (double)14.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)2.0, (double)3.0, (double)0.0, (double)14.0, (double)14.0, (double)9.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)7.0, (double)3.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0), (Object)Direction.EAST, (Object)Block.m_49796_((double)0.0, (double)3.0, (double)2.0, (double)9.0, (double)14.0, (double)14.0)));

    public ShelfBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity blockEntity;
        if (!level.m_5776_() && (blockEntity = level.m_7702_(pos)) instanceof ShelfBlockEntity) {
            ShelfBlockEntity shelfBlockEntity = (ShelfBlockEntity)blockEntity;
            return shelfBlockEntity.interact(player);
        }
        return InteractionResult.SUCCESS;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        ShelfBlockEntity shelfBlockEntity;
        BlockEntity blockEntity = getter.m_7702_(pos);
        if (blockEntity instanceof ShelfBlockEntity && !(shelfBlockEntity = (ShelfBlockEntity)blockEntity).getBackpack().m_41619_()) {
            return SHELVED_SHAPES.get(state.m_61143_((Property)f_54117_));
        }
        return EMPTY_SHAPES.get(state.m_61143_((Property)f_54117_));
    }

    public boolean m_7898_(BlockState state, LevelReader reader, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_((Property)f_54117_);
        BlockPos relativePos = pos.m_121945_(facing.m_122424_());
        BlockState relativeState = reader.m_8055_(relativePos);
        return relativeState.m_60783_((BlockGetter)reader, relativePos, facing);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState potentialState = (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_());
        if (this.m_7898_(potentialState, (LevelReader)context.m_43725_(), context.m_8083_())) {
            return potentialState;
        }
        return null;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ShelfBlockEntity) {
            ShelfBlockEntity shelfBlockEntity = (ShelfBlockEntity)blockEntity;
            return AbstractContainerMenu.m_38938_((Container)shelfBlockEntity);
        }
        return 0;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean unknown) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof ShelfBlockEntity) {
                ShelfBlockEntity shelfBlockEntity = (ShelfBlockEntity)blockEntity;
                boolean dropsContents = (Boolean)Config.SERVER.dropContentsFromShelf.get();
                ItemStack stack = dropsContents ? shelfBlockEntity.getBackpack() : shelfBlockEntity.getBackpackWithContents();
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)stack);
                if (dropsContents) {
                    Containers.m_19002_((Level)level, (BlockPos)pos, (Container)shelfBlockEntity);
                }
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, newState, unknown);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ShelfBlockEntity(pos, state);
    }
}

