/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common;

import com.mrcrayfish.backpacked.Backpacked;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.common.UnlockTracker;
import com.mrcrayfish.backpacked.common.tracker.BiomeExploreProgressTracker;
import com.mrcrayfish.backpacked.common.tracker.CraftingProgressTracker;
import com.mrcrayfish.backpacked.item.BackpackItem;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundTakeItemEntityPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="backpacked")
public class CommonEvents {
    @SubscribeEvent
    public static void onPickupItem(EntityItemPickupEvent event) {
        Player player;
        if (((Boolean)Config.SERVER.autoEquipBackpackOnPickup.get()).booleanValue() && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ItemEntity entity = event.getItem();
            ItemStack stack = entity.m_32055_();
            if (!(stack.m_41720_() instanceof BackpackItem)) {
                return;
            }
            if (Backpacked.getBackpackStack((Player)player2).m_41619_()) {
                event.setCanceled(true);
                if (Backpacked.setBackpackStack((Player)player2, stack)) {
                    ((ServerLevel)entity.f_19853_).m_7726_().m_8445_((Entity)entity, (Packet)new ClientboundTakeItemEntityPacket(entity.m_19879_(), player2.m_19879_(), stack.m_41613_()));
                    event.setCanceled(true);
                    event.getItem().m_146870_();
                }
            }
        }
    }

    @SubscribeEvent
    public static void onCraftedItem(PlayerEvent.ItemCraftedEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ItemStack craftedItem = event.getCrafting();
        UnlockTracker.get(event.getEntity()).ifPresent(unlockTracker -> unlockTracker.getProgressTrackerMap().forEach((location, progressTracker) -> {
            if (progressTracker instanceof CraftingProgressTracker && !progressTracker.isComplete()) {
                ((CraftingProgressTracker)progressTracker).processCrafted(craftedItem, player2);
            }
        }));
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.player.f_19853_.m_5776_()) {
            return;
        }
        if (event.player.f_19797_ % 20 != 0) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.player;
        ServerLevel world = player.m_9236_();
        BlockPos playerPosition = player.m_20183_();
        world.m_8891_().m_175515_(ForgeRegistries.BIOMES.getRegistryKey()).m_7854_((Object)((Biome)world.m_204166_(playerPosition).m_203334_())).ifPresent(key -> UnlockTracker.get((Player)player).ifPresent(unlockTracker -> unlockTracker.getProgressTrackerMap().forEach((location, progressTracker) -> {
            if (progressTracker instanceof BiomeExploreProgressTracker && !progressTracker.isComplete()) {
                ((BiomeExploreProgressTracker)progressTracker).explore((ResourceKey<Biome>)key, player);
            }
        })));
    }
}

