/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.network.message;

import com.mrcrayfish.backpacked.common.BackpackModelProperty;
import com.mrcrayfish.backpacked.network.message.IMessage;
import com.mrcrayfish.backpacked.network.play.ClientPlayHandler;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class MessageUpdateBackpack
implements IMessage<MessageUpdateBackpack> {
    private int entityId;
    private ItemStack backpack;

    public MessageUpdateBackpack() {
    }

    public MessageUpdateBackpack(int entityId, ItemStack backpack) {
        this.entityId = entityId;
        this.backpack = backpack;
    }

    @Override
    public void encode(MessageUpdateBackpack message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.entityId);
        buffer.writeItemStack(message.backpack, true);
    }

    @Override
    public MessageUpdateBackpack decode(FriendlyByteBuf buffer) {
        return new MessageUpdateBackpack(buffer.readInt(), buffer.m_130267_());
    }

    @Override
    public void handle(MessageUpdateBackpack message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> ClientPlayHandler.handleUpdateBackpack(message));
        supplier.get().setPacketHandled(true);
    }

    private void writeBackpackStack(FriendlyByteBuf buffer, ItemStack stack) {
        boolean empty = stack.m_41619_();
        buffer.writeBoolean(!empty);
        if (!empty) {
            Item item = stack.m_41720_();
            buffer.m_130130_(Item.m_41393_((Item)item));
            buffer.writeByte(stack.m_41613_());
            CompoundTag realTag = stack.m_41784_();
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("BackpackModel", realTag.m_128461_("BackpackModel"));
            for (BackpackModelProperty property : BackpackModelProperty.values()) {
                String tagName = property.getTagName();
                boolean value = realTag.m_128425_(tagName, 1) ? realTag.m_128471_(tagName) : property.getDefaultValue();
                tag.m_128379_(tagName, value);
            }
            buffer.m_130079_(tag);
        }
    }

    public int getEntityId() {
        return this.entityId;
    }

    public ItemStack getBackpack() {
        return this.backpack;
    }
}

