/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mrcrayfish.backpacked.Backpacked;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.client.ClientHandler;
import com.mrcrayfish.backpacked.client.gui.screen.inventory.BackpackScreen;
import com.mrcrayfish.backpacked.client.model.BackpackModel;
import com.mrcrayfish.backpacked.client.renderer.entity.layers.BackpackLayer;
import com.mrcrayfish.backpacked.common.BackpackModelProperty;
import com.mrcrayfish.backpacked.common.data.PickpocketChallenge;
import com.mrcrayfish.backpacked.integration.Curios;
import com.mrcrayfish.backpacked.inventory.ExtendedPlayerInventory;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageEntityBackpack;
import com.mrcrayfish.backpacked.network.message.MessageOpenBackpack;
import com.mrcrayfish.backpacked.util.PickpocketUtil;
import com.mrcrayfish.backpacked.util.ReflectionHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.ContainerScreenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClientEvents {
    public static final ResourceLocation EMPTY_BACKPACK_SLOT = new ResourceLocation("backpacked", "item/empty_backpack_slot");
    private static CreativeModeTab currentTab = null;

    @SubscribeEvent
    public void onPlayerLogin(ClientPlayerNetworkEvent.LoggingIn event) {
        Backpacked.updateBannedItemsList();
    }

    @SubscribeEvent
    public void onPlayerRenderScreen(ContainerScreenEvent.Render.Background event) {
        CreativeModeInventoryScreen inventory;
        if (Backpacked.isCuriosLoaded()) {
            return;
        }
        AbstractContainerScreen screen = event.getContainerScreen();
        if (screen instanceof InventoryScreen) {
            InventoryScreen inventory2 = (InventoryScreen)screen;
            int left = inventory2.getGuiLeft();
            int top = inventory2.getGuiTop();
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)AbstractContainerScreen.f_97725_);
            Screen.m_93133_((PoseStack)event.getPoseStack(), (int)(left + 76), (int)(top + 43), (float)7.0f, (float)7.0f, (int)18, (int)18, (int)256, (int)256);
        } else if (screen instanceof CreativeModeInventoryScreen && (inventory = (CreativeModeInventoryScreen)screen).m_98628_() == CreativeModeTab.f_40761_.m_40775_()) {
            int left = inventory.getGuiLeft();
            int top = inventory.getGuiTop();
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)AbstractContainerScreen.f_97725_);
            Screen.m_93133_((PoseStack)event.getPoseStack(), (int)(left + 126), (int)(top + 19), (float)7.0f, (float)7.0f, (int)18, (int)18, (int)256, (int)256);
        }
    }

    public static void onTextureStitch(TextureStitchEvent.Pre event) {
        if (event.getAtlas().m_118330_().equals((Object)InventoryMenu.f_39692_)) {
            event.addSprite(EMPTY_BACKPACK_SLOT);
        }
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.Key event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91080_ instanceof BackpackScreen) {
            if (event.getAction() == 1 && event.getKey() == ClientHandler.KEY_BACKPACK.getKey().m_84873_()) {
                minecraft.f_91074_.m_6915_();
            }
        } else if (minecraft.f_91074_ != null && minecraft.f_91080_ == null) {
            LocalPlayer player = minecraft.f_91074_;
            if (ClientHandler.KEY_BACKPACK.m_90857_() && ClientHandler.KEY_BACKPACK.m_90859_() && !Backpacked.getBackpackStack((Player)player).m_41619_()) {
                Network.getPlayChannel().sendToServer((Object)new MessageOpenBackpack());
            }
        }
    }

    @SubscribeEvent
    public void onClientTickEnd(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null) {
            return;
        }
        List players = mc.f_91073_.m_142425_((EntityTypeTest)EntityType.f_20532_, mc.f_91074_.m_20191_().m_82400_(16.0), player -> true);
        for (Player player2 : players) {
            String modelName;
            BackpackModel model;
            ItemStack stack;
            if (Backpacked.isCuriosLoaded() && !Curios.isBackpackVisible(player2) || (stack = Backpacked.getBackpackStack(player2)).m_41619_() || !ClientEvents.canShowBackpackEffects(stack) || (model = BackpackLayer.getModel(modelName = stack.m_41784_().m_128461_("BackpackModel")).get()) == null) continue;
            model.tickForPlayer(PickpocketUtil.getBackpackBox((LivingEntity)player2, 1.0f).m_82399_(), player2);
        }
    }

    public static boolean canShowBackpackEffects(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128425_(BackpackModelProperty.SHOW_EFFECTS.getTagName(), 1)) {
            return tag.m_128471_(BackpackModelProperty.SHOW_EFFECTS.getTagName());
        }
        return true;
    }

    @SubscribeEvent
    public void onRightClick(InputEvent.InteractionKeyMappingTriggered event) {
        if (event.isUseItem() && ((Boolean)Config.SERVER.pickpocketBackpacks.get()).booleanValue()) {
            this.performBackpackRaytrace(event);
        }
    }

    private void performBackpackRaytrace(InputEvent.InteractionKeyMappingTriggered event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null || mc.f_91072_ == null) {
            return;
        }
        double range = (Double)Config.SERVER.pickpocketMaxReachDistance.get();
        ArrayList entities = new ArrayList();
        entities.addAll(mc.f_91073_.m_142425_((EntityTypeTest)EntityType.f_20532_, mc.f_91074_.m_20191_().m_82400_(range), player -> !Backpacked.getBackpackStack(player).m_41619_() && !player.equals((Object)mc.f_91074_) && PickpocketUtil.canPickpocketEntity((LivingEntity)player, (Player)mc.f_91074_)));
        entities.addAll(mc.f_91073_.m_142425_((EntityTypeTest)EntityType.f_20494_, mc.f_91074_.m_20191_().m_82400_((double)mc.f_91072_.m_105286_()), entity -> PickpocketChallenge.get((LivingEntity)entity).map(PickpocketChallenge::isBackpackEquipped).orElse(false) != false && PickpocketUtil.canPickpocketEntity((LivingEntity)entity, (Player)mc.f_91074_, mc.f_91072_.m_105286_())));
        if (entities.isEmpty()) {
            return;
        }
        Vec3 start = mc.f_91074_.m_20299_(1.0f);
        Vec3 end = mc.f_91074_.m_20252_(1.0f).m_82490_((double)mc.f_91072_.m_105286_()).m_82549_(start);
        double closestDistance = Double.MAX_VALUE;
        LivingEntity hitEntity = null;
        for (LivingEntity entity2 : entities) {
            double distance;
            AABB box = PickpocketUtil.getBackpackBox(entity2, 1.0f);
            Optional optionalHitVec = box.m_82371_(start, end);
            if (!optionalHitVec.isPresent() || !((distance = start.m_82554_((Vec3)optionalHitVec.get())) < closestDistance)) continue;
            closestDistance = distance;
            hitEntity = entity2;
        }
        if (hitEntity != null) {
            event.setCanceled(true);
            event.setSwingHand(false);
            if (PickpocketUtil.canSeeBackpack(hitEntity, (Player)mc.f_91074_)) {
                Network.getPlayChannel().sendToServer((Object)new MessageEntityBackpack(hitEntity.m_19879_()));
                event.setSwingHand(true);
            }
        }
    }

    @SubscribeEvent
    public void onRenderWorldLastEvent(RenderLevelLastEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (!mc.m_91290_().m_114377_()) {
            return;
        }
        if (!((Boolean)Config.SERVER.pickpocketBackpacks.get()).booleanValue()) {
            return;
        }
        PoseStack stack = event.getPoseStack();
        stack.m_85836_();
        Vec3 view = mc.f_91063_.m_109153_().m_90583_();
        stack.m_85837_(-view.m_7096_(), -view.m_7098_(), -view.m_7094_());
        MultiBufferSource.BufferSource source = mc.m_91269_().m_110104_();
        for (Player player : mc.f_91073_.m_6907_()) {
            if (Backpacked.getBackpackStack(player).m_41619_() || player.m_7578_()) continue;
            boolean inReach = PickpocketUtil.inReachOfBackpack((LivingEntity)player, (Player)mc.f_91074_, (Double)Config.SERVER.pickpocketMaxReachDistance.get()) && PickpocketUtil.canSeeBackpack((LivingEntity)player, (Player)mc.f_91074_);
            float boxRed = inReach ? 0.0f : 1.0f;
            float boxGreen = inReach ? 1.0f : 1.0f;
            float boxBlue = inReach ? 0.0f : 1.0f;
            VertexConsumer builder = source.m_6299_(RenderType.m_110504_());
            LevelRenderer.m_109646_((PoseStack)stack, (VertexConsumer)builder, (AABB)PickpocketUtil.getBackpackBox((LivingEntity)player, event.getPartialTick()), (float)boxRed, (float)boxGreen, (float)boxBlue, (float)1.0f);
            float bodyRotation = Mth.m_14179_((float)event.getPartialTick(), (float)player.f_20884_, (float)player.f_20883_);
            boolean inRange = PickpocketUtil.inRangeOfBackpack((LivingEntity)player, (Player)mc.f_91074_);
            float lineRed = inRange ? 0.0f : 1.0f;
            float lineGreen = inRange ? 1.0f : 1.0f;
            float lineBlue = inRange ? 0.0f : 1.0f;
            Matrix4f matrix4f = stack.m_85850_().m_85861_();
            Vec3 pos = player.m_20318_(event.getPartialTick());
            Vec3 start = Vec3.m_82498_((float)0.0f, (float)(bodyRotation + 180.0f - ((Double)Config.SERVER.pickpocketMaxRangeAngle.get()).floatValue())).m_82490_(((Double)Config.SERVER.pickpocketMaxReachDistance.get()).doubleValue());
            Vec3 end = Vec3.m_82498_((float)0.0f, (float)(bodyRotation - 180.0f + ((Double)Config.SERVER.pickpocketMaxRangeAngle.get()).floatValue())).m_82490_(((Double)Config.SERVER.pickpocketMaxReachDistance.get()).doubleValue());
            builder.m_85982_(matrix4f, (float)(pos.f_82479_ + start.f_82479_), (float)(pos.f_82480_ + start.f_82480_), (float)(pos.f_82481_ + start.f_82481_)).m_85950_(lineRed, lineGreen, lineBlue, 1.0f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            builder.m_85982_(matrix4f, (float)pos.f_82479_, (float)pos.f_82480_, (float)pos.f_82481_).m_85950_(lineRed, lineGreen, lineBlue, 1.0f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            builder.m_85982_(matrix4f, (float)(pos.f_82479_ + end.f_82479_), (float)(pos.f_82480_ + end.f_82480_), (float)(pos.f_82481_ + end.f_82481_)).m_85950_(lineRed, lineGreen, lineBlue, 1.0f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            builder.m_85982_(matrix4f, (float)pos.f_82479_, (float)pos.f_82480_, (float)pos.f_82481_).m_85950_(lineRed, lineGreen, lineBlue, 1.0f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        }
        source.m_109912_(RenderType.m_110504_());
        stack.m_85849_();
    }

    @SubscribeEvent
    public void onRenderTickStart(TickEvent.RenderTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (Backpacked.isCuriosLoaded()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        Screen screen = mc.f_91080_;
        if (!(screen instanceof CreativeModeInventoryScreen)) {
            currentTab = null;
            return;
        }
        CreativeModeInventoryScreen screen2 = (CreativeModeInventoryScreen)screen;
        CreativeModeTab tab = CreativeModeTab.f_40748_[screen2.m_98628_()];
        if ((currentTab == null || currentTab != tab) && (currentTab = tab) == CreativeModeTab.f_40761_) {
            NonNullList slots = ((CreativeModeInventoryScreen.ItemPickerMenu)screen2.m_6262_()).f_38839_;
            slots.stream().filter(slot -> slot.f_40218_ instanceof ExtendedPlayerInventory && slot.getSlotIndex() == 41).findFirst().ifPresent(slot -> ReflectionHelper.repositionSlot(slot, 127, 20));
        }
    }
}

