/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.client.Keys;
import com.mrcrayfish.backpacked.client.model.backpack.BackpackModel;
import com.mrcrayfish.backpacked.client.renderer.entity.layers.BackpackLayer;
import com.mrcrayfish.backpacked.common.backpack.ModelProperty;
import com.mrcrayfish.backpacked.data.pickpocket.PickpocketChallenge;
import com.mrcrayfish.backpacked.inventory.ExtendedPlayerInventory;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageEntityBackpack;
import com.mrcrayfish.backpacked.network.message.MessageOpenBackpack;
import com.mrcrayfish.backpacked.platform.ClientServices;
import com.mrcrayfish.backpacked.platform.Services;
import com.mrcrayfish.backpacked.util.PickpocketUtil;
import com.mrcrayfish.framework.api.event.ClientConnectionEvents;
import com.mrcrayfish.framework.api.event.IFrameworkEvent;
import com.mrcrayfish.framework.api.event.InputEvents;
import com.mrcrayfish.framework.api.event.ScreenEvents;
import com.mrcrayfish.framework.api.event.TickEvents;
import com.mrcrayfish.framework.event.IClientConnectionEvent;
import com.mrcrayfish.framework.event.IInputEvent;
import com.mrcrayfish.framework.event.IScreenEvent;
import com.mrcrayfish.framework.event.ITickEvent;
import com.mrcrayfish.framework.network.message.IMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2535;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_490;
import net.minecraft.class_5575;
import net.minecraft.class_636;
import net.minecraft.class_746;
import net.minecraft.class_757;

public class ClientEvents {
    public static final class_2960 EMPTY_BACKPACK_SLOT = new class_2960("backpacked", "item/empty_backpack_slot");
    private static boolean initializedSlot = false;

    public static void init() {
        TickEvents.END_CLIENT.register((IFrameworkEvent)((ITickEvent.EndClient)ClientEvents::onClientTickEnd));
        ClientConnectionEvents.LOGGING_IN.register((IFrameworkEvent)((IClientConnectionEvent.LoggingIn)ClientEvents::onPlayerLogin));
        ScreenEvents.AFTER_DRAW_CONTAINER_BACKGROUND.register((IFrameworkEvent)((IScreenEvent.AfterDrawContainerBackground)ClientEvents::onAfterDrawBackground));
        ScreenEvents.AFTER_DRAW_CONTAINER_BACKGROUND.register((IFrameworkEvent)((IScreenEvent.AfterDrawContainerBackground)ClientEvents::repositionSlot));
        ScreenEvents.INIT.register((IFrameworkEvent)((IScreenEvent.Init)ClientEvents::onScreenInit));
        InputEvents.KEY.register((IFrameworkEvent)((IInputEvent.Key)ClientEvents::onKeyInput));
        InputEvents.CLICK.register((IFrameworkEvent)((IInputEvent.Click)ClientEvents::onInteraction));
    }

    private static void onPlayerLogin(class_746 player, class_636 gameMode, class_2535 connection) {
        Config.updateBannedItemsList();
    }

    private static void onAfterDrawBackground(class_465<?> screen, class_4587 poseStack, int mouseX, int mouseY) {
        class_481 inventory;
        if (Services.BACKPACK.isUsingThirdPartySlot()) {
            return;
        }
        if (screen instanceof class_490) {
            class_490 inventory2 = (class_490)screen;
            int left = ClientServices.SCREEN.getScreenLeftPos((class_465<?>)inventory2);
            int top = ClientServices.SCREEN.getScreenTopPos((class_465<?>)inventory2);
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (class_2960)class_465.field_2801);
            class_437.method_25290((class_4587)poseStack, (int)(left + 76), (int)(top + 43), (float)7.0f, (float)7.0f, (int)18, (int)18, (int)256, (int)256);
        } else if (screen instanceof class_481 && (inventory = (class_481)screen).method_2469() == class_1761.field_7918.method_7741()) {
            int left = ClientServices.SCREEN.getScreenLeftPos((class_465<?>)inventory);
            int top = ClientServices.SCREEN.getScreenTopPos((class_465<?>)inventory);
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (class_2960)class_465.field_2801);
            class_437.method_25290((class_4587)poseStack, (int)(left + 126), (int)(top + 19), (float)7.0f, (float)7.0f, (int)18, (int)18, (int)256, (int)256);
        }
    }

    public static void onKeyInput(int key, int scanCode, int action, int modifiers) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 != null && mc.field_1755 == null) {
            class_746 player = mc.field_1724;
            if (Keys.KEY_BACKPACK.method_1434() && Keys.KEY_BACKPACK.method_1436() && !Services.BACKPACK.getBackpackStack((class_1657)player).method_7960()) {
                Network.getPlay().sendToServer((IMessage)new MessageOpenBackpack());
            }
        }
    }

    private static void onClientTickEnd() {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null || mc.field_1724 == null) {
            return;
        }
        List players = mc.field_1687.method_18023((class_5575)class_1299.field_6097, mc.field_1724.method_5829().method_1014(16.0), player -> true);
        for (class_1657 player2 : players) {
            String modelName;
            BackpackModel model;
            class_1799 stack;
            if (Services.BACKPACK.isUsingThirdPartySlot() && !Services.BACKPACK.isBackpackVisible(player2) || (stack = Services.BACKPACK.getBackpackStack(player2)).method_7960() || !ClientEvents.canShowBackpackEffects(stack) || (model = BackpackLayer.getModel(modelName = stack.method_7948().method_10558("BackpackModel")).get()) == null) continue;
            model.tickForPlayer(PickpocketUtil.getBackpackBox((class_1309)player2, 1.0f).method_1005(), player2);
        }
    }

    public static boolean canShowBackpackEffects(class_1799 stack) {
        class_2487 tag = stack.method_7948();
        if (tag.method_10573(ModelProperty.SHOW_EFFECTS.getTagName(), 1)) {
            return tag.method_10577(ModelProperty.SHOW_EFFECTS.getTagName());
        }
        return true;
    }

    private static boolean onInteraction(boolean attack, boolean use, boolean pick, class_1268 hand) {
        if (!use || hand != class_1268.field_5808) {
            return false;
        }
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null || mc.field_1724 == null || mc.field_1761 == null) {
            return false;
        }
        double range = (Double)Config.SERVER.common.pickpocketMaxReachDistance.get();
        ArrayList entities = new ArrayList();
        if (((Boolean)Config.SERVER.common.pickpocketBackpacks.get()).booleanValue()) {
            entities.addAll(mc.field_1687.method_18023((class_5575)class_1299.field_6097, mc.field_1724.method_5829().method_1014(range), player -> !Services.BACKPACK.getBackpackStack((class_1657)player).method_7960() && !player.equals((Object)mc.field_1724) && PickpocketUtil.canPickpocketEntity((class_1309)player, (class_1657)mc.field_1724)));
        }
        entities.addAll(mc.field_1687.method_18023((class_5575)class_1299.field_17713, mc.field_1724.method_5829().method_1014((double)mc.field_1761.method_2904()), entity -> PickpocketChallenge.get((class_1297)entity).map(PickpocketChallenge::isBackpackEquipped).orElse(false) != false && PickpocketUtil.canPickpocketEntity((class_1309)entity, (class_1657)mc.field_1724, mc.field_1761.method_2904())));
        if (entities.isEmpty()) {
            return false;
        }
        class_243 start = mc.field_1724.method_5836(1.0f);
        class_243 end = mc.field_1724.method_5828(1.0f).method_1021((double)mc.field_1761.method_2904()).method_1019(start);
        double closestDistance = Double.MAX_VALUE;
        class_1309 hitEntity = null;
        for (class_1309 entity2 : entities) {
            double distance;
            class_238 box = PickpocketUtil.getBackpackBox(entity2, 1.0f);
            Optional optionalHitVec = box.method_992(start, end);
            if (optionalHitVec.isEmpty() || !((distance = start.method_1022((class_243)optionalHitVec.get())) < closestDistance)) continue;
            closestDistance = distance;
            hitEntity = entity2;
        }
        if (hitEntity != null) {
            if (PickpocketUtil.canSeeBackpack(hitEntity, (class_1657)mc.field_1724)) {
                Network.getPlay().sendToServer((IMessage)new MessageEntityBackpack(hitEntity.method_5628()));
                mc.field_1724.method_6104(hand);
            }
            return true;
        }
        return false;
    }

    private static void onScreenInit(class_437 screen) {
        if (screen instanceof class_481) {
            initializedSlot = false;
        }
    }

    private static void repositionSlot(class_465<?> screen, class_4587 poseStack, int mouseX, int mouseY) {
        if (Services.BACKPACK.isUsingThirdPartySlot()) {
            return;
        }
        if (!(screen instanceof class_481)) {
            initializedSlot = false;
            return;
        }
        class_481 creativeScreen = (class_481)screen;
        if (creativeScreen.method_2469() == class_1761.field_7918.method_7741()) {
            if (!initializedSlot) {
                initializedSlot = true;
                class_2371 slots = ((class_481.class_483)creativeScreen.method_17577()).field_7761;
                class_1735 backpackSlot = slots.stream().filter(slot -> slot.field_7871 instanceof ExtendedPlayerInventory && slot.method_34266() == 41).findFirst().orElse(null);
                if (backpackSlot != null) {
                    int index = slots.indexOf(backpackSlot);
                    class_1735 newSlot = ClientServices.SCREEN.createCreativeSlotWrapper(backpackSlot, index, 127, 20);
                    backpackSlot.field_7874 = index;
                    slots.set(index, newSlot);
                }
            }
        } else {
            initializedSlot = false;
        }
    }
}

