/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.gui.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.backpacked.client.ClientEvents;
import com.mrcrayfish.backpacked.client.gui.screen.widget.CheckBox;
import com.mrcrayfish.backpacked.client.model.backpack.BackpackModel;
import com.mrcrayfish.backpacked.client.renderer.entity.layers.BackpackLayer;
import com.mrcrayfish.backpacked.common.backpack.Backpack;
import com.mrcrayfish.backpacked.common.backpack.BackpackManager;
import com.mrcrayfish.backpacked.common.backpack.ModelProperty;
import com.mrcrayfish.backpacked.common.backpack.impl.StandardBackpack;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageBackpackCosmetics;
import com.mrcrayfish.backpacked.platform.Services;
import com.mrcrayfish.backpacked.util.ScreenUtil;
import com.mrcrayfish.framework.network.message.IMessage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1158;
import net.minecraft.class_1160;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2477;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_630;
import net.minecraft.class_757;
import net.minecraft.class_898;
import org.lwjgl.opengl.GL11;

public class CustomiseBackpackScreen
extends class_437 {
    public static final class_2960 GUI_TEXTURE = new class_2960("backpacked", "textures/gui/customise_backpack.png");
    private static final class_2561 SHOW_EFFECTS_TOOLTIP = class_2561.method_43471((String)"backpacked.button.show_effects.tooltip");
    private static final class_2561 SHOW_WITH_ELYTRA_TOOLTIP = class_2561.method_43471((String)"backpacked.button.show_with_elytra.tooltip");
    private static final class_2561 SHOW_ENCHANTMENT_GLINT = class_2561.method_43471((String)"backpacked.button.show_enchantment_glint.tooltip");
    private static final class_2561 LOCKED = class_2561.method_43471((String)"backpacked.gui.locked").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067});
    private final int windowWidth;
    private final int windowHeight;
    private int windowLeft;
    private int windowTop;
    private float windowRotationX = -35.0f;
    private float windowRotationY = 10.0f;
    private boolean windowGrabbed;
    private boolean scrollGrabbed;
    private int mouseClickedX;
    private int mouseClickedY;
    private class_4185 resetButton;
    private class_4185 saveButton;
    private CheckBox showEnchantmentGlintButton;
    private CheckBox showWithElytraButton;
    private CheckBox showEffectsButton;
    private String displayBackpackModel = null;
    private boolean displayShowEnchantmentGlint;
    private boolean displayShowWithElytra;
    private boolean displayShowEffects;
    private final List<BackpackModelEntry> models;
    private int scroll;
    private int animationTick;

    public CustomiseBackpackScreen(Map<class_2960, class_2561> progressMap) {
        super((class_2561)class_2561.method_43471((String)"backpacked.title.customise_backpack"));
        this.windowWidth = 201;
        this.windowHeight = 166;
        Comparator<BackpackModelEntry> compareUnlock = Comparator.comparing(e -> !e.backpack.isUnlocked((class_1657)class_310.method_1551().field_1724));
        Comparator<BackpackModelEntry> compareLabel = Comparator.comparing(e -> e.label.getString());
        List models = BackpackManager.instance().getRegisteredBackpacks().stream().map(backpack -> new BackpackModelEntry((Backpack)backpack, progressMap)).sorted(compareUnlock.thenComparing(compareLabel)).collect(Collectors.toList());
        this.models = ImmutableList.copyOf(models);
    }

    protected void method_25426() {
        super.method_25426();
        if (this.displayBackpackModel == null) {
            this.displayBackpackModel = this.getBackpackModel();
            this.displayShowWithElytra = this.getLocalBackpackProperty(ModelProperty.SHOW_WITH_ELYTRA);
            this.displayShowEffects = this.getLocalBackpackProperty(ModelProperty.SHOW_EFFECTS);
        }
        this.windowLeft = (this.field_22789 - this.windowWidth) / 2;
        this.windowTop = (this.field_22790 - this.windowHeight) / 2;
        this.resetButton = (class_4185)this.method_37063((class_364)new class_4185(this.windowLeft + 7, this.windowTop + 114, 71, 20, (class_2561)class_2561.method_43471((String)"backpacked.button.reset"), onPress -> {
            this.displayBackpackModel = StandardBackpack.ID.toString();
        }));
        this.saveButton = (class_4185)this.method_37063((class_364)new class_4185(this.windowLeft + 7, this.windowTop + 137, 71, 20, (class_2561)class_2561.method_43471((String)"backpacked.button.save"), onPress -> Network.getPlay().sendToServer((IMessage)new MessageBackpackCosmetics(new class_2960(this.displayBackpackModel), this.displayShowEnchantmentGlint, this.displayShowWithElytra, this.displayShowEffects))));
        this.showEnchantmentGlintButton = (CheckBox)this.method_37063((class_364)new CheckBox(this.windowLeft + 133, this.windowTop + 6, class_5244.field_39003, onPress -> {
            this.displayShowEnchantmentGlint = !this.displayShowEnchantmentGlint;
        }, (button, matrixStack, mouseX, mouseY) -> this.method_25424(matrixStack, SHOW_ENCHANTMENT_GLINT, mouseX, mouseY)));
        this.showWithElytraButton = (CheckBox)this.method_37063((class_364)new CheckBox(this.windowLeft + 160, this.windowTop + 6, class_5244.field_39003, onPress -> {
            this.displayShowWithElytra = !this.displayShowWithElytra;
        }, (button, matrixStack, mouseX, mouseY) -> this.method_25424(matrixStack, SHOW_WITH_ELYTRA_TOOLTIP, mouseX, mouseY)));
        this.showEffectsButton = (CheckBox)this.method_37063((class_364)new CheckBox(this.windowLeft + 186, this.windowTop + 6, class_5244.field_39003, onPress -> {
            this.displayShowEffects = !this.displayShowEffects;
        }, (button, matrixStack, mouseX, mouseY) -> this.method_25424(matrixStack, SHOW_EFFECTS_TOOLTIP, mouseX, mouseY)));
        class_1799 backpack = Services.BACKPACK.getBackpackStack((class_1657)this.field_22787.field_1724);
        if (!backpack.method_7960()) {
            this.showEnchantmentGlintButton.setChecked(BackpackLayer.canShowEnchantmentGlint(backpack));
            this.showWithElytraButton.setChecked(BackpackLayer.canRenderWithElytra(backpack));
            this.showEffectsButton.setChecked(ClientEvents.canShowBackpackEffects(backpack));
        }
        this.updateButtons();
    }

    private void updateButtons() {
        this.resetButton.field_22763 = !this.getBackpackModel().equals(StandardBackpack.ID.toString());
        this.saveButton.field_22763 = this.needsToSave();
    }

    private boolean needsToSave() {
        if (!this.displayBackpackModel.equals(this.getBackpackModel())) {
            return true;
        }
        if (this.getLocalBackpackProperty(ModelProperty.SHOW_EFFECTS) != this.displayShowEffects) {
            return true;
        }
        if (this.getLocalBackpackProperty(ModelProperty.SHOW_GLINT) != this.displayShowEnchantmentGlint) {
            return true;
        }
        return this.getLocalBackpackProperty(ModelProperty.SHOW_WITH_ELYTRA) != this.displayShowWithElytra;
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25393() {
        super.method_25393();
        this.updateButtons();
        ++this.animationTick;
    }

    public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float partialTick) {
        BackpackModelEntry entry;
        int startIndex;
        this.method_25420(matrixStack);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)GUI_TEXTURE);
        this.method_25302(matrixStack, this.windowLeft, this.windowTop, 0, 0, this.windowWidth, this.windowHeight);
        super.method_25394(matrixStack, mouseX, mouseY, partialTick);
        if (this.field_22787.field_1724 != null) {
            GL11.glEnable((int)3089);
            ScreenUtil.scissor(this.windowLeft + 8, this.windowTop + 18, 69, 92);
            this.renderPlayer(this.windowLeft + 42, this.windowTop + this.windowHeight / 2, mouseX, mouseY, (class_1657)this.field_22787.field_1724);
            GL11.glDisable((int)3089);
        }
        this.field_22793.method_30883(matrixStack, this.field_22785, (float)(this.windowLeft + 8), (float)(this.windowTop + 6), 0x404040);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)GUI_TEXTURE);
        boolean canScroll = this.models.size() > 7;
        int scroll = (canScroll ? this.scroll : 0) + (this.scrollGrabbed ? mouseY - this.mouseClickedY : 0);
        scroll = class_3532.method_15340((int)scroll, (int)0, (int)123);
        this.method_25302(matrixStack, this.windowLeft + 181, this.windowTop + 18 + scroll, 201 + (!canScroll ? 12 : 0), 0, 12, 15);
        for (int i = startIndex = (int)((double)Math.max(0, this.models.size() - 7) * class_3532.method_15350((double)(((double)scroll + 15.0) / 123.0), (double)0.0, (double)1.0)); i < this.models.size() && i < startIndex + 7; ++i) {
            this.drawBackpackItem(matrixStack, this.windowLeft + 82, this.windowTop + 17 + (i - startIndex) * 20, mouseX, mouseY, partialTick, this.models.get(i));
        }
        int hoveredIndex = this.getHoveredIndex(mouseX, mouseY);
        if (hoveredIndex != -1 && !(entry = this.models.get(hoveredIndex)).getBackpack().isUnlocked((class_1657)this.field_22787.field_1724)) {
            this.method_25417(matrixStack, entry.getUnlockTooltip(), mouseX, mouseY);
        }
    }

    private void drawBackpackItem(class_4587 matrixStack, int x, int y, int mouseX, int mouseY, float partialTick, BackpackModelEntry entry) {
        boolean unlocked = entry.getBackpack().isUnlocked((class_1657)this.field_22787.field_1724);
        boolean selected = unlocked && entry.getId().equals(this.displayBackpackModel);
        boolean hovered = unlocked && !selected && ScreenUtil.isPointInArea(mouseX, mouseY, x, y, 97, 20);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)GUI_TEXTURE);
        int offset = (unlocked ? 0 : 60) + (selected ? 20 : 0) + (hovered ? 40 : 0);
        this.method_25302(matrixStack, x, y, 0, 166 + offset, 97, 20);
        int color = selected ? 4226832 : (hovered ? 0xFFFF80 : (unlocked ? 6839882 : 5119004));
        this.field_22793.method_30883(matrixStack, entry.getLabel(), (float)(x + 20), (float)(y + 6), color);
        CustomiseBackpackScreen.drawBackpackModel(matrixStack, entry.getModel(), x + 8, y + 4, 20.0f, this.animationTick, partialTick);
    }

    public static void drawBackpackModel(class_4587 matrixStack, BackpackModel model, int x, int y, float scale, int animationTick, float partialTick) {
        matrixStack.method_22903();
        matrixStack.method_22904((double)x, (double)y, 50.0);
        matrixStack.method_22907(class_1160.field_20703.method_23214(-10.0f));
        matrixStack.method_22907(class_1160.field_20705.method_23214(35.0f));
        matrixStack.method_22905(scale, scale, scale);
        class_308.method_24210();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_4597.class_4598 source = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        class_4588 builder = source.getBuffer(model.method_23500(model.getTextureLocation()));
        model.setupAngles(null, animationTick, partialTick);
        model.getStraps().field_3665 = false;
        class_630 bag = model.getBag();
        bag.method_2851(0.0f, 0.0f, 0.0f);
        bag.method_22698(matrixStack, builder, 0xF000F0, class_4608.field_21444);
        source.method_22993();
        matrixStack.method_22909();
    }

    private int getHoveredIndex(int mouseX, int mouseY) {
        int displayIndex;
        int startIndex;
        int actualIndex;
        if (ScreenUtil.isPointInArea(mouseX, mouseY, this.windowLeft + 82, this.windowTop + 17, 97, 140) && (actualIndex = (startIndex = (int)((double)Math.max(0, this.models.size() - 7) * class_3532.method_15350((double)(((double)this.scroll + 15.0) / 123.0), (double)0.0, (double)1.0))) + (displayIndex = (mouseY - this.windowTop - 17) / 20)) >= 0 && actualIndex < this.models.size()) {
            return actualIndex;
        }
        return -1;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (ScreenUtil.isPointInArea((int)mouseX, (int)mouseY, this.windowLeft + 82, this.windowTop + 17, 97, 140)) {
            BackpackModelEntry entry;
            int hoveredIndex;
            if (button == 0 && (hoveredIndex = this.getHoveredIndex((int)mouseX, (int)mouseY)) != -1 && (entry = this.models.get(hoveredIndex)).getBackpack().isUnlocked((class_1657)this.field_22787.field_1724)) {
                this.displayBackpackModel = entry.getId();
                this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
            }
        } else if (ScreenUtil.isPointInArea((int)mouseX, (int)mouseY, this.windowLeft + 8, this.windowTop + 18, 69, 92)) {
            if (!this.windowGrabbed && button == 0) {
                this.windowGrabbed = true;
                this.mouseClickedX = (int)mouseX;
                this.mouseClickedY = (int)mouseY;
                return true;
            }
        } else if (ScreenUtil.isPointInArea((int)mouseX, (int)mouseY, this.windowLeft + 181, this.windowTop + 18 + this.scroll, 12, 15) && !this.scrollGrabbed && button == 0) {
            this.scrollGrabbed = true;
            this.mouseClickedY = (int)mouseY;
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.windowGrabbed && button == 0) {
            this.windowRotationX = (float)((double)this.windowRotationX + (mouseX - (double)this.mouseClickedX));
            this.windowRotationY = (float)((double)this.windowRotationY + (mouseY - (double)this.mouseClickedY));
            this.windowGrabbed = false;
        }
        if (this.scrollGrabbed && button == 0) {
            this.scroll = (int)((double)this.scroll + (mouseY - (double)this.mouseClickedY));
            this.scroll = class_3532.method_15340((int)this.scroll, (int)0, (int)123);
            this.scrollGrabbed = false;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double scroll) {
        if (ScreenUtil.isPointInArea((int)mouseX, (int)mouseY, this.windowLeft + 82, this.windowTop + 17, 112, 140)) {
            int startIndex = (int)((double)Math.max(0, this.models.size() - 7) * class_3532.method_15350((double)(((double)this.scroll + 15.0) / 123.0), (double)0.0, (double)1.0));
            int newIndex = startIndex - (int)Math.signum(scroll);
            this.scrollToIndex(newIndex);
        }
        return super.method_25401(mouseX, mouseY, scroll);
    }

    private void scrollToIndex(int index) {
        this.scroll = (int)(123.0 * ((double)index / (double)Math.max(this.models.size() - 7, 1)));
        this.scroll = class_3532.method_15340((int)this.scroll, (int)0, (int)123);
    }

    private String getBackpackModel() {
        String model;
        class_2487 tag;
        class_1799 stack = Services.BACKPACK.getBackpackStack((class_1657)this.field_22787.field_1724);
        if (!stack.method_7960() && (tag = stack.method_7948()).method_10573("BackpackModel", 8) && !(model = tag.method_10558("BackpackModel")).isEmpty()) {
            return model;
        }
        return StandardBackpack.ID.toString();
    }

    private void setLocalBackpackModel(String model) {
        class_1799 stack = Services.BACKPACK.getBackpackStack((class_1657)this.field_22787.field_1724);
        if (!stack.method_7960()) {
            stack.method_7948().method_10582("BackpackModel", model);
        }
    }

    private boolean getLocalBackpackProperty(ModelProperty property) {
        class_2487 tag;
        class_1799 stack = Services.BACKPACK.getBackpackStack((class_1657)this.field_22787.field_1724);
        if (!stack.method_7960() && (tag = stack.method_7948()).method_10573(property.getTagName(), 1)) {
            return tag.method_10577(property.getTagName());
        }
        return property.getDefaultValue();
    }

    private void setLocalBackpackProperty(ModelProperty property, boolean value) {
        class_1799 stack = Services.BACKPACK.getBackpackStack((class_1657)this.field_22787.field_1724);
        if (!stack.method_7960()) {
            stack.method_7948().method_10556(property.getTagName(), value);
        }
    }

    private void renderPlayer(int x, int y, int mouseX, int mouseY, class_1657 player) {
        float scale = 70.0f;
        class_4587 modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.method_22903();
        modelViewStack.method_22904((double)x, (double)y, 1050.0);
        modelViewStack.method_22905(1.0f, 1.0f, -1.0f);
        RenderSystem.applyModelViewMatrix();
        class_4587 matrixStack = new class_4587();
        matrixStack.method_22904(0.0, 0.0, 1000.0);
        matrixStack.method_22904(0.0, -15.0, 0.0);
        class_1158 playerRotation = class_1160.field_20707.method_23214(180.0f);
        class_1158 cameraRotation = new class_1158(0.0f, 0.0f, 0.0f, true);
        cameraRotation.method_4925(class_1160.field_20702.method_23214(this.windowRotationY + (float)(this.windowGrabbed ? mouseY - this.mouseClickedY : 0)));
        cameraRotation.method_4925(class_1160.field_20705.method_23214(this.windowRotationX + (float)(this.windowGrabbed ? mouseX - this.mouseClickedX : 0)));
        playerRotation.method_4925(cameraRotation);
        matrixStack.method_22907(playerRotation);
        matrixStack.method_22904(0.0, (double)(-this.windowHeight / 2), 0.0);
        matrixStack.method_22905(scale, scale, scale);
        float origBodyRot = player.field_6283;
        float origYaw = player.method_36454();
        float origPitch = player.method_36455();
        float origHeadYawOld = player.field_6259;
        float origHeadYaw = player.field_6241;
        String origBackpackModel = this.getBackpackModel();
        boolean origShowEnchantmentGlint = this.getLocalBackpackProperty(ModelProperty.SHOW_GLINT);
        boolean origShowWithElytra = this.getLocalBackpackProperty(ModelProperty.SHOW_WITH_ELYTRA);
        boolean origShowEffects = this.getLocalBackpackProperty(ModelProperty.SHOW_EFFECTS);
        player.field_6283 = 0.0f;
        player.field_6220 = 0.0f;
        player.method_36456(0.0f);
        player.field_5982 = 0.0f;
        player.method_36457(15.0f);
        player.field_6004 = 15.0f;
        player.field_6241 = player.method_36454();
        player.field_6259 = player.method_36454();
        this.setLocalBackpackModel(this.displayBackpackModel);
        this.setLocalBackpackProperty(ModelProperty.SHOW_GLINT, this.displayShowEnchantmentGlint);
        this.setLocalBackpackProperty(ModelProperty.SHOW_WITH_ELYTRA, this.displayShowWithElytra);
        this.setLocalBackpackProperty(ModelProperty.SHOW_EFFECTS, this.displayShowEffects);
        class_898 manager = class_310.method_1551().method_1561();
        cameraRotation.method_4926();
        manager.method_3948(false);
        class_4597.class_4598 source = class_310.method_1551().method_22940().method_23000();
        RenderSystem.runAsFancy(() -> manager.method_3954((class_1297)player, 0.0, 0.0625, 0.35, 0.0f, 1.0f, matrixStack, (class_4597)source, 0xF000F0));
        source.method_22993();
        manager.method_3948(true);
        player.field_6283 = origBodyRot;
        player.method_36456(origYaw);
        player.method_36457(origPitch);
        player.field_6259 = origHeadYawOld;
        player.field_6241 = origHeadYaw;
        this.setLocalBackpackModel(origBackpackModel);
        this.setLocalBackpackProperty(ModelProperty.SHOW_GLINT, origShowEnchantmentGlint);
        this.setLocalBackpackProperty(ModelProperty.SHOW_WITH_ELYTRA, origShowWithElytra);
        this.setLocalBackpackProperty(ModelProperty.SHOW_EFFECTS, origShowEffects);
        modelViewStack.method_22909();
        RenderSystem.applyModelViewMatrix();
        class_308.method_24211();
    }

    private static class BackpackModelEntry {
        private final String id;
        private final Backpack backpack;
        private final class_2561 label;
        private final List<class_5481> unlockTooltip;
        private final BackpackModel model;

        public BackpackModelEntry(Backpack backpack, Map<class_2960, class_2561> progressMap) {
            this.id = backpack.getId().toString();
            this.backpack = backpack;
            this.label = class_2561.method_43471((String)(backpack.getId().method_12836() + ".backpack." + backpack.getId().method_12832()));
            class_5250 unlockMessage = class_2561.method_43471((String)(backpack.getId().method_12836() + ".backpack." + backpack.getId().method_12832() + ".unlock"));
            ArrayList<class_5481> list = new ArrayList<class_5481>(class_310.method_1551().field_1772.method_1728((class_5348)unlockMessage, 150));
            list.add(0, class_2477.method_10517().method_30934((class_5348)LOCKED));
            if (progressMap.containsKey(backpack.getId())) {
                class_5250 component = progressMap.get(backpack.getId()).method_27662().method_27692(class_124.field_1054);
                list.add(class_2477.method_10517().method_30934((class_5348)component));
            }
            this.unlockTooltip = ImmutableList.copyOf(list);
            this.model = (BackpackModel)((Object)backpack.getModelSupplier().get());
        }

        public String getId() {
            return this.id;
        }

        public class_2561 getLabel() {
            return this.label;
        }

        public List<class_5481> getUnlockTooltip() {
            return this.unlockTooltip;
        }

        public Backpack getBackpack() {
            return this.backpack;
        }

        public BackpackModel getModel() {
            return this.model;
        }
    }
}

