/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common;

import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.data.tracker.UnlockManager;
import com.mrcrayfish.backpacked.data.tracker.impl.BiomeExploreProgressTracker;
import com.mrcrayfish.backpacked.data.tracker.impl.CraftingProgressTracker;
import com.mrcrayfish.backpacked.item.BackpackItem;
import com.mrcrayfish.backpacked.platform.Services;
import com.mrcrayfish.framework.api.event.IFrameworkEvent;
import com.mrcrayfish.framework.api.event.PlayerEvents;
import com.mrcrayfish.framework.api.event.TickEvents;
import com.mrcrayfish.framework.event.IPlayerEvent;
import com.mrcrayfish.framework.event.ITickEvent;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2596;
import net.minecraft.class_2775;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;

public class BackpackEvents {
    public static void init() {
        TickEvents.END_PLAYER.register((IFrameworkEvent)((ITickEvent.EndPlayer)BackpackEvents::onPlayerTick));
        PlayerEvents.PICKUP_ITEM.register((IFrameworkEvent)((IPlayerEvent.PickupItem)BackpackEvents::onPickupItem));
        PlayerEvents.CRAFT_ITEM.register((IFrameworkEvent)((IPlayerEvent.CraftItem)BackpackEvents::onCraftedItem));
    }

    private static boolean onPickupItem(class_1657 player, class_1542 entity) {
        if (((Boolean)Config.SERVER.common.autoEquipBackpackOnPickup.get()).booleanValue() && player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            class_1799 stack = entity.method_6983();
            if (!(stack.method_7909() instanceof BackpackItem)) {
                return false;
            }
            if (Services.BACKPACK.getBackpackStack((class_1657)serverPlayer).method_7960()) {
                if (Services.BACKPACK.setBackpackStack((class_1657)serverPlayer, stack)) {
                    ((class_3218)entity.field_6002).method_14178().method_18754((class_1297)entity, (class_2596)new class_2775(entity.method_5628(), serverPlayer.method_5628(), stack.method_7947()));
                    entity.method_31472();
                }
                return true;
            }
        }
        return false;
    }

    private static void onCraftedItem(class_1657 player, class_1799 stack, class_1263 inventory) {
        if (!(player instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)player;
        UnlockManager.get(player).ifPresent(unlockTracker -> unlockTracker.getProgressTrackerMap().forEach((location, progressTracker) -> {
            if (progressTracker instanceof CraftingProgressTracker && !progressTracker.isComplete()) {
                ((CraftingProgressTracker)progressTracker).processCrafted(stack, serverPlayer);
            }
        }));
    }

    private static void onPlayerTick(class_1657 player) {
        if (player.field_6002.method_8608()) {
            return;
        }
        if (player.field_6012 % 20 != 0) {
            return;
        }
        class_3222 serverPlayer = (class_3222)player;
        class_3218 world = serverPlayer.method_14220();
        class_2338 playerPosition = serverPlayer.method_24515();
        world.method_30349().method_30530(class_2378.field_25114).method_29113((Object)((class_1959)world.method_23753(playerPosition).comp_349())).ifPresent(key -> UnlockManager.get((class_1657)serverPlayer).ifPresent(unlockTracker -> unlockTracker.getProgressTrackerMap().forEach((location, progressTracker) -> {
            if (progressTracker instanceof BiomeExploreProgressTracker && !progressTracker.isComplete()) {
                ((BiomeExploreProgressTracker)progressTracker).explore((class_5321<class_1959>)key, serverPlayer);
            }
        })));
    }
}

