/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.backpack.impl;

import com.mrcrayfish.backpacked.client.model.ModelInstances;
import com.mrcrayfish.backpacked.common.backpack.Backpack;
import com.mrcrayfish.backpacked.data.tracker.IProgressTracker;
import com.mrcrayfish.backpacked.data.tracker.ProgressFormatters;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_1440;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class BambooBasketBackpack
extends Backpack {
    public static final class_2960 ID = new class_2960("backpacked", "bamboo_basket");

    public BambooBasketBackpack() {
        super(ID);
    }

    @Override
    public Supplier<Object> getModelSupplier() {
        return ModelInstances.get()::getBambooBasketModel;
    }

    @Override
    @Nullable
    public IProgressTracker createProgressTracker() {
        return new ProgressTracker();
    }

    public static class ProgressTracker
    implements IProgressTracker {
        private static final int COUNT = 10;
        private final Set<UUID> fedPandas = new HashSet<UUID>();

        public void addPanda(class_1440 panda, class_3222 player) {
            this.fedPandas.add(panda.method_5667());
            this.markForCompletionTest(player);
        }

        @Override
        public boolean isComplete() {
            return this.fedPandas.size() >= 10;
        }

        @Override
        public void read(class_2487 tag) {
            this.fedPandas.clear();
            class_2499 list = tag.method_10554("FedPandas", 10);
            list.forEach(t -> {
                class_2487 uuidTag = (class_2487)t;
                long mostBits = uuidTag.method_10537("Most");
                long leastBits = uuidTag.method_10537("Least");
                this.fedPandas.add(new UUID(mostBits, leastBits));
            });
        }

        @Override
        public void write(class_2487 tag) {
            class_2499 list = new class_2499();
            this.fedPandas.forEach(uuid -> {
                class_2487 uuidTag = new class_2487();
                uuidTag.method_10544("Most", uuid.getMostSignificantBits());
                uuidTag.method_10544("Least", uuid.getLeastSignificantBits());
                list.add((Object)uuidTag);
            });
            tag.method_10566("FedPandas", (class_2520)list);
        }

        @Override
        public class_2561 getDisplayComponent() {
            return ProgressFormatters.FED_X_OF_X.apply(this.fedPandas.size(), 10);
        }
    }
}

