/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.backpack.impl;

import com.mrcrayfish.backpacked.client.model.ModelInstances;
import com.mrcrayfish.backpacked.common.backpack.Backpack;
import com.mrcrayfish.backpacked.data.tracker.IProgressTracker;
import com.mrcrayfish.backpacked.data.tracker.ProgressFormatters;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3989;

public class WanderingBagBackpack
extends Backpack {
    public static final class_2960 ID = new class_2960("backpacked", "wandering_bag");

    public WanderingBagBackpack() {
        super(ID);
    }

    @Override
    public Supplier<Object> getModelSupplier() {
        return ModelInstances.get()::getWanderingBag;
    }

    @Override
    @Nullable
    public IProgressTracker createProgressTracker() {
        return new PickpocketProgressTracker();
    }

    public static class PickpocketProgressTracker
    implements IProgressTracker {
        private static final int COUNT = 2;
        private final Set<UUID> traders = new HashSet<UUID>();

        public void addTrader(class_3989 trader, class_3222 player) {
            this.traders.add(trader.method_5667());
            this.markForCompletionTest(player);
        }

        @Override
        public boolean isComplete() {
            return this.traders.size() >= 2;
        }

        @Override
        public void read(class_2487 tag) {
            this.traders.clear();
            class_2499 list = tag.method_10554("PickpocketTraders", 10);
            list.forEach(t -> {
                class_2487 uuidTag = (class_2487)t;
                long mostBits = uuidTag.method_10537("Most");
                long leastBits = uuidTag.method_10537("Least");
                this.traders.add(new UUID(mostBits, leastBits));
            });
        }

        @Override
        public void write(class_2487 tag) {
            class_2499 list = new class_2499();
            this.traders.forEach(uuid -> {
                class_2487 uuidTag = new class_2487();
                uuidTag.method_10544("Most", uuid.getMostSignificantBits());
                uuidTag.method_10544("Least", uuid.getLeastSignificantBits());
                list.add((Object)uuidTag);
            });
            tag.method_10566("PickpocketTraders", (class_2520)list);
        }

        @Override
        public class_2561 getDisplayComponent() {
            return ProgressFormatters.PICKPOCKETED_X_OF_X.apply(this.traders.size(), 2);
        }
    }
}

