/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.platform;

import com.mrcrayfish.backpacked.Backpacked;
import com.mrcrayfish.backpacked.blockentity.ShelfBlockEntity;
import com.mrcrayfish.backpacked.data.pickpocket.PickpocketChallenge;
import com.mrcrayfish.backpacked.data.tracker.UnlockTracker;
import com.mrcrayfish.backpacked.entity.IPickpocketChallengeHolder;
import com.mrcrayfish.backpacked.entity.IUnlockTrackerHolder;
import com.mrcrayfish.backpacked.integration.Trinkets;
import com.mrcrayfish.backpacked.inventory.ExtendedPlayerInventory;
import com.mrcrayfish.backpacked.inventory.container.BackpackContainerMenu;
import com.mrcrayfish.backpacked.item.BackpackItem;
import com.mrcrayfish.backpacked.item.FabricBackpackItem;
import com.mrcrayfish.backpacked.platform.services.IBackpackHelper;
import java.util.concurrent.atomic.AtomicReference;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1886;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3989;
import org.jetbrains.annotations.Nullable;

public class FabricBackpackHelper
implements IBackpackHelper {
    @Override
    @Nullable
    public UnlockTracker getUnlockTracker(class_1657 player, boolean old) {
        return ((IUnlockTrackerHolder)player).backpackedGetUnlockTracker();
    }

    @Override
    public class_1799 getBackpackStack(class_1657 player) {
        AtomicReference<class_1799> backpack = new AtomicReference<class_1799>(class_1799.field_8037);
        if (Backpacked.isTrinketsLoaded()) {
            backpack.set(Trinkets.getBackpackStack(player));
        } else {
            ExtendedPlayerInventory inventory;
            class_1799 stack;
            class_1661 class_16612 = player.method_31548();
            if (class_16612 instanceof ExtendedPlayerInventory && (stack = (class_1799)(inventory = (ExtendedPlayerInventory)class_16612).getBackpackItems().get(0)).method_7909() instanceof BackpackItem) {
                backpack.set(stack);
            }
        }
        return backpack.get();
    }

    @Override
    public boolean setBackpackStack(class_1657 player, class_1799 stack) {
        if (!(stack.method_7909() instanceof BackpackItem) && !stack.method_7960()) {
            return false;
        }
        if (Backpacked.isTrinketsLoaded()) {
            Trinkets.setBackpackStack(player, stack);
            return true;
        }
        class_1661 class_16612 = player.method_31548();
        if (class_16612 instanceof ExtendedPlayerInventory) {
            ExtendedPlayerInventory inventory = (ExtendedPlayerInventory)class_16612;
            inventory.getBackpackItems().set(0, (Object)stack.method_7972());
            return true;
        }
        return false;
    }

    @Override
    public class_1886 getEnchantmentCategory() {
        return class_1886.field_23747;
    }

    @Override
    public boolean isUsingThirdPartySlot() {
        return Backpacked.isTrinketsLoaded();
    }

    @Override
    public boolean isBackpackVisible(class_1657 player) {
        return true;
    }

    @Override
    @Nullable
    public PickpocketChallenge getPickpocketChallenge(class_1297 entity) {
        PickpocketChallenge pickpocketChallenge;
        if (entity instanceof class_3989) {
            class_3989 trader = (class_3989)entity;
            pickpocketChallenge = ((IPickpocketChallengeHolder)trader).getPickpocketChallenge();
        } else {
            pickpocketChallenge = null;
        }
        return pickpocketChallenge;
    }

    @Override
    public ShelfBlockEntity createShelfBlockEntityType(class_2338 pos, class_2680 state) {
        return new ShelfBlockEntity(pos, state);
    }

    @Override
    public void openBackpackScreen(class_3222 openingPlayer, class_1263 inventory, int cols, int rows, boolean owner, class_2561 title) {
        openingPlayer.method_17355((class_3908)new BackpackScreenFactory(inventory, cols, rows, owner, title));
    }

    @Override
    public BackpackItem createBackpackItem(class_1792.class_1793 properties) {
        if (Backpacked.isTrinketsLoaded()) {
            return Trinkets.createTrinketBackpack(properties);
        }
        return new FabricBackpackItem(properties);
    }

    private record BackpackScreenFactory(class_1263 inventory, int cols, int rows, boolean owner, class_2561 title) implements ExtendedScreenHandlerFactory
    {
        public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
            buf.method_10804(this.cols);
            buf.method_10804(this.rows);
            buf.writeBoolean(this.owner);
        }

        public class_2561 method_5476() {
            return this.title;
        }

        public class_1703 createMenu(int windowId, class_1661 inventory, class_1657 player) {
            return new BackpackContainerMenu(windowId, player.method_31548(), this.inventory, this.cols, this.rows, this.owner);
        }
    }
}

