/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.gui.screen.inventory;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.client.Keys;
import com.mrcrayfish.backpacked.client.gui.ButtonAlignment;
import com.mrcrayfish.backpacked.client.gui.screen.CustomiseBackpackScreen;
import com.mrcrayfish.backpacked.client.gui.screen.widget.MiniButton;
import com.mrcrayfish.backpacked.inventory.container.BackpackContainerMenu;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageRequestCustomisation;
import com.mrcrayfish.backpacked.platform.ClientServices;
import com.mrcrayfish.framework.network.message.IMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5348;
import net.minecraft.class_757;
import net.minecraft.class_7919;

public class BackpackScreen
extends class_465<BackpackContainerMenu> {
    private static final class_2960 GUI_TEXTURE = new class_2960("backpacked", "textures/gui/backpack.png");
    private static final class_2561 CUSTOMISE_TOOLTIP = class_2561.method_43471((String)"backpacked.button.customise.tooltip");
    private static final class_2561 CONFIG_TOOLTIP = class_2561.method_43471((String)"backpacked.button.config.tooltip");
    private final int cols;
    private final int rows;
    private final boolean owner;
    private boolean opened;

    public BackpackScreen(BackpackContainerMenu backpackContainerMenu, class_1661 playerInventory, class_2561 titleIn) {
        super((class_1703)backpackContainerMenu, playerInventory, titleIn);
        this.cols = backpackContainerMenu.getCols();
        this.rows = backpackContainerMenu.getRows();
        this.owner = backpackContainerMenu.isOwner();
        this.field_2792 = 14 + Math.max(this.cols, 9) * 18;
        this.field_2779 = 114 + this.rows * 18;
        this.field_25269 = Math.max((this.cols * 18 - 162) / 2, 0) + 7;
        this.field_25270 = this.rows * 18 + 17 + 4;
    }

    public void method_25426() {
        super.method_25426();
        if (!this.opened) {
            this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_14581, (float)0.75f, (float)1.0f));
            this.opened = true;
        }
        List<MiniButton> buttons = this.gatherButtons();
        for (int i = 0; i < buttons.size(); ++i) {
            MiniButton button = buttons.get(i);
            switch ((ButtonAlignment)((Object)Config.CLIENT.buttonAlignment.get())) {
                case LEFT: {
                    int titleWidth = this.field_22787.field_1772.method_27525((class_5348)this.field_22785);
                    button.method_46421(this.field_2776 + titleWidth + 8 + 3 + i * 13);
                    break;
                }
                case RIGHT: {
                    button.method_46421(this.field_2776 + this.field_2792 - 7 - 10 - (buttons.size() - 1 - i) * 13);
                }
            }
            button.method_46419(this.field_2800 + 5);
            this.method_37063((class_364)button);
        }
    }

    private List<MiniButton> gatherButtons() {
        boolean canCustomise;
        ArrayList<MiniButton> buttons = new ArrayList<MiniButton>();
        boolean bl = canCustomise = this.owner && (Boolean)Config.SERVER.common.disableCustomisation.get() == false;
        if (canCustomise) {
            MiniButton customiseButton = new MiniButton(0, 0, 225, 0, CustomiseBackpackScreen.GUI_TEXTURE, onPress -> Network.getPlay().sendToServer((IMessage)new MessageRequestCustomisation()));
            customiseButton.method_47400(class_7919.method_47407((class_2561)CUSTOMISE_TOOLTIP));
            buttons.add(customiseButton);
        }
        if (!((Boolean)Config.CLIENT.hideConfigButton.get()).booleanValue()) {
            MiniButton configButton = new MiniButton(0, 0, 235, 0, CustomiseBackpackScreen.GUI_TEXTURE, onPress -> this.openConfigScreen());
            configButton.method_47400(class_7919.method_47407((class_2561)CONFIG_TOOLTIP));
            buttons.add(configButton);
        }
        return buttons;
    }

    public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(matrixStack);
        super.method_25394(matrixStack, mouseX, mouseY, partialTicks);
        this.method_2380(matrixStack, mouseX, mouseY);
    }

    protected void method_2389(class_4587 matrixStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)GUI_TEXTURE);
        this.drawBackgroundWindow(matrixStack, this.field_2776, this.field_2800, this.field_2792, this.field_2779);
    }

    protected void method_2388(class_4587 matrixStack, int mouseX, int mouseY) {
        this.field_22793.method_30883(matrixStack, this.field_22785, 8.0f, 6.0f, 0x404040);
        this.field_22793.method_30883(matrixStack, this.field_29347, (float)this.field_25269, (float)this.field_25270, 0x404040);
    }

    private void drawBackgroundWindow(class_4587 poseStack, int x, int y, int width, int height) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)GUI_TEXTURE);
        int backpackHeight = 17 + this.rows * 18;
        BackpackScreen.method_25293((class_4587)poseStack, (int)x, (int)y, (int)7, (int)backpackHeight, (float)0.0f, (float)0.0f, (int)7, (int)backpackHeight, (int)256, (int)256);
        BackpackScreen.method_25293((class_4587)poseStack, (int)(x + width - 7), (int)y, (int)7, (int)backpackHeight, (float)8.0f, (float)0.0f, (int)7, (int)backpackHeight, (int)256, (int)256);
        BackpackScreen.method_25293((class_4587)poseStack, (int)(x + 7), (int)y, (int)(width - 14), (int)backpackHeight, (float)7.0f, (float)0.0f, (int)1, (int)backpackHeight, (int)256, (int)256);
        int slotWidth = this.cols * 18;
        int slotHeight = this.rows * 18;
        int minSlotWidth = 162;
        int backpackStartX = Math.max((minSlotWidth - slotWidth) / 2, 0);
        BackpackScreen.method_25293((class_4587)poseStack, (int)(backpackStartX + x + 7), (int)(y + 17), (int)slotWidth, (int)slotHeight, (float)15.0f, (float)0.0f, (int)slotWidth, (int)slotHeight, (int)256, (int)256);
        BackpackScreen.method_25293((class_4587)poseStack, (int)x, (int)(y + backpackHeight), (int)7, (int)97, (float)0.0f, (float)143.0f, (int)7, (int)97, (int)256, (int)256);
        BackpackScreen.method_25293((class_4587)poseStack, (int)(x + width - 7), (int)(y + backpackHeight), (int)7, (int)97, (float)8.0f, (float)143.0f, (int)7, (int)97, (int)256, (int)256);
        BackpackScreen.method_25293((class_4587)poseStack, (int)(x + 7), (int)(y + backpackHeight), (int)(width - 14), (int)97, (float)7.0f, (float)143.0f, (int)1, (int)97, (int)256, (int)256);
        int inventoryStartX = Math.max((slotWidth - minSlotWidth) / 2, 0);
        BackpackScreen.method_25293((class_4587)poseStack, (int)(x + inventoryStartX + 7), (int)(y + backpackHeight + 14), (int)163, (int)76, (float)15.0f, (float)157.0f, (int)163, (int)76, (int)256, (int)256);
    }

    private void openConfigScreen() {
        ClientServices.SCREEN.openConfigScreen();
    }

    public boolean method_25404(int key, int scanCode, int action) {
        if (Keys.KEY_BACKPACK.method_1417(key, scanCode)) {
            this.method_25419();
            return true;
        }
        return super.method_25404(key, scanCode, action);
    }
}

