/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.data.tracker.impl;

import com.google.common.collect.ImmutableSet;
import com.mrcrayfish.backpacked.data.tracker.IProgressTracker;
import com.mrcrayfish.backpacked.data.tracker.ProgressFormatters;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1959;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;

public class BiomeExploreProgressTracker
implements IProgressTracker {
    private final ImmutableSet<class_5321<class_1959>> biomes;
    private final Set<class_2960> exploredBiomes = new HashSet<class_2960>();

    @SafeVarargs
    public BiomeExploreProgressTracker(class_5321<class_1959> ... biomes) {
        this.biomes = ImmutableSet.copyOf(Arrays.asList(biomes));
    }

    public void explore(class_5321<class_1959> biome, class_3222 player) {
        if (this.biomes.contains(biome)) {
            this.exploredBiomes.add(biome.method_29177());
            this.markForCompletionTest(player);
        }
    }

    @Override
    public boolean isComplete() {
        return this.exploredBiomes.size() >= this.biomes.size();
    }

    @Override
    public void read(class_2487 tag) {
        this.exploredBiomes.clear();
        class_2499 list = tag.method_10554("ExploredBiomes", 8);
        list.forEach(nbt -> {
            class_2960 id = class_2960.method_12829((String)nbt.method_10714());
            if (id != null && this.biomes.stream().anyMatch(key -> key.method_29177().equals((Object)id))) {
                this.exploredBiomes.add(id);
            }
        });
    }

    @Override
    public void write(class_2487 tag) {
        class_2499 list = new class_2499();
        this.exploredBiomes.forEach(location -> list.add((Object)class_2519.method_23256((String)location.toString())));
        tag.method_10566("ExploredBiomes", (class_2520)list);
    }

    @Override
    public class_2561 getDisplayComponent() {
        return ProgressFormatters.EXPLORED_X_OF_X.apply(this.exploredBiomes.size(), this.biomes.size());
    }
}

