/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.network.message;

import com.mrcrayfish.backpacked.common.backpack.ModelProperty;
import com.mrcrayfish.backpacked.network.play.ClientPlayHandler;
import com.mrcrayfish.framework.api.network.MessageContext;
import com.mrcrayfish.framework.api.network.message.PlayMessage;
import com.mrcrayfish.framework.api.util.ItemStackHelper;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;

public class MessageUpdateBackpack
extends PlayMessage<MessageUpdateBackpack> {
    private int entityId;
    private class_1799 backpack;
    private boolean fullTag;

    public MessageUpdateBackpack() {
    }

    public MessageUpdateBackpack(int entityId, class_1799 backpack) {
        this(entityId, backpack, false);
    }

    public MessageUpdateBackpack(int entityId, class_1799 backpack, boolean fullTag) {
        this.entityId = entityId;
        this.backpack = backpack;
        this.fullTag = fullTag;
    }

    public void encode(MessageUpdateBackpack message, class_2540 buffer) {
        buffer.writeInt(message.entityId);
        this.writeBackpack(buffer, message.backpack, message.fullTag);
    }

    public MessageUpdateBackpack decode(class_2540 buffer) {
        return new MessageUpdateBackpack(buffer.readInt(), buffer.method_10819());
    }

    public void handle(MessageUpdateBackpack message, MessageContext context) {
        context.execute(() -> ClientPlayHandler.handleUpdateBackpack(message));
        context.setHandled(true);
    }

    private void writeBackpack(class_2540 buffer, class_1799 stack, boolean fullTag) {
        if (!stack.method_7960()) {
            buffer.writeBoolean(true);
            buffer.method_10804(class_1792.method_7880((class_1792)stack.method_7909()));
            buffer.writeByte(stack.method_7947());
            buffer.method_10794(this.getBackpackTag(stack, fullTag));
            return;
        }
        buffer.writeBoolean(false);
    }

    @Nullable
    private class_2487 getBackpackTag(class_1799 stack, boolean fullTag) {
        class_1792 item = stack.method_7909();
        if (!ItemStackHelper.isDamageable((class_1799)stack) && !item.method_7887()) {
            return null;
        }
        class_2487 realTag = stack.method_7948();
        if (fullTag) {
            return realTag;
        }
        class_2487 tag = new class_2487();
        tag.method_10582("BackpackModel", realTag.method_10558("BackpackModel"));
        for (ModelProperty property : ModelProperty.values()) {
            String tagName = property.getTagName();
            boolean value = realTag.method_10573(tagName, 1) ? realTag.method_10577(tagName) : property.getDefaultValue();
            tag.method_10556(tagName, value);
        }
        tag.method_10566("Enchantments", (class_2520)stack.method_7921());
        tag.method_10566("display", (class_2520)stack.method_7911("display"));
        return tag;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public class_1799 getBackpack() {
        return this.backpack;
    }
}

