/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.blockentity;

import com.mrcrayfish.backpacked.block.ShelfBlock;
import com.mrcrayfish.backpacked.blockentity.IOptionalStorage;
import com.mrcrayfish.backpacked.core.ModBlockEntities;
import com.mrcrayfish.backpacked.core.ModSounds;
import com.mrcrayfish.backpacked.inventory.container.slot.BackpackSlot;
import com.mrcrayfish.backpacked.item.BackpackItem;
import com.mrcrayfish.backpacked.platform.Services;
import com.mrcrayfish.backpacked.util.BlockEntityUtil;
import com.mrcrayfish.backpacked.util.InventoryHelper;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;

public class ShelfBlockEntity
extends class_2586
implements IOptionalStorage {
    private class_1799 backpack = class_1799.field_8037;
    private class_1277 inventory = null;

    public ShelfBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public ShelfBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)ModBlockEntities.SHELF.get(), pos, state);
    }

    @Override
    @Nullable
    public class_1277 getInventory() {
        return this.inventory;
    }

    public class_1799 getBackpackWithContents() {
        class_1799 stack = this.backpack.method_7972();
        if (!stack.method_7960()) {
            this.copyInventoryToStack(stack);
        }
        return stack;
    }

    public class_1269 interact(class_1657 player) {
        if (player.method_18276() || this.backpack.method_7960()) {
            class_1799 stack = Services.BACKPACK.getBackpackStack(player);
            if (!stack.method_7960() && !(stack.method_7909() instanceof BackpackItem)) {
                if (!this.backpack.method_7960()) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"message.backpacked.occupied_back_slot"), true);
                }
                return class_1269.field_5814;
            }
            class_1799 result = this.shelveBackpack(stack);
            Services.BACKPACK.setBackpackStack(player, result);
        } else if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            this.openBackpackInventory(serverPlayer);
        }
        return class_1269.field_5812;
    }

    public class_1799 shelveBackpack(class_1799 stack) {
        class_1799 shelvedBackpack = this.backpack.method_7972();
        this.copyInventoryToStack(shelvedBackpack);
        this.backpack = stack.method_7972();
        if (!this.backpack.method_7960() || !shelvedBackpack.method_7960()) {
            boolean removed = this.backpack.method_7960();
            this.updateInventory(false);
            BlockEntityUtil.sendUpdatePacket(this);
            this.field_11863.method_8396(null, this.field_11867, (class_3414)ModSounds.ITEM_BACKPACK_PLACE.get(), class_3419.field_15245, 1.0f, removed ? 0.75f : 1.0f);
            this.method_5431();
        }
        return shelvedBackpack;
    }

    private void openBackpackInventory(class_3222 player) {
        this.getBackpackInventory().ifPresent(inventory -> this.getBackpackItem().ifPresent(backpackItem -> {
            class_2561 title = this.backpack.method_7938() ? this.backpack.method_7964() : BackpackItem.BACKPACK_TRANSLATION;
            int cols = backpackItem.getColumnCount();
            int rows = backpackItem.getRowCount();
            Services.BACKPACK.openBackpackScreen(player, (class_1263)inventory, cols, rows, false, title);
        }));
    }

    private void copyInventoryToStack(class_1799 stack) {
        if (!stack.method_7960()) {
            this.getBackpackInventory().ifPresent(inventory -> stack.method_7948().method_10566("Items", (class_2520)InventoryHelper.saveAllItems(new class_2499(), inventory)));
        }
    }

    private Optional<class_1277> getBackpackInventory() {
        if (this.backpack.method_7960()) {
            return Optional.empty();
        }
        if (this.inventory != null && this.inventory.method_5439() != this.getBackpackSize()) {
            this.updateInventory(true);
        }
        return Optional.ofNullable(this.inventory);
    }

    private void updateInventory(boolean resized) {
        if (!this.backpack.method_7960()) {
            class_1277 oldInventory = this.inventory;
            this.inventory = new ShelfContainer(this.getBackpackSize());
            class_2487 compound = this.backpack.method_7948();
            this.loadBackpackItems(compound);
            compound.method_10551("Items");
            if (resized && oldInventory != null) {
                InventoryHelper.mergeInventory(oldInventory, this.inventory, this.field_11863, class_243.method_24953((class_2382)this.field_11867));
            }
        } else {
            this.inventory = null;
        }
    }

    private void loadBackpackItems(class_2487 compound) {
        if (compound.method_10573("Items", 9)) {
            InventoryHelper.loadAllItems(compound.method_10554("Items", 10), this.inventory, this.field_11863, class_243.method_24953((class_2382)this.field_11867));
        }
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.backpack = class_1799.method_7915((class_2487)tag.method_10562("Backpack"));
        this.inventory = this.backpack.method_7960() ? null : new ShelfContainer(this.getBackpackSize());
        this.loadBackpackItems(tag);
    }

    protected void method_11007(class_2487 tag) {
        tag.method_10566("Backpack", (class_2520)this.backpack.method_7953(new class_2487()));
        if (this.inventory != null) {
            class_2499 items = new class_2499();
            InventoryHelper.saveAllItems(items, this.inventory);
            tag.method_10566("Items", (class_2520)items);
        }
    }

    public class_2487 method_16887() {
        return this.method_38242();
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_1799 getBackpack() {
        return this.backpack;
    }

    public class_2350 getDirection() {
        return (class_2350)this.method_11010().method_11654((class_2769)ShelfBlock.field_11177);
    }

    private Optional<BackpackItem> getBackpackItem() {
        if (this.backpack.method_7909() instanceof BackpackItem) {
            return Optional.of((BackpackItem)this.backpack.method_7909());
        }
        return Optional.empty();
    }

    private int getBackpackSize() {
        return this.getBackpackItem().map(item -> item.getRowCount() * item.getColumnCount()).orElse(0);
    }

    @Override
    public boolean method_5437(int index, class_1799 stack) {
        return !BackpackSlot.isBannedItem(stack);
    }

    public class ShelfContainer
    extends class_1277 {
        public ShelfContainer(int size) {
            super(size);
        }

        public void method_5431() {
            super.method_5431();
            ShelfBlockEntity.this.method_5431();
        }

        public boolean method_5443(class_1657 player) {
            return ShelfBlockEntity.this.inventory == this && !ShelfBlockEntity.this.backpack.method_7960() && !ShelfBlockEntity.this.field_11865;
        }
    }
}

