/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.renderer.entity.layers;

import com.mrcrayfish.backpacked.client.model.ModelInstances;
import com.mrcrayfish.backpacked.client.model.backpack.BackpackModel;
import com.mrcrayfish.backpacked.common.backpack.ModelProperty;
import com.mrcrayfish.backpacked.item.BackpackItem;
import com.mrcrayfish.backpacked.platform.Services;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_591;
import net.minecraft.class_918;

public class BackpackLayer<T extends class_1657, M extends class_591<T>>
extends class_3887<T, M> {
    private static final Map<String, Supplier<BackpackModel>> VARIANTS = new HashMap<String, Supplier<BackpackModel>>();
    private static final Supplier<BackpackModel> DEFAULT_SUPPLIER = () -> ModelInstances.get().getStandardModel();

    public BackpackLayer(class_3883<T, M> renderer) {
        super(renderer);
    }

    public void render(class_4587 stack, class_4597 renderTypeBuffer, int p_225628_3_, T player, float p_225628_5_, float p_225628_6_, float partialTick, float p_225628_8_, float p_225628_9_, float p_225628_10_) {
        class_1799 backpack = Services.BACKPACK.getBackpackStack((class_1657)player);
        class_1792 class_17922 = backpack.method_7909();
        if (class_17922 instanceof BackpackItem) {
            BackpackItem backpackItem = (BackpackItem)class_17922;
            class_1799 chestStack = player.method_6118(class_1304.field_6174);
            if (chestStack.method_7909() == class_1802.field_8833 && !BackpackLayer.canRenderWithElytra(backpack)) {
                return;
            }
            if (Services.BACKPACK.isUsingThirdPartySlot() && !Services.BACKPACK.isBackpackVisible((class_1657)player)) {
                return;
            }
            String modelName = backpack.method_7948().method_10558("BackpackModel");
            BackpackModel model = VARIANTS.getOrDefault(modelName, DEFAULT_SUPPLIER).get();
            if (model == null) {
                return;
            }
            stack.method_22903();
            model.transformToPlayerBody(((class_591)this.method_17165()).field_3391, !chestStack.method_7960());
            model.setupAngles((class_1657)player, ((class_1657)player).field_6012, partialTick);
            class_4588 builder = class_918.method_23181((class_4597)renderTypeBuffer, (class_1921)model.method_23500(model.getTextureLocation()), (boolean)false, (backpack.method_7958() && BackpackLayer.canShowEnchantmentGlint(backpack) ? 1 : 0) != 0);
            model.method_2828(stack, builder, p_225628_3_, class_4608.field_21444, 1.0f, 2.0f, 2.0f, 2.0f);
            stack.method_22909();
        }
    }

    public static boolean canRenderWithElytra(class_1799 stack) {
        return stack.method_7948().method_10577(ModelProperty.SHOW_WITH_ELYTRA.getTagName());
    }

    public static boolean canShowEnchantmentGlint(class_1799 stack) {
        return stack.method_7948().method_10577(ModelProperty.SHOW_GLINT.getTagName());
    }

    public static synchronized void registerModel(class_2960 id, Supplier<BackpackModel> model) {
        VARIANTS.putIfAbsent(id.toString(), model);
    }

    public static Supplier<BackpackModel> getModel(String id) {
        return VARIANTS.getOrDefault(id, DEFAULT_SUPPLIER);
    }
}

