/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.data.tracker;

import com.mrcrayfish.backpacked.common.backpack.BackpackManager;
import com.mrcrayfish.backpacked.data.tracker.UnlockTracker;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageSyncUnlockTracker;
import com.mrcrayfish.backpacked.platform.Services;
import com.mrcrayfish.framework.api.event.IFrameworkEvent;
import com.mrcrayfish.framework.api.event.PlayerEvents;
import com.mrcrayfish.framework.api.event.TickEvents;
import com.mrcrayfish.framework.event.IPlayerEvent;
import com.mrcrayfish.framework.event.ITickEvent;
import com.mrcrayfish.framework.network.message.IMessage;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public class UnlockManager {
    private static final Set<class_3222> testForCompletion = new HashSet<class_3222>();

    public static void init() {
        PlayerEvents.COPY.register((IFrameworkEvent)((IPlayerEvent.Copy)UnlockManager::onPlayerClone));
        PlayerEvents.LOGGED_IN.register((IFrameworkEvent)((IPlayerEvent.LoggedIn)UnlockManager::onPlayerLoggedIn));
        PlayerEvents.RESPAWN.register((IFrameworkEvent)((IPlayerEvent.Respawn)UnlockManager::onPlayerRespawn));
        PlayerEvents.CHANGE_DIMENSION.register((IFrameworkEvent)((IPlayerEvent.ChangeDimension)UnlockManager::onPlayerChangedDimension));
        TickEvents.END_SERVER.register((IFrameworkEvent)((ITickEvent.EndServer)UnlockManager::onServerTick));
    }

    static void queuePlayerForCompletionTest(class_3222 player) {
        testForCompletion.add(player);
    }

    public static Optional<UnlockTracker> get(class_1657 player) {
        return UnlockManager.get(player, false);
    }

    private static Optional<UnlockTracker> get(class_1657 player, boolean old) {
        return Optional.ofNullable(Services.BACKPACK.getUnlockTracker(player, old));
    }

    private static void onPlayerClone(class_1657 oldPlayer, class_1657 newPlayer, boolean respawn) {
        UnlockManager.get(oldPlayer, true).ifPresent(originalTracker -> UnlockManager.get(newPlayer).ifPresent(newTracker -> {
            newTracker.setUnlockedBackpacks(originalTracker.getUnlockedBackpacks());
            originalTracker.getProgressTrackerMap().forEach((location, progressTracker) -> {
                class_2487 tag = new class_2487();
                progressTracker.write(tag);
                Optional.ofNullable(newTracker.getProgressTrackerMap().get(location)).ifPresent(t -> t.read(tag));
            });
        }));
    }

    private static void onPlayerLoggedIn(class_1657 player) {
        UnlockManager.get(player).ifPresent(unlockTracker -> Network.getPlay().sendToPlayer(() -> (class_3222)player, (IMessage)new MessageSyncUnlockTracker(unlockTracker.getUnlockedBackpacks())));
    }

    private static void onPlayerRespawn(class_1657 player, boolean finishedGame) {
        UnlockManager.get(player).ifPresent(unlockTracker -> Network.getPlay().sendToPlayer(() -> (class_3222)player, (IMessage)new MessageSyncUnlockTracker(unlockTracker.getUnlockedBackpacks())));
    }

    private static void onPlayerChangedDimension(class_1657 player, class_5321<class_1937> oldDimension, class_5321<class_1937> newDimension) {
        UnlockManager.get(player).ifPresent(unlockTracker -> Network.getPlay().sendToPlayer(() -> (class_3222)player, (IMessage)new MessageSyncUnlockTracker(unlockTracker.getUnlockedBackpacks())));
    }

    private static void onServerTick(MinecraftServer server) {
        if (testForCompletion.isEmpty()) {
            return;
        }
        for (class_3222 player : testForCompletion) {
            UnlockManager.get((class_1657)player).ifPresent(unlockTracker -> unlockTracker.getProgressTrackerMap().forEach((location, progressTracker) -> {
                if (!unlockTracker.getUnlockedBackpacks().contains(location) && progressTracker.isComplete()) {
                    BackpackManager.instance().unlockBackpack(player, (class_2960)location);
                }
            }));
        }
        testForCompletion.clear();
    }
}

