/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.data.tracker;

import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.common.backpack.BackpackManager;
import com.mrcrayfish.backpacked.data.tracker.IProgressTracker;
import com.mrcrayfish.backpacked.util.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public class UnlockTracker
implements Serializable {
    private final Set<class_2960> unlockedBackpacks = new HashSet<class_2960>();
    private final Map<class_2960, IProgressTracker> progressTrackerMap;

    public UnlockTracker() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        BackpackManager.instance().getRegisteredBackpacks().forEach(backpack -> {
            IProgressTracker tracker = backpack.createProgressTracker();
            if (tracker != null) {
                builder.put((Object)backpack.getId(), (Object)tracker);
            }
        });
        this.progressTrackerMap = builder.build();
    }

    public Set<class_2960> getUnlockedBackpacks() {
        return Collections.unmodifiableSet(this.unlockedBackpacks);
    }

    public Map<class_2960, IProgressTracker> getProgressTrackerMap() {
        return this.progressTrackerMap;
    }

    void setUnlockedBackpacks(Set<class_2960> unlockedBackpacks) {
        this.unlockedBackpacks.clear();
        this.unlockedBackpacks.addAll(unlockedBackpacks);
    }

    public boolean isUnlocked(class_2960 id) {
        return this.unlockedBackpacks.contains(id);
    }

    public Optional<IProgressTracker> getProgressTracker(class_2960 id) {
        if (!((Boolean)Config.SERVER.common.unlockAllBackpacks.get()).booleanValue() && !this.unlockedBackpacks.contains(id)) {
            return Optional.ofNullable(this.progressTrackerMap.get(id));
        }
        return Optional.empty();
    }

    public boolean unlockBackpack(class_2960 id) {
        if (BackpackManager.instance().getBackpack(id) != null) {
            return this.unlockedBackpacks.add(id);
        }
        return false;
    }

    @Override
    public class_2487 serialize() {
        class_2487 tag = new class_2487();
        class_2499 unlockedBackpacks = new class_2499();
        this.unlockedBackpacks.forEach(location -> unlockedBackpacks.add((Object)class_2519.method_23256((String)location.toString())));
        tag.method_10566("UnlockedBackpacks", (class_2520)unlockedBackpacks);
        class_2499 progressTrackers = new class_2499();
        this.progressTrackerMap.forEach((location, progressTracker) -> {
            class_2487 progressTag = new class_2487();
            progressTag.method_10582("Id", location.toString());
            class_2487 dataTag = new class_2487();
            progressTracker.write(dataTag);
            progressTag.method_10566("Data", (class_2520)dataTag);
            progressTrackers.add((Object)progressTag);
        });
        tag.method_10566("ProgressTrackers", (class_2520)progressTrackers);
        return tag;
    }

    @Override
    public void deserialize(class_2487 tag) {
        this.unlockedBackpacks.clear();
        class_2499 unlockedBackpacks = tag.method_10554("UnlockedBackpacks", 8);
        unlockedBackpacks.forEach(t -> this.unlockedBackpacks.add(class_2960.method_12829((String)t.method_10714())));
        class_2499 progressTrackers = tag.method_10554("ProgressTrackers", 10);
        progressTrackers.forEach(t -> {
            class_2487 progressTag = (class_2487)t;
            class_2960 id = new class_2960(progressTag.method_10558("Id"));
            IProgressTracker tracker = this.progressTrackerMap.get(id);
            if (tracker != null) {
                class_2487 dataTag = progressTag.method_10562("Data");
                tracker.read(dataTag);
            }
        });
    }
}

