/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.mixin.common;

import com.mojang.authlib.GameProfile;
import com.mrcrayfish.backpacked.Backpacked;
import com.mrcrayfish.backpacked.common.UnlockTracker;
import com.mrcrayfish.backpacked.common.backpack.RocketBackpack;
import com.mrcrayfish.backpacked.common.tracker.CountProgressTracker;
import com.mrcrayfish.backpacked.core.ModEnchantments;
import com.mrcrayfish.backpacked.inventory.BackpackInventory;
import com.mrcrayfish.backpacked.inventory.BackpackedInventoryAccess;
import com.mrcrayfish.backpacked.inventory.ExtendedPlayerInventory;
import com.mrcrayfish.backpacked.inventory.container.ExtendedPlayerContainer;
import com.mrcrayfish.backpacked.item.BackpackItem;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={Player.class})
public class PlayerEntityMixin
implements BackpackedInventoryAccess {
    @Shadow
    @Final
    @Mutable
    private Inventory f_36093_;
    @Shadow
    @Final
    @Mutable
    public InventoryMenu f_36095_;
    @Unique
    public BackpackInventory backpackedInventory = null;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void constructorTail(Level world, BlockPos pos, float spawnAngle, GameProfile profile, CallbackInfo ci) {
        if (Backpacked.isCuriosLoaded()) {
            return;
        }
        Player player = (Player)this;
        this.f_36093_ = new ExtendedPlayerInventory(player);
        this.f_36095_ = new ExtendedPlayerContainer(this.f_36093_, !world.f_46443_, player);
        player.f_36096_ = this.f_36095_;
    }

    @Override
    @Nullable
    public BackpackInventory getBackpackedInventory() {
        Player player = (Player)this;
        ItemStack stack = Backpacked.getBackpackStack(player);
        if (stack.m_41619_()) {
            this.backpackedInventory = null;
            return null;
        }
        BackpackItem backpackItem = (BackpackItem)stack.m_41720_();
        if (this.backpackedInventory == null || !this.backpackedInventory.getBackpackStack().equals(stack) || this.backpackedInventory.m_6643_() != backpackItem.getRowCount() * backpackItem.getColumnCount()) {
            this.backpackedInventory = new BackpackInventory(backpackItem.getColumnCount(), backpackItem.getRowCount(), player, stack);
        }
        return this.backpackedInventory;
    }

    @Inject(method={"checkMovementStatistics"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;awardStat(Lnet/minecraft/resources/ResourceLocation;I)V", ordinal=7)})
    public void onFallFlying(double dx, double dy, double dz, CallbackInfo ci) {
        Player player = (Player)this;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        int distance = (int)Math.round(Math.sqrt(dx * dx + dy * dy + dz * dz));
        UnlockTracker.get(player).ifPresent(unlockTracker -> unlockTracker.getProgressTracker(RocketBackpack.ID).ifPresent(progressTracker -> {
            CountProgressTracker tracker = (CountProgressTracker)progressTracker;
            tracker.increment(distance, (ServerPlayer)player);
        }));
    }

    @Inject(method={"getProjectile"}, at={@At(value="RETURN", ordinal=3)}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD)
    public void locateAmmo(ItemStack stack, CallbackInfoReturnable<ItemStack> cir, Predicate<ItemStack> predicate) {
        Player player = (Player)this;
        ItemStack backpack = Backpacked.getBackpackStack(player);
        if (backpack.m_41619_()) {
            return;
        }
        if (EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.MARKSMAN.get()), (ItemStack)backpack) <= 0) {
            return;
        }
        BackpackInventory inventory = ((BackpackedInventoryAccess)player).getBackpackedInventory();
        if (inventory == null) {
            return;
        }
        ItemStack projectile = IntStream.range(0, inventory.m_6643_()).mapToObj(arg_0 -> ((BackpackInventory)inventory).m_8020_(arg_0)).filter(predicate).findFirst().orElse(ItemStack.f_41583_);
        if (!projectile.m_41619_()) {
            cir.setReturnValue((Object)projectile);
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void tickBackpacked(CallbackInfo ci) {
        if (this.backpackedInventory != null) {
            this.backpackedInventory.tick();
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="HEAD")})
    public void addAdditionalSaveDataBackpacked(CompoundTag tag, CallbackInfo ci) {
        if (this.backpackedInventory != null) {
            this.backpackedInventory.saveItemsToStack();
        }
    }
}

